/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.Account;
import org.stellar.sdk.Asset;
import org.stellar.sdk.FeeBumpTransaction;
import org.stellar.sdk.Memo;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.exception.AccountRequiresMemoException;
import org.stellar.sdk.exception.BadRequestException;
import org.stellar.sdk.exception.ConnectionErrorException;
import org.stellar.sdk.exception.RequestTimeoutException;
import org.stellar.sdk.operations.AccountMergeOperation;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.operations.PathPaymentStrictReceiveOperation;
import org.stellar.sdk.operations.PathPaymentStrictSendOperation;
import org.stellar.sdk.operations.PaymentOperation;
import org.stellar.sdk.requests.AccountsRequestBuilder;
import org.stellar.sdk.requests.AssetsRequestBuilder;
import org.stellar.sdk.requests.ClaimableBalancesRequestBuilder;
import org.stellar.sdk.requests.ClientIdentificationInterceptor;
import org.stellar.sdk.requests.EffectsRequestBuilder;
import org.stellar.sdk.requests.FeeStatsRequestBuilder;
import org.stellar.sdk.requests.LedgersRequestBuilder;
import org.stellar.sdk.requests.LiquidityPoolsRequestBuilder;
import org.stellar.sdk.requests.OffersRequestBuilder;
import org.stellar.sdk.requests.OperationsRequestBuilder;
import org.stellar.sdk.requests.OrderBookRequestBuilder;
import org.stellar.sdk.requests.PaymentsRequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.RootRequestBuilder;
import org.stellar.sdk.requests.StrictReceivePathsRequestBuilder;
import org.stellar.sdk.requests.StrictSendPathsRequestBuilder;
import org.stellar.sdk.requests.TradeAggregationsRequestBuilder;
import org.stellar.sdk.requests.TradesRequestBuilder;
import org.stellar.sdk.requests.TransactionsRequestBuilder;
import org.stellar.sdk.responses.AccountResponse;
import org.stellar.sdk.responses.SubmitTransactionAsyncResponse;
import org.stellar.sdk.responses.TransactionResponse;
import org.stellar.sdk.xdr.CryptoKeyType;

public class Server
implements Closeable {
    private final HttpUrl serverURI;
    private OkHttpClient httpClient;
    private OkHttpClient submitHttpClient;
    private static final int HORIZON_SUBMIT_TIMEOUT = 60;
    private static final String ACCOUNT_REQUIRES_MEMO_VALUE = "MQ==";
    private static final String ACCOUNT_REQUIRES_MEMO_KEY = "config.memo_required";

    public Server(String uri) {
        this(uri, new OkHttpClient.Builder().addInterceptor(new ClientIdentificationInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build(), new OkHttpClient.Builder().addInterceptor(new ClientIdentificationInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(65L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build());
    }

    public Server(String serverURI, OkHttpClient httpClient, OkHttpClient submitHttpClient) {
        this.serverURI = HttpUrl.parse(serverURI);
        this.httpClient = httpClient;
        this.submitHttpClient = submitHttpClient;
    }

    public TransactionBuilderAccount loadAccount(String address) {
        MuxedAccount muxedAccount = new MuxedAccount(address);
        AccountResponse accountResponse = this.accounts().account(muxedAccount.getAccountId());
        return new Account(address, accountResponse.getSequenceNumber());
    }

    public RootRequestBuilder root() {
        return new RootRequestBuilder(this.httpClient, this.serverURI);
    }

    public AccountsRequestBuilder accounts() {
        return new AccountsRequestBuilder(this.httpClient, this.serverURI);
    }

    public AssetsRequestBuilder assets() {
        return new AssetsRequestBuilder(this.httpClient, this.serverURI);
    }

    public ClaimableBalancesRequestBuilder claimableBalances() {
        return new ClaimableBalancesRequestBuilder(this.httpClient, this.serverURI);
    }

    public EffectsRequestBuilder effects() {
        return new EffectsRequestBuilder(this.httpClient, this.serverURI);
    }

    public LedgersRequestBuilder ledgers() {
        return new LedgersRequestBuilder(this.httpClient, this.serverURI);
    }

    public OffersRequestBuilder offers() {
        return new OffersRequestBuilder(this.httpClient, this.serverURI);
    }

    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.httpClient, this.serverURI);
    }

    public FeeStatsRequestBuilder feeStats() {
        return new FeeStatsRequestBuilder(this.httpClient, this.serverURI);
    }

    public OrderBookRequestBuilder orderBook() {
        return new OrderBookRequestBuilder(this.httpClient, this.serverURI);
    }

    public TradesRequestBuilder trades() {
        return new TradesRequestBuilder(this.httpClient, this.serverURI);
    }

    public TradeAggregationsRequestBuilder tradeAggregations(Asset baseAsset, Asset counterAsset, long startTime, long endTime, long resolution, long offset) {
        return new TradeAggregationsRequestBuilder(this.httpClient, this.serverURI, baseAsset, counterAsset, startTime, endTime, resolution, offset);
    }

    public StrictReceivePathsRequestBuilder strictReceivePaths() {
        return new StrictReceivePathsRequestBuilder(this.httpClient, this.serverURI);
    }

    public StrictSendPathsRequestBuilder strictSendPaths() {
        return new StrictSendPathsRequestBuilder(this.httpClient, this.serverURI);
    }

    public PaymentsRequestBuilder payments() {
        return new PaymentsRequestBuilder(this.httpClient, this.serverURI);
    }

    public TransactionsRequestBuilder transactions() {
        return new TransactionsRequestBuilder(this.httpClient, this.serverURI);
    }

    public LiquidityPoolsRequestBuilder liquidityPools() {
        return new LiquidityPoolsRequestBuilder(this.httpClient, this.serverURI);
    }

    public TransactionResponse submitTransactionXdr(String transactionXdr) {
        Response response;
        HttpUrl transactionsURI = this.serverURI.newBuilder().addPathSegment("transactions").build();
        FormBody requestBody = new FormBody.Builder().add("tx", transactionXdr).build();
        Request submitTransactionRequest = new Request.Builder().url(transactionsURI).post(requestBody).build();
        TypeToken<TransactionResponse> type = new TypeToken<TransactionResponse>(){};
        ResponseHandler<TransactionResponse> responseHandler = new ResponseHandler<TransactionResponse>(type);
        try {
            response = this.submitHttpClient.newCall(submitTransactionRequest).execute();
        }
        catch (SocketTimeoutException e) {
            throw new RequestTimeoutException(e);
        }
        catch (IOException e) {
            throw new ConnectionErrorException(e);
        }
        return responseHandler.handleResponse(response);
    }

    public TransactionResponse submitTransaction(Transaction transaction, boolean skipMemoRequiredCheck) {
        if (!skipMemoRequiredCheck) {
            this.checkMemoRequired(transaction);
        }
        return this.submitTransactionXdr(transaction.toEnvelopeXdrBase64());
    }

    public TransactionResponse submitTransaction(FeeBumpTransaction transaction, boolean skipMemoRequiredCheck) {
        if (!skipMemoRequiredCheck) {
            this.checkMemoRequired(transaction.getInnerTransaction());
        }
        return this.submitTransactionXdr(transaction.toEnvelopeXdrBase64());
    }

    public TransactionResponse submitTransaction(Transaction transaction) {
        return this.submitTransaction(transaction, false);
    }

    public TransactionResponse submitTransaction(FeeBumpTransaction transaction) {
        return this.submitTransaction(transaction, false);
    }

    public SubmitTransactionAsyncResponse submitTransactionXdrAsync(String transactionXdr) {
        Response response;
        HttpUrl transactionsURI = this.serverURI.newBuilder().addPathSegment("transactions_async").build();
        FormBody requestBody = new FormBody.Builder().add("tx", transactionXdr).build();
        Request submitTransactionRequest = new Request.Builder().url(transactionsURI).post(requestBody).build();
        TypeToken<SubmitTransactionAsyncResponse> type = new TypeToken<SubmitTransactionAsyncResponse>(){};
        ResponseHandler<SubmitTransactionAsyncResponse> responseHandler = new ResponseHandler<SubmitTransactionAsyncResponse>(type);
        try {
            response = this.submitHttpClient.newCall(submitTransactionRequest).execute();
        }
        catch (SocketTimeoutException e) {
            throw new RequestTimeoutException(e);
        }
        catch (IOException e) {
            throw new ConnectionErrorException(e);
        }
        return responseHandler.handleResponse(response, true);
    }

    public SubmitTransactionAsyncResponse submitTransactionAsync(Transaction transaction, boolean skipMemoRequiredCheck) {
        if (!skipMemoRequiredCheck) {
            this.checkMemoRequired(transaction);
        }
        return this.submitTransactionXdrAsync(transaction.toEnvelopeXdrBase64());
    }

    public SubmitTransactionAsyncResponse submitTransactionAsync(FeeBumpTransaction transaction, boolean skipMemoRequiredCheck) {
        if (!skipMemoRequiredCheck) {
            this.checkMemoRequired(transaction.getInnerTransaction());
        }
        return this.submitTransactionXdrAsync(transaction.toEnvelopeXdrBase64());
    }

    public SubmitTransactionAsyncResponse submitTransactionAsync(Transaction transaction) {
        return this.submitTransactionAsync(transaction, false);
    }

    public SubmitTransactionAsyncResponse submitTransactionAsync(FeeBumpTransaction transaction) {
        return this.submitTransactionAsync(transaction, false);
    }

    private boolean hashMemoId(String muxedAccount) {
        return StrKey.encodeToXDRMuxedAccount(muxedAccount).getDiscriminant() == CryptoKeyType.KEY_TYPE_MUXED_ED25519;
    }

    private void checkMemoRequired(Transaction transaction) {
        if (!transaction.getMemo().equals(Memo.none())) {
            return;
        }
        HashSet<String> destinations = new HashSet<String>();
        Operation[] operations = transaction.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            AccountResponse.Data data;
            String destination;
            Operation operation = operations[i];
            if (operation instanceof PaymentOperation) {
                destination = ((PaymentOperation)operation).getDestination();
            } else if (operation instanceof PathPaymentStrictReceiveOperation) {
                destination = ((PathPaymentStrictReceiveOperation)operation).getDestination();
            } else if (operation instanceof PathPaymentStrictSendOperation) {
                destination = ((PathPaymentStrictSendOperation)operation).getDestination();
            } else {
                if (!(operation instanceof AccountMergeOperation)) continue;
                destination = ((AccountMergeOperation)operation).getDestination();
            }
            if (destinations.contains(destination) || this.hashMemoId(destination)) continue;
            destinations.add(destination);
            try {
                data = this.accounts().account(destination).getData();
            }
            catch (BadRequestException e) {
                if (e.getCode() == 404) continue;
                throw e;
            }
            if (!ACCOUNT_REQUIRES_MEMO_VALUE.equals(data.get(ACCOUNT_REQUIRES_MEMO_KEY))) continue;
            throw new AccountRequiresMemoException("Destination account requires a memo in the transaction.", destination, i);
        }
    }

    @Override
    public void close() {
        this.httpClient.connectionPool().evictAll();
        this.submitHttpClient.connectionPool().evictAll();
    }

    @Generated
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Generated
    public OkHttpClient getSubmitHttpClient() {
        return this.submitHttpClient;
    }

    @Generated
    public void setSubmitHttpClient(OkHttpClient submitHttpClient) {
        this.submitHttpClient = submitHttpClient;
    }
}

