/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.ChangeTrustAsset;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ChangeTrustOperation
extends Operation {
    @NonNull
    private final ChangeTrustAsset asset;
    @NonNull
    private final BigDecimal limit;

    public static ChangeTrustOperation fromXdr(ChangeTrustOp op) {
        ChangeTrustAsset asset = ChangeTrustAsset.fromXdr(op.getLine());
        BigDecimal limit = Operation.fromXdrAmount(op.getLimit().getInt64());
        return new ChangeTrustOperation(asset, limit);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ChangeTrustOp op = new ChangeTrustOp();
        op.setLine(this.asset.toXdr());
        Int64 limit = new Int64();
        limit.setInt64(Operation.toXdrAmount(this.limit));
        op.setLimit(limit);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CHANGE_TRUST);
        body.setChangeTrustOp(op);
        return body;
    }

    @Generated
    protected ChangeTrustOperation(ChangeTrustOperationBuilder<?, ?> b) {
        super(b);
        this.asset = ((ChangeTrustOperationBuilder)b).asset;
        if (this.asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.limit = ((ChangeTrustOperationBuilder)b).limit;
        if (this.limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
    }

    @Generated
    public static ChangeTrustOperationBuilder<?, ?> builder() {
        return new ChangeTrustOperationBuilderImpl();
    }

    @Generated
    public ChangeTrustOperationBuilder<?, ?> toBuilder() {
        return new ChangeTrustOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public ChangeTrustAsset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public BigDecimal getLimit() {
        return this.limit;
    }

    @Generated
    public String toString() {
        return "ChangeTrustOperation(super=" + super.toString() + ", asset=" + this.getAsset() + ", limit=" + this.getLimit() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTrustOperation)) {
            return false;
        }
        ChangeTrustOperation other = (ChangeTrustOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChangeTrustAsset this$asset = this.getAsset();
        ChangeTrustAsset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        BigDecimal this$limit = this.getLimit();
        BigDecimal other$limit = other.getLimit();
        return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeTrustOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ChangeTrustAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        BigDecimal $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        return result;
    }

    @Generated
    private ChangeTrustOperation(@NonNull ChangeTrustAsset asset, @NonNull BigDecimal limit) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        this.asset = asset;
        this.limit = limit;
    }

    public static abstract class ChangeTrustOperationBuilder<C extends ChangeTrustOperation, B extends ChangeTrustOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private ChangeTrustAsset asset;
        @Generated
        private BigDecimal limit;

        public B limit(@NonNull BigDecimal limit) {
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.limit = Operation.formatAmountScale(limit);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ChangeTrustOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ChangeTrustOperation instance, ChangeTrustOperationBuilder<?, ?> b) {
            b.asset(instance.asset);
            b.limit(instance.limit);
        }

        @Generated
        public B asset(@NonNull ChangeTrustAsset asset) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            this.asset = asset;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ChangeTrustOperation.ChangeTrustOperationBuilder(super=" + super.toString() + ", asset=" + this.asset + ", limit=" + this.limit + ")";
        }
    }

    @Generated
    private static final class ChangeTrustOperationBuilderImpl
    extends ChangeTrustOperationBuilder<ChangeTrustOperation, ChangeTrustOperationBuilderImpl> {
        @Generated
        private ChangeTrustOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected ChangeTrustOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ChangeTrustOperation build() {
            return new ChangeTrustOperation(this);
        }
    }
}

