/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPool;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PoolID;

public class LiquidityPoolWithdrawOperation
extends Operation {
    @NonNull
    private final String liquidityPoolId;
    @NonNull
    private final BigDecimal amount;
    @NonNull
    private final BigDecimal minAmountA;
    @NonNull
    private final BigDecimal minAmountB;

    public LiquidityPoolWithdrawOperation(@NonNull Asset assetA, @NonNull BigDecimal minAmountA, @NonNull Asset assetB, @NonNull BigDecimal minAmountB, @NonNull BigDecimal amount) {
        if (assetA == null) {
            throw new NullPointerException("assetA is marked non-null but is null");
        }
        if (minAmountA == null) {
            throw new NullPointerException("minAmountA is marked non-null but is null");
        }
        if (assetB == null) {
            throw new NullPointerException("assetB is marked non-null but is null");
        }
        if (minAmountB == null) {
            throw new NullPointerException("minAmountB is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.liquidityPoolId = new LiquidityPool(assetA, assetB).getLiquidityPoolId();
        this.amount = amount;
        this.minAmountA = minAmountA;
        this.minAmountB = minAmountB;
    }

    public static LiquidityPoolWithdrawOperation fromXdr(LiquidityPoolWithdrawOp op) {
        String liquidityPoolId = Util.bytesToHex(op.getLiquidityPoolID().getPoolID().getHash()).toLowerCase();
        BigDecimal amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        BigDecimal minAmountA = Operation.fromXdrAmount(op.getMinAmountA().getInt64());
        BigDecimal minAmountB = Operation.fromXdrAmount(op.getMinAmountB().getInt64());
        return new LiquidityPoolWithdrawOperation(liquidityPoolId, amount, minAmountA, minAmountB);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        LiquidityPoolWithdrawOp op = new LiquidityPoolWithdrawOp();
        op.setLiquidityPoolID(new PoolID(new Hash(Util.hexToBytes(this.getLiquidityPoolId()))));
        op.setAmount(new Int64(Operation.toXdrAmount(this.getAmount())));
        op.setMinAmountA(new Int64(Operation.toXdrAmount(this.getMinAmountA())));
        op.setMinAmountB(new Int64(Operation.toXdrAmount(this.getMinAmountB())));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.LIQUIDITY_POOL_WITHDRAW);
        body.setLiquidityPoolWithdrawOp(op);
        return body;
    }

    @Generated
    protected LiquidityPoolWithdrawOperation(LiquidityPoolWithdrawOperationBuilder<?, ?> b) {
        super(b);
        this.liquidityPoolId = ((LiquidityPoolWithdrawOperationBuilder)b).liquidityPoolId;
        if (this.liquidityPoolId == null) {
            throw new NullPointerException("liquidityPoolId is marked non-null but is null");
        }
        this.amount = ((LiquidityPoolWithdrawOperationBuilder)b).amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.minAmountA = ((LiquidityPoolWithdrawOperationBuilder)b).minAmountA;
        if (this.minAmountA == null) {
            throw new NullPointerException("minAmountA is marked non-null but is null");
        }
        this.minAmountB = ((LiquidityPoolWithdrawOperationBuilder)b).minAmountB;
        if (this.minAmountB == null) {
            throw new NullPointerException("minAmountB is marked non-null but is null");
        }
    }

    @Generated
    public static LiquidityPoolWithdrawOperationBuilder<?, ?> builder() {
        return new LiquidityPoolWithdrawOperationBuilderImpl();
    }

    @Generated
    public LiquidityPoolWithdrawOperationBuilder<?, ?> toBuilder() {
        return new LiquidityPoolWithdrawOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getLiquidityPoolId() {
        return this.liquidityPoolId;
    }

    @NonNull
    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public BigDecimal getMinAmountA() {
        return this.minAmountA;
    }

    @NonNull
    @Generated
    public BigDecimal getMinAmountB() {
        return this.minAmountB;
    }

    @Generated
    public String toString() {
        return "LiquidityPoolWithdrawOperation(super=" + super.toString() + ", liquidityPoolId=" + this.getLiquidityPoolId() + ", amount=" + this.getAmount() + ", minAmountA=" + this.getMinAmountA() + ", minAmountB=" + this.getMinAmountB() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolWithdrawOperation)) {
            return false;
        }
        LiquidityPoolWithdrawOperation other = (LiquidityPoolWithdrawOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$liquidityPoolId = this.getLiquidityPoolId();
        String other$liquidityPoolId = other.getLiquidityPoolId();
        if (this$liquidityPoolId == null ? other$liquidityPoolId != null : !this$liquidityPoolId.equals(other$liquidityPoolId)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$minAmountA = this.getMinAmountA();
        BigDecimal other$minAmountA = other.getMinAmountA();
        if (this$minAmountA == null ? other$minAmountA != null : !((Object)this$minAmountA).equals(other$minAmountA)) {
            return false;
        }
        BigDecimal this$minAmountB = this.getMinAmountB();
        BigDecimal other$minAmountB = other.getMinAmountB();
        return !(this$minAmountB == null ? other$minAmountB != null : !((Object)this$minAmountB).equals(other$minAmountB));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolWithdrawOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $liquidityPoolId = this.getLiquidityPoolId();
        result = result * 59 + ($liquidityPoolId == null ? 43 : $liquidityPoolId.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $minAmountA = this.getMinAmountA();
        result = result * 59 + ($minAmountA == null ? 43 : ((Object)$minAmountA).hashCode());
        BigDecimal $minAmountB = this.getMinAmountB();
        result = result * 59 + ($minAmountB == null ? 43 : ((Object)$minAmountB).hashCode());
        return result;
    }

    @Generated
    private LiquidityPoolWithdrawOperation(@NonNull String liquidityPoolId, @NonNull BigDecimal amount, @NonNull BigDecimal minAmountA, @NonNull BigDecimal minAmountB) {
        if (liquidityPoolId == null) {
            throw new NullPointerException("liquidityPoolId is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (minAmountA == null) {
            throw new NullPointerException("minAmountA is marked non-null but is null");
        }
        if (minAmountB == null) {
            throw new NullPointerException("minAmountB is marked non-null but is null");
        }
        this.liquidityPoolId = liquidityPoolId;
        this.amount = amount;
        this.minAmountA = minAmountA;
        this.minAmountB = minAmountB;
    }

    public static abstract class LiquidityPoolWithdrawOperationBuilder<C extends LiquidityPoolWithdrawOperation, B extends LiquidityPoolWithdrawOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String liquidityPoolId;
        @Generated
        private BigDecimal amount;
        @Generated
        private BigDecimal minAmountA;
        @Generated
        private BigDecimal minAmountB;

        public B liquidityPoolId(@NonNull String liquidityPoolId) {
            if (liquidityPoolId == null) {
                throw new NullPointerException("liquidityPoolId is marked non-null but is null");
            }
            this.liquidityPoolId = liquidityPoolId.toLowerCase();
            return (B)this.self();
        }

        public B amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = Operation.formatAmountScale(amount);
            return (B)this.self();
        }

        public B minAmountA(@NonNull BigDecimal minAmountA) {
            if (minAmountA == null) {
                throw new NullPointerException("minAmountA is marked non-null but is null");
            }
            this.minAmountA = Operation.formatAmountScale(minAmountA);
            return (B)this.self();
        }

        public B minAmountB(@NonNull BigDecimal minAmountB) {
            if (minAmountB == null) {
                throw new NullPointerException("minAmountB is marked non-null but is null");
            }
            this.minAmountB = Operation.formatAmountScale(minAmountB);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LiquidityPoolWithdrawOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LiquidityPoolWithdrawOperation instance, LiquidityPoolWithdrawOperationBuilder<?, ?> b) {
            b.liquidityPoolId(instance.liquidityPoolId);
            b.amount(instance.amount);
            b.minAmountA(instance.minAmountA);
            b.minAmountB(instance.minAmountB);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LiquidityPoolWithdrawOperation.LiquidityPoolWithdrawOperationBuilder(super=" + super.toString() + ", liquidityPoolId=" + this.liquidityPoolId + ", amount=" + this.amount + ", minAmountA=" + this.minAmountA + ", minAmountB=" + this.minAmountB + ")";
        }
    }

    @Generated
    private static final class LiquidityPoolWithdrawOperationBuilderImpl
    extends LiquidityPoolWithdrawOperationBuilder<LiquidityPoolWithdrawOperation, LiquidityPoolWithdrawOperationBuilderImpl> {
        @Generated
        private LiquidityPoolWithdrawOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected LiquidityPoolWithdrawOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LiquidityPoolWithdrawOperation build() {
            return new LiquidityPoolWithdrawOperation(this);
        }
    }
}

