/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ClawbackClaimableBalanceResultCode implements XdrElement
{
    CLAWBACK_CLAIMABLE_BALANCE_SUCCESS(0),
    CLAWBACK_CLAIMABLE_BALANCE_DOES_NOT_EXIST(-1),
    CLAWBACK_CLAIMABLE_BALANCE_NOT_ISSUER(-2),
    CLAWBACK_CLAIMABLE_BALANCE_NOT_CLAWBACK_ENABLED(-3);

    private final int value;

    private ClawbackClaimableBalanceResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ClawbackClaimableBalanceResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CLAWBACK_CLAIMABLE_BALANCE_SUCCESS;
            }
            case -1: {
                return CLAWBACK_CLAIMABLE_BALANCE_DOES_NOT_EXIST;
            }
            case -2: {
                return CLAWBACK_CLAIMABLE_BALANCE_NOT_ISSUER;
            }
            case -3: {
                return CLAWBACK_CLAIMABLE_BALANCE_NOT_CLAWBACK_ENABLED;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ClawbackClaimableBalanceResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClawbackClaimableBalanceResultCode.fromXdrByteArray(bytes);
    }

    public static ClawbackClaimableBalanceResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClawbackClaimableBalanceResultCode.decode(xdrDataInputStream);
    }
}

