/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HmacSha256Key
implements XdrElement {
    private byte[] key;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int keySize = this.key.length;
        stream.write(this.getKey(), 0, keySize);
    }

    public static HmacSha256Key decode(XdrDataInputStream stream) throws IOException {
        HmacSha256Key decodedHmacSha256Key = new HmacSha256Key();
        int keySize = 32;
        decodedHmacSha256Key.key = new byte[keySize];
        stream.read(decodedHmacSha256Key.key, 0, keySize);
        return decodedHmacSha256Key;
    }

    public static HmacSha256Key fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HmacSha256Key.fromXdrByteArray(bytes);
    }

    public static HmacSha256Key fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HmacSha256Key.decode(xdrDataInputStream);
    }

    @Generated
    public static HmacSha256KeyBuilder builder() {
        return new HmacSha256KeyBuilder();
    }

    @Generated
    public HmacSha256KeyBuilder toBuilder() {
        return new HmacSha256KeyBuilder().key(this.key);
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public void setKey(byte[] key) {
        this.key = key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HmacSha256Key)) {
            return false;
        }
        HmacSha256Key other = (HmacSha256Key)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getKey(), other.getKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HmacSha256Key;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKey());
        return result;
    }

    @Generated
    public String toString() {
        return "HmacSha256Key(key=" + Arrays.toString(this.getKey()) + ")";
    }

    @Generated
    public HmacSha256Key() {
    }

    @Generated
    public HmacSha256Key(byte[] key) {
        this.key = key;
    }

    @Generated
    public static class HmacSha256KeyBuilder {
        @Generated
        private byte[] key;

        @Generated
        HmacSha256KeyBuilder() {
        }

        @Generated
        public HmacSha256KeyBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public HmacSha256Key build() {
            return new HmacSha256Key(this.key);
        }

        @Generated
        public String toString() {
            return "HmacSha256Key.HmacSha256KeyBuilder(key=" + Arrays.toString(this.key) + ")";
        }
    }
}

