/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountMergeResult;
import org.stellar.sdk.xdr.AllowTrustResult;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesResult;
import org.stellar.sdk.xdr.BumpSequenceResult;
import org.stellar.sdk.xdr.ChangeTrustResult;
import org.stellar.sdk.xdr.ClaimClaimableBalanceResult;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceResult;
import org.stellar.sdk.xdr.ClawbackResult;
import org.stellar.sdk.xdr.CreateAccountResult;
import org.stellar.sdk.xdr.CreateClaimableBalanceResult;
import org.stellar.sdk.xdr.EndSponsoringFutureReservesResult;
import org.stellar.sdk.xdr.ExtendFootprintTTLResult;
import org.stellar.sdk.xdr.InflationResult;
import org.stellar.sdk.xdr.InvokeHostFunctionResult;
import org.stellar.sdk.xdr.LiquidityPoolDepositResult;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawResult;
import org.stellar.sdk.xdr.ManageBuyOfferResult;
import org.stellar.sdk.xdr.ManageDataResult;
import org.stellar.sdk.xdr.ManageSellOfferResult;
import org.stellar.sdk.xdr.OperationResultCode;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveResult;
import org.stellar.sdk.xdr.PathPaymentStrictSendResult;
import org.stellar.sdk.xdr.PaymentResult;
import org.stellar.sdk.xdr.RestoreFootprintResult;
import org.stellar.sdk.xdr.RevokeSponsorshipResult;
import org.stellar.sdk.xdr.SetOptionsResult;
import org.stellar.sdk.xdr.SetTrustLineFlagsResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class OperationResult
implements XdrElement {
    private OperationResultCode discriminant;
    private OperationResultTr tr;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case opINNER: {
                this.tr.encode(stream);
                break;
            }
        }
    }

    public static OperationResult decode(XdrDataInputStream stream) throws IOException {
        OperationResult decodedOperationResult = new OperationResult();
        OperationResultCode discriminant = OperationResultCode.decode(stream);
        decodedOperationResult.setDiscriminant(discriminant);
        switch (decodedOperationResult.getDiscriminant()) {
            case opINNER: {
                decodedOperationResult.tr = OperationResultTr.decode(stream);
                break;
            }
        }
        return decodedOperationResult;
    }

    public static OperationResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return OperationResult.fromXdrByteArray(bytes);
    }

    public static OperationResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return OperationResult.decode(xdrDataInputStream);
    }

    @Generated
    public static OperationResultBuilder builder() {
        return new OperationResultBuilder();
    }

    @Generated
    public OperationResultBuilder toBuilder() {
        return new OperationResultBuilder().discriminant(this.discriminant).tr(this.tr);
    }

    @Generated
    public OperationResultCode getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public OperationResultTr getTr() {
        return this.tr;
    }

    @Generated
    public void setDiscriminant(OperationResultCode discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setTr(OperationResultTr tr) {
        this.tr = tr;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationResult)) {
            return false;
        }
        OperationResult other = (OperationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperationResultCode this$discriminant = this.getDiscriminant();
        OperationResultCode other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        OperationResultTr this$tr = this.getTr();
        OperationResultTr other$tr = other.getTr();
        return !(this$tr == null ? other$tr != null : !((Object)this$tr).equals(other$tr));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperationResultCode $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        OperationResultTr $tr = this.getTr();
        result = result * 59 + ($tr == null ? 43 : ((Object)$tr).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OperationResult(discriminant=" + this.getDiscriminant() + ", tr=" + this.getTr() + ")";
    }

    @Generated
    public OperationResult() {
    }

    @Generated
    public OperationResult(OperationResultCode discriminant, OperationResultTr tr) {
        this.discriminant = discriminant;
        this.tr = tr;
    }

    public static class OperationResultTr
    implements XdrElement {
        private OperationType discriminant;
        private CreateAccountResult createAccountResult;
        private PaymentResult paymentResult;
        private PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
        private ManageSellOfferResult manageSellOfferResult;
        private ManageSellOfferResult createPassiveSellOfferResult;
        private SetOptionsResult setOptionsResult;
        private ChangeTrustResult changeTrustResult;
        private AllowTrustResult allowTrustResult;
        private AccountMergeResult accountMergeResult;
        private InflationResult inflationResult;
        private ManageDataResult manageDataResult;
        private BumpSequenceResult bumpSeqResult;
        private ManageBuyOfferResult manageBuyOfferResult;
        private PathPaymentStrictSendResult pathPaymentStrictSendResult;
        private CreateClaimableBalanceResult createClaimableBalanceResult;
        private ClaimClaimableBalanceResult claimClaimableBalanceResult;
        private BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
        private EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
        private RevokeSponsorshipResult revokeSponsorshipResult;
        private ClawbackResult clawbackResult;
        private ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
        private SetTrustLineFlagsResult setTrustLineFlagsResult;
        private LiquidityPoolDepositResult liquidityPoolDepositResult;
        private LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;
        private InvokeHostFunctionResult invokeHostFunctionResult;
        private ExtendFootprintTTLResult extendFootprintTTLResult;
        private RestoreFootprintResult restoreFootprintResult;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case CREATE_ACCOUNT: {
                    this.createAccountResult.encode(stream);
                    break;
                }
                case PAYMENT: {
                    this.paymentResult.encode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    this.pathPaymentStrictReceiveResult.encode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    this.manageSellOfferResult.encode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    this.createPassiveSellOfferResult.encode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    this.setOptionsResult.encode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    this.changeTrustResult.encode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    this.allowTrustResult.encode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    this.accountMergeResult.encode(stream);
                    break;
                }
                case INFLATION: {
                    this.inflationResult.encode(stream);
                    break;
                }
                case MANAGE_DATA: {
                    this.manageDataResult.encode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    this.bumpSeqResult.encode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    this.manageBuyOfferResult.encode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    this.pathPaymentStrictSendResult.encode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    this.createClaimableBalanceResult.encode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    this.claimClaimableBalanceResult.encode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    this.beginSponsoringFutureReservesResult.encode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    this.endSponsoringFutureReservesResult.encode(stream);
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    this.revokeSponsorshipResult.encode(stream);
                    break;
                }
                case CLAWBACK: {
                    this.clawbackResult.encode(stream);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    this.clawbackClaimableBalanceResult.encode(stream);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    this.setTrustLineFlagsResult.encode(stream);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    this.liquidityPoolDepositResult.encode(stream);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    this.liquidityPoolWithdrawResult.encode(stream);
                    break;
                }
                case INVOKE_HOST_FUNCTION: {
                    this.invokeHostFunctionResult.encode(stream);
                    break;
                }
                case EXTEND_FOOTPRINT_TTL: {
                    this.extendFootprintTTLResult.encode(stream);
                    break;
                }
                case RESTORE_FOOTPRINT: {
                    this.restoreFootprintResult.encode(stream);
                }
            }
        }

        public static OperationResultTr decode(XdrDataInputStream stream) throws IOException {
            OperationResultTr decodedOperationResultTr = new OperationResultTr();
            OperationType discriminant = OperationType.decode(stream);
            decodedOperationResultTr.setDiscriminant(discriminant);
            switch (decodedOperationResultTr.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    decodedOperationResultTr.createAccountResult = CreateAccountResult.decode(stream);
                    break;
                }
                case PAYMENT: {
                    decodedOperationResultTr.paymentResult = PaymentResult.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    decodedOperationResultTr.pathPaymentStrictReceiveResult = PathPaymentStrictReceiveResult.decode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    decodedOperationResultTr.manageSellOfferResult = ManageSellOfferResult.decode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    decodedOperationResultTr.createPassiveSellOfferResult = ManageSellOfferResult.decode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    decodedOperationResultTr.setOptionsResult = SetOptionsResult.decode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    decodedOperationResultTr.changeTrustResult = ChangeTrustResult.decode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    decodedOperationResultTr.allowTrustResult = AllowTrustResult.decode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    decodedOperationResultTr.accountMergeResult = AccountMergeResult.decode(stream);
                    break;
                }
                case INFLATION: {
                    decodedOperationResultTr.inflationResult = InflationResult.decode(stream);
                    break;
                }
                case MANAGE_DATA: {
                    decodedOperationResultTr.manageDataResult = ManageDataResult.decode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    decodedOperationResultTr.bumpSeqResult = BumpSequenceResult.decode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    decodedOperationResultTr.manageBuyOfferResult = ManageBuyOfferResult.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    decodedOperationResultTr.pathPaymentStrictSendResult = PathPaymentStrictSendResult.decode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.createClaimableBalanceResult = CreateClaimableBalanceResult.decode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.claimClaimableBalanceResult = ClaimClaimableBalanceResult.decode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationResultTr.beginSponsoringFutureReservesResult = BeginSponsoringFutureReservesResult.decode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationResultTr.endSponsoringFutureReservesResult = EndSponsoringFutureReservesResult.decode(stream);
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    decodedOperationResultTr.revokeSponsorshipResult = RevokeSponsorshipResult.decode(stream);
                    break;
                }
                case CLAWBACK: {
                    decodedOperationResultTr.clawbackResult = ClawbackResult.decode(stream);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.clawbackClaimableBalanceResult = ClawbackClaimableBalanceResult.decode(stream);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    decodedOperationResultTr.setTrustLineFlagsResult = SetTrustLineFlagsResult.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    decodedOperationResultTr.liquidityPoolDepositResult = LiquidityPoolDepositResult.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    decodedOperationResultTr.liquidityPoolWithdrawResult = LiquidityPoolWithdrawResult.decode(stream);
                    break;
                }
                case INVOKE_HOST_FUNCTION: {
                    decodedOperationResultTr.invokeHostFunctionResult = InvokeHostFunctionResult.decode(stream);
                    break;
                }
                case EXTEND_FOOTPRINT_TTL: {
                    decodedOperationResultTr.extendFootprintTTLResult = ExtendFootprintTTLResult.decode(stream);
                    break;
                }
                case RESTORE_FOOTPRINT: {
                    decodedOperationResultTr.restoreFootprintResult = RestoreFootprintResult.decode(stream);
                }
            }
            return decodedOperationResultTr;
        }

        public static OperationResultTr fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return OperationResultTr.fromXdrByteArray(bytes);
        }

        public static OperationResultTr fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return OperationResultTr.decode(xdrDataInputStream);
        }

        @Generated
        public static OperationResultTrBuilder builder() {
            return new OperationResultTrBuilder();
        }

        @Generated
        public OperationResultTrBuilder toBuilder() {
            return new OperationResultTrBuilder().discriminant(this.discriminant).createAccountResult(this.createAccountResult).paymentResult(this.paymentResult).pathPaymentStrictReceiveResult(this.pathPaymentStrictReceiveResult).manageSellOfferResult(this.manageSellOfferResult).createPassiveSellOfferResult(this.createPassiveSellOfferResult).setOptionsResult(this.setOptionsResult).changeTrustResult(this.changeTrustResult).allowTrustResult(this.allowTrustResult).accountMergeResult(this.accountMergeResult).inflationResult(this.inflationResult).manageDataResult(this.manageDataResult).bumpSeqResult(this.bumpSeqResult).manageBuyOfferResult(this.manageBuyOfferResult).pathPaymentStrictSendResult(this.pathPaymentStrictSendResult).createClaimableBalanceResult(this.createClaimableBalanceResult).claimClaimableBalanceResult(this.claimClaimableBalanceResult).beginSponsoringFutureReservesResult(this.beginSponsoringFutureReservesResult).endSponsoringFutureReservesResult(this.endSponsoringFutureReservesResult).revokeSponsorshipResult(this.revokeSponsorshipResult).clawbackResult(this.clawbackResult).clawbackClaimableBalanceResult(this.clawbackClaimableBalanceResult).setTrustLineFlagsResult(this.setTrustLineFlagsResult).liquidityPoolDepositResult(this.liquidityPoolDepositResult).liquidityPoolWithdrawResult(this.liquidityPoolWithdrawResult).invokeHostFunctionResult(this.invokeHostFunctionResult).extendFootprintTTLResult(this.extendFootprintTTLResult).restoreFootprintResult(this.restoreFootprintResult);
        }

        @Generated
        public OperationType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public CreateAccountResult getCreateAccountResult() {
            return this.createAccountResult;
        }

        @Generated
        public PaymentResult getPaymentResult() {
            return this.paymentResult;
        }

        @Generated
        public PathPaymentStrictReceiveResult getPathPaymentStrictReceiveResult() {
            return this.pathPaymentStrictReceiveResult;
        }

        @Generated
        public ManageSellOfferResult getManageSellOfferResult() {
            return this.manageSellOfferResult;
        }

        @Generated
        public ManageSellOfferResult getCreatePassiveSellOfferResult() {
            return this.createPassiveSellOfferResult;
        }

        @Generated
        public SetOptionsResult getSetOptionsResult() {
            return this.setOptionsResult;
        }

        @Generated
        public ChangeTrustResult getChangeTrustResult() {
            return this.changeTrustResult;
        }

        @Generated
        public AllowTrustResult getAllowTrustResult() {
            return this.allowTrustResult;
        }

        @Generated
        public AccountMergeResult getAccountMergeResult() {
            return this.accountMergeResult;
        }

        @Generated
        public InflationResult getInflationResult() {
            return this.inflationResult;
        }

        @Generated
        public ManageDataResult getManageDataResult() {
            return this.manageDataResult;
        }

        @Generated
        public BumpSequenceResult getBumpSeqResult() {
            return this.bumpSeqResult;
        }

        @Generated
        public ManageBuyOfferResult getManageBuyOfferResult() {
            return this.manageBuyOfferResult;
        }

        @Generated
        public PathPaymentStrictSendResult getPathPaymentStrictSendResult() {
            return this.pathPaymentStrictSendResult;
        }

        @Generated
        public CreateClaimableBalanceResult getCreateClaimableBalanceResult() {
            return this.createClaimableBalanceResult;
        }

        @Generated
        public ClaimClaimableBalanceResult getClaimClaimableBalanceResult() {
            return this.claimClaimableBalanceResult;
        }

        @Generated
        public BeginSponsoringFutureReservesResult getBeginSponsoringFutureReservesResult() {
            return this.beginSponsoringFutureReservesResult;
        }

        @Generated
        public EndSponsoringFutureReservesResult getEndSponsoringFutureReservesResult() {
            return this.endSponsoringFutureReservesResult;
        }

        @Generated
        public RevokeSponsorshipResult getRevokeSponsorshipResult() {
            return this.revokeSponsorshipResult;
        }

        @Generated
        public ClawbackResult getClawbackResult() {
            return this.clawbackResult;
        }

        @Generated
        public ClawbackClaimableBalanceResult getClawbackClaimableBalanceResult() {
            return this.clawbackClaimableBalanceResult;
        }

        @Generated
        public SetTrustLineFlagsResult getSetTrustLineFlagsResult() {
            return this.setTrustLineFlagsResult;
        }

        @Generated
        public LiquidityPoolDepositResult getLiquidityPoolDepositResult() {
            return this.liquidityPoolDepositResult;
        }

        @Generated
        public LiquidityPoolWithdrawResult getLiquidityPoolWithdrawResult() {
            return this.liquidityPoolWithdrawResult;
        }

        @Generated
        public InvokeHostFunctionResult getInvokeHostFunctionResult() {
            return this.invokeHostFunctionResult;
        }

        @Generated
        public ExtendFootprintTTLResult getExtendFootprintTTLResult() {
            return this.extendFootprintTTLResult;
        }

        @Generated
        public RestoreFootprintResult getRestoreFootprintResult() {
            return this.restoreFootprintResult;
        }

        @Generated
        public void setDiscriminant(OperationType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setCreateAccountResult(CreateAccountResult createAccountResult) {
            this.createAccountResult = createAccountResult;
        }

        @Generated
        public void setPaymentResult(PaymentResult paymentResult) {
            this.paymentResult = paymentResult;
        }

        @Generated
        public void setPathPaymentStrictReceiveResult(PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult) {
            this.pathPaymentStrictReceiveResult = pathPaymentStrictReceiveResult;
        }

        @Generated
        public void setManageSellOfferResult(ManageSellOfferResult manageSellOfferResult) {
            this.manageSellOfferResult = manageSellOfferResult;
        }

        @Generated
        public void setCreatePassiveSellOfferResult(ManageSellOfferResult createPassiveSellOfferResult) {
            this.createPassiveSellOfferResult = createPassiveSellOfferResult;
        }

        @Generated
        public void setSetOptionsResult(SetOptionsResult setOptionsResult) {
            this.setOptionsResult = setOptionsResult;
        }

        @Generated
        public void setChangeTrustResult(ChangeTrustResult changeTrustResult) {
            this.changeTrustResult = changeTrustResult;
        }

        @Generated
        public void setAllowTrustResult(AllowTrustResult allowTrustResult) {
            this.allowTrustResult = allowTrustResult;
        }

        @Generated
        public void setAccountMergeResult(AccountMergeResult accountMergeResult) {
            this.accountMergeResult = accountMergeResult;
        }

        @Generated
        public void setInflationResult(InflationResult inflationResult) {
            this.inflationResult = inflationResult;
        }

        @Generated
        public void setManageDataResult(ManageDataResult manageDataResult) {
            this.manageDataResult = manageDataResult;
        }

        @Generated
        public void setBumpSeqResult(BumpSequenceResult bumpSeqResult) {
            this.bumpSeqResult = bumpSeqResult;
        }

        @Generated
        public void setManageBuyOfferResult(ManageBuyOfferResult manageBuyOfferResult) {
            this.manageBuyOfferResult = manageBuyOfferResult;
        }

        @Generated
        public void setPathPaymentStrictSendResult(PathPaymentStrictSendResult pathPaymentStrictSendResult) {
            this.pathPaymentStrictSendResult = pathPaymentStrictSendResult;
        }

        @Generated
        public void setCreateClaimableBalanceResult(CreateClaimableBalanceResult createClaimableBalanceResult) {
            this.createClaimableBalanceResult = createClaimableBalanceResult;
        }

        @Generated
        public void setClaimClaimableBalanceResult(ClaimClaimableBalanceResult claimClaimableBalanceResult) {
            this.claimClaimableBalanceResult = claimClaimableBalanceResult;
        }

        @Generated
        public void setBeginSponsoringFutureReservesResult(BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult) {
            this.beginSponsoringFutureReservesResult = beginSponsoringFutureReservesResult;
        }

        @Generated
        public void setEndSponsoringFutureReservesResult(EndSponsoringFutureReservesResult endSponsoringFutureReservesResult) {
            this.endSponsoringFutureReservesResult = endSponsoringFutureReservesResult;
        }

        @Generated
        public void setRevokeSponsorshipResult(RevokeSponsorshipResult revokeSponsorshipResult) {
            this.revokeSponsorshipResult = revokeSponsorshipResult;
        }

        @Generated
        public void setClawbackResult(ClawbackResult clawbackResult) {
            this.clawbackResult = clawbackResult;
        }

        @Generated
        public void setClawbackClaimableBalanceResult(ClawbackClaimableBalanceResult clawbackClaimableBalanceResult) {
            this.clawbackClaimableBalanceResult = clawbackClaimableBalanceResult;
        }

        @Generated
        public void setSetTrustLineFlagsResult(SetTrustLineFlagsResult setTrustLineFlagsResult) {
            this.setTrustLineFlagsResult = setTrustLineFlagsResult;
        }

        @Generated
        public void setLiquidityPoolDepositResult(LiquidityPoolDepositResult liquidityPoolDepositResult) {
            this.liquidityPoolDepositResult = liquidityPoolDepositResult;
        }

        @Generated
        public void setLiquidityPoolWithdrawResult(LiquidityPoolWithdrawResult liquidityPoolWithdrawResult) {
            this.liquidityPoolWithdrawResult = liquidityPoolWithdrawResult;
        }

        @Generated
        public void setInvokeHostFunctionResult(InvokeHostFunctionResult invokeHostFunctionResult) {
            this.invokeHostFunctionResult = invokeHostFunctionResult;
        }

        @Generated
        public void setExtendFootprintTTLResult(ExtendFootprintTTLResult extendFootprintTTLResult) {
            this.extendFootprintTTLResult = extendFootprintTTLResult;
        }

        @Generated
        public void setRestoreFootprintResult(RestoreFootprintResult restoreFootprintResult) {
            this.restoreFootprintResult = restoreFootprintResult;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationResultTr)) {
                return false;
            }
            OperationResultTr other = (OperationResultTr)o;
            if (!other.canEqual(this)) {
                return false;
            }
            OperationType this$discriminant = this.getDiscriminant();
            OperationType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            CreateAccountResult this$createAccountResult = this.getCreateAccountResult();
            CreateAccountResult other$createAccountResult = other.getCreateAccountResult();
            if (this$createAccountResult == null ? other$createAccountResult != null : !((Object)this$createAccountResult).equals(other$createAccountResult)) {
                return false;
            }
            PaymentResult this$paymentResult = this.getPaymentResult();
            PaymentResult other$paymentResult = other.getPaymentResult();
            if (this$paymentResult == null ? other$paymentResult != null : !((Object)this$paymentResult).equals(other$paymentResult)) {
                return false;
            }
            PathPaymentStrictReceiveResult this$pathPaymentStrictReceiveResult = this.getPathPaymentStrictReceiveResult();
            PathPaymentStrictReceiveResult other$pathPaymentStrictReceiveResult = other.getPathPaymentStrictReceiveResult();
            if (this$pathPaymentStrictReceiveResult == null ? other$pathPaymentStrictReceiveResult != null : !((Object)this$pathPaymentStrictReceiveResult).equals(other$pathPaymentStrictReceiveResult)) {
                return false;
            }
            ManageSellOfferResult this$manageSellOfferResult = this.getManageSellOfferResult();
            ManageSellOfferResult other$manageSellOfferResult = other.getManageSellOfferResult();
            if (this$manageSellOfferResult == null ? other$manageSellOfferResult != null : !((Object)this$manageSellOfferResult).equals(other$manageSellOfferResult)) {
                return false;
            }
            ManageSellOfferResult this$createPassiveSellOfferResult = this.getCreatePassiveSellOfferResult();
            ManageSellOfferResult other$createPassiveSellOfferResult = other.getCreatePassiveSellOfferResult();
            if (this$createPassiveSellOfferResult == null ? other$createPassiveSellOfferResult != null : !((Object)this$createPassiveSellOfferResult).equals(other$createPassiveSellOfferResult)) {
                return false;
            }
            SetOptionsResult this$setOptionsResult = this.getSetOptionsResult();
            SetOptionsResult other$setOptionsResult = other.getSetOptionsResult();
            if (this$setOptionsResult == null ? other$setOptionsResult != null : !((Object)this$setOptionsResult).equals(other$setOptionsResult)) {
                return false;
            }
            ChangeTrustResult this$changeTrustResult = this.getChangeTrustResult();
            ChangeTrustResult other$changeTrustResult = other.getChangeTrustResult();
            if (this$changeTrustResult == null ? other$changeTrustResult != null : !((Object)this$changeTrustResult).equals(other$changeTrustResult)) {
                return false;
            }
            AllowTrustResult this$allowTrustResult = this.getAllowTrustResult();
            AllowTrustResult other$allowTrustResult = other.getAllowTrustResult();
            if (this$allowTrustResult == null ? other$allowTrustResult != null : !((Object)this$allowTrustResult).equals(other$allowTrustResult)) {
                return false;
            }
            AccountMergeResult this$accountMergeResult = this.getAccountMergeResult();
            AccountMergeResult other$accountMergeResult = other.getAccountMergeResult();
            if (this$accountMergeResult == null ? other$accountMergeResult != null : !((Object)this$accountMergeResult).equals(other$accountMergeResult)) {
                return false;
            }
            InflationResult this$inflationResult = this.getInflationResult();
            InflationResult other$inflationResult = other.getInflationResult();
            if (this$inflationResult == null ? other$inflationResult != null : !((Object)this$inflationResult).equals(other$inflationResult)) {
                return false;
            }
            ManageDataResult this$manageDataResult = this.getManageDataResult();
            ManageDataResult other$manageDataResult = other.getManageDataResult();
            if (this$manageDataResult == null ? other$manageDataResult != null : !((Object)this$manageDataResult).equals(other$manageDataResult)) {
                return false;
            }
            BumpSequenceResult this$bumpSeqResult = this.getBumpSeqResult();
            BumpSequenceResult other$bumpSeqResult = other.getBumpSeqResult();
            if (this$bumpSeqResult == null ? other$bumpSeqResult != null : !((Object)this$bumpSeqResult).equals(other$bumpSeqResult)) {
                return false;
            }
            ManageBuyOfferResult this$manageBuyOfferResult = this.getManageBuyOfferResult();
            ManageBuyOfferResult other$manageBuyOfferResult = other.getManageBuyOfferResult();
            if (this$manageBuyOfferResult == null ? other$manageBuyOfferResult != null : !((Object)this$manageBuyOfferResult).equals(other$manageBuyOfferResult)) {
                return false;
            }
            PathPaymentStrictSendResult this$pathPaymentStrictSendResult = this.getPathPaymentStrictSendResult();
            PathPaymentStrictSendResult other$pathPaymentStrictSendResult = other.getPathPaymentStrictSendResult();
            if (this$pathPaymentStrictSendResult == null ? other$pathPaymentStrictSendResult != null : !((Object)this$pathPaymentStrictSendResult).equals(other$pathPaymentStrictSendResult)) {
                return false;
            }
            CreateClaimableBalanceResult this$createClaimableBalanceResult = this.getCreateClaimableBalanceResult();
            CreateClaimableBalanceResult other$createClaimableBalanceResult = other.getCreateClaimableBalanceResult();
            if (this$createClaimableBalanceResult == null ? other$createClaimableBalanceResult != null : !((Object)this$createClaimableBalanceResult).equals(other$createClaimableBalanceResult)) {
                return false;
            }
            ClaimClaimableBalanceResult this$claimClaimableBalanceResult = this.getClaimClaimableBalanceResult();
            ClaimClaimableBalanceResult other$claimClaimableBalanceResult = other.getClaimClaimableBalanceResult();
            if (this$claimClaimableBalanceResult == null ? other$claimClaimableBalanceResult != null : !((Object)this$claimClaimableBalanceResult).equals(other$claimClaimableBalanceResult)) {
                return false;
            }
            BeginSponsoringFutureReservesResult this$beginSponsoringFutureReservesResult = this.getBeginSponsoringFutureReservesResult();
            BeginSponsoringFutureReservesResult other$beginSponsoringFutureReservesResult = other.getBeginSponsoringFutureReservesResult();
            if (this$beginSponsoringFutureReservesResult == null ? other$beginSponsoringFutureReservesResult != null : !((Object)this$beginSponsoringFutureReservesResult).equals(other$beginSponsoringFutureReservesResult)) {
                return false;
            }
            EndSponsoringFutureReservesResult this$endSponsoringFutureReservesResult = this.getEndSponsoringFutureReservesResult();
            EndSponsoringFutureReservesResult other$endSponsoringFutureReservesResult = other.getEndSponsoringFutureReservesResult();
            if (this$endSponsoringFutureReservesResult == null ? other$endSponsoringFutureReservesResult != null : !((Object)this$endSponsoringFutureReservesResult).equals(other$endSponsoringFutureReservesResult)) {
                return false;
            }
            RevokeSponsorshipResult this$revokeSponsorshipResult = this.getRevokeSponsorshipResult();
            RevokeSponsorshipResult other$revokeSponsorshipResult = other.getRevokeSponsorshipResult();
            if (this$revokeSponsorshipResult == null ? other$revokeSponsorshipResult != null : !((Object)this$revokeSponsorshipResult).equals(other$revokeSponsorshipResult)) {
                return false;
            }
            ClawbackResult this$clawbackResult = this.getClawbackResult();
            ClawbackResult other$clawbackResult = other.getClawbackResult();
            if (this$clawbackResult == null ? other$clawbackResult != null : !((Object)this$clawbackResult).equals(other$clawbackResult)) {
                return false;
            }
            ClawbackClaimableBalanceResult this$clawbackClaimableBalanceResult = this.getClawbackClaimableBalanceResult();
            ClawbackClaimableBalanceResult other$clawbackClaimableBalanceResult = other.getClawbackClaimableBalanceResult();
            if (this$clawbackClaimableBalanceResult == null ? other$clawbackClaimableBalanceResult != null : !((Object)this$clawbackClaimableBalanceResult).equals(other$clawbackClaimableBalanceResult)) {
                return false;
            }
            SetTrustLineFlagsResult this$setTrustLineFlagsResult = this.getSetTrustLineFlagsResult();
            SetTrustLineFlagsResult other$setTrustLineFlagsResult = other.getSetTrustLineFlagsResult();
            if (this$setTrustLineFlagsResult == null ? other$setTrustLineFlagsResult != null : !((Object)this$setTrustLineFlagsResult).equals(other$setTrustLineFlagsResult)) {
                return false;
            }
            LiquidityPoolDepositResult this$liquidityPoolDepositResult = this.getLiquidityPoolDepositResult();
            LiquidityPoolDepositResult other$liquidityPoolDepositResult = other.getLiquidityPoolDepositResult();
            if (this$liquidityPoolDepositResult == null ? other$liquidityPoolDepositResult != null : !((Object)this$liquidityPoolDepositResult).equals(other$liquidityPoolDepositResult)) {
                return false;
            }
            LiquidityPoolWithdrawResult this$liquidityPoolWithdrawResult = this.getLiquidityPoolWithdrawResult();
            LiquidityPoolWithdrawResult other$liquidityPoolWithdrawResult = other.getLiquidityPoolWithdrawResult();
            if (this$liquidityPoolWithdrawResult == null ? other$liquidityPoolWithdrawResult != null : !((Object)this$liquidityPoolWithdrawResult).equals(other$liquidityPoolWithdrawResult)) {
                return false;
            }
            InvokeHostFunctionResult this$invokeHostFunctionResult = this.getInvokeHostFunctionResult();
            InvokeHostFunctionResult other$invokeHostFunctionResult = other.getInvokeHostFunctionResult();
            if (this$invokeHostFunctionResult == null ? other$invokeHostFunctionResult != null : !((Object)this$invokeHostFunctionResult).equals(other$invokeHostFunctionResult)) {
                return false;
            }
            ExtendFootprintTTLResult this$extendFootprintTTLResult = this.getExtendFootprintTTLResult();
            ExtendFootprintTTLResult other$extendFootprintTTLResult = other.getExtendFootprintTTLResult();
            if (this$extendFootprintTTLResult == null ? other$extendFootprintTTLResult != null : !((Object)this$extendFootprintTTLResult).equals(other$extendFootprintTTLResult)) {
                return false;
            }
            RestoreFootprintResult this$restoreFootprintResult = this.getRestoreFootprintResult();
            RestoreFootprintResult other$restoreFootprintResult = other.getRestoreFootprintResult();
            return !(this$restoreFootprintResult == null ? other$restoreFootprintResult != null : !((Object)this$restoreFootprintResult).equals(other$restoreFootprintResult));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperationResultTr;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OperationType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            CreateAccountResult $createAccountResult = this.getCreateAccountResult();
            result = result * 59 + ($createAccountResult == null ? 43 : ((Object)$createAccountResult).hashCode());
            PaymentResult $paymentResult = this.getPaymentResult();
            result = result * 59 + ($paymentResult == null ? 43 : ((Object)$paymentResult).hashCode());
            PathPaymentStrictReceiveResult $pathPaymentStrictReceiveResult = this.getPathPaymentStrictReceiveResult();
            result = result * 59 + ($pathPaymentStrictReceiveResult == null ? 43 : ((Object)$pathPaymentStrictReceiveResult).hashCode());
            ManageSellOfferResult $manageSellOfferResult = this.getManageSellOfferResult();
            result = result * 59 + ($manageSellOfferResult == null ? 43 : ((Object)$manageSellOfferResult).hashCode());
            ManageSellOfferResult $createPassiveSellOfferResult = this.getCreatePassiveSellOfferResult();
            result = result * 59 + ($createPassiveSellOfferResult == null ? 43 : ((Object)$createPassiveSellOfferResult).hashCode());
            SetOptionsResult $setOptionsResult = this.getSetOptionsResult();
            result = result * 59 + ($setOptionsResult == null ? 43 : ((Object)$setOptionsResult).hashCode());
            ChangeTrustResult $changeTrustResult = this.getChangeTrustResult();
            result = result * 59 + ($changeTrustResult == null ? 43 : ((Object)$changeTrustResult).hashCode());
            AllowTrustResult $allowTrustResult = this.getAllowTrustResult();
            result = result * 59 + ($allowTrustResult == null ? 43 : ((Object)$allowTrustResult).hashCode());
            AccountMergeResult $accountMergeResult = this.getAccountMergeResult();
            result = result * 59 + ($accountMergeResult == null ? 43 : ((Object)$accountMergeResult).hashCode());
            InflationResult $inflationResult = this.getInflationResult();
            result = result * 59 + ($inflationResult == null ? 43 : ((Object)$inflationResult).hashCode());
            ManageDataResult $manageDataResult = this.getManageDataResult();
            result = result * 59 + ($manageDataResult == null ? 43 : ((Object)$manageDataResult).hashCode());
            BumpSequenceResult $bumpSeqResult = this.getBumpSeqResult();
            result = result * 59 + ($bumpSeqResult == null ? 43 : ((Object)$bumpSeqResult).hashCode());
            ManageBuyOfferResult $manageBuyOfferResult = this.getManageBuyOfferResult();
            result = result * 59 + ($manageBuyOfferResult == null ? 43 : ((Object)$manageBuyOfferResult).hashCode());
            PathPaymentStrictSendResult $pathPaymentStrictSendResult = this.getPathPaymentStrictSendResult();
            result = result * 59 + ($pathPaymentStrictSendResult == null ? 43 : ((Object)$pathPaymentStrictSendResult).hashCode());
            CreateClaimableBalanceResult $createClaimableBalanceResult = this.getCreateClaimableBalanceResult();
            result = result * 59 + ($createClaimableBalanceResult == null ? 43 : ((Object)$createClaimableBalanceResult).hashCode());
            ClaimClaimableBalanceResult $claimClaimableBalanceResult = this.getClaimClaimableBalanceResult();
            result = result * 59 + ($claimClaimableBalanceResult == null ? 43 : ((Object)$claimClaimableBalanceResult).hashCode());
            BeginSponsoringFutureReservesResult $beginSponsoringFutureReservesResult = this.getBeginSponsoringFutureReservesResult();
            result = result * 59 + ($beginSponsoringFutureReservesResult == null ? 43 : ((Object)$beginSponsoringFutureReservesResult).hashCode());
            EndSponsoringFutureReservesResult $endSponsoringFutureReservesResult = this.getEndSponsoringFutureReservesResult();
            result = result * 59 + ($endSponsoringFutureReservesResult == null ? 43 : ((Object)$endSponsoringFutureReservesResult).hashCode());
            RevokeSponsorshipResult $revokeSponsorshipResult = this.getRevokeSponsorshipResult();
            result = result * 59 + ($revokeSponsorshipResult == null ? 43 : ((Object)$revokeSponsorshipResult).hashCode());
            ClawbackResult $clawbackResult = this.getClawbackResult();
            result = result * 59 + ($clawbackResult == null ? 43 : ((Object)$clawbackResult).hashCode());
            ClawbackClaimableBalanceResult $clawbackClaimableBalanceResult = this.getClawbackClaimableBalanceResult();
            result = result * 59 + ($clawbackClaimableBalanceResult == null ? 43 : ((Object)$clawbackClaimableBalanceResult).hashCode());
            SetTrustLineFlagsResult $setTrustLineFlagsResult = this.getSetTrustLineFlagsResult();
            result = result * 59 + ($setTrustLineFlagsResult == null ? 43 : ((Object)$setTrustLineFlagsResult).hashCode());
            LiquidityPoolDepositResult $liquidityPoolDepositResult = this.getLiquidityPoolDepositResult();
            result = result * 59 + ($liquidityPoolDepositResult == null ? 43 : ((Object)$liquidityPoolDepositResult).hashCode());
            LiquidityPoolWithdrawResult $liquidityPoolWithdrawResult = this.getLiquidityPoolWithdrawResult();
            result = result * 59 + ($liquidityPoolWithdrawResult == null ? 43 : ((Object)$liquidityPoolWithdrawResult).hashCode());
            InvokeHostFunctionResult $invokeHostFunctionResult = this.getInvokeHostFunctionResult();
            result = result * 59 + ($invokeHostFunctionResult == null ? 43 : ((Object)$invokeHostFunctionResult).hashCode());
            ExtendFootprintTTLResult $extendFootprintTTLResult = this.getExtendFootprintTTLResult();
            result = result * 59 + ($extendFootprintTTLResult == null ? 43 : ((Object)$extendFootprintTTLResult).hashCode());
            RestoreFootprintResult $restoreFootprintResult = this.getRestoreFootprintResult();
            result = result * 59 + ($restoreFootprintResult == null ? 43 : ((Object)$restoreFootprintResult).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OperationResult.OperationResultTr(discriminant=" + this.getDiscriminant() + ", createAccountResult=" + this.getCreateAccountResult() + ", paymentResult=" + this.getPaymentResult() + ", pathPaymentStrictReceiveResult=" + this.getPathPaymentStrictReceiveResult() + ", manageSellOfferResult=" + this.getManageSellOfferResult() + ", createPassiveSellOfferResult=" + this.getCreatePassiveSellOfferResult() + ", setOptionsResult=" + this.getSetOptionsResult() + ", changeTrustResult=" + this.getChangeTrustResult() + ", allowTrustResult=" + this.getAllowTrustResult() + ", accountMergeResult=" + this.getAccountMergeResult() + ", inflationResult=" + this.getInflationResult() + ", manageDataResult=" + this.getManageDataResult() + ", bumpSeqResult=" + this.getBumpSeqResult() + ", manageBuyOfferResult=" + this.getManageBuyOfferResult() + ", pathPaymentStrictSendResult=" + this.getPathPaymentStrictSendResult() + ", createClaimableBalanceResult=" + this.getCreateClaimableBalanceResult() + ", claimClaimableBalanceResult=" + this.getClaimClaimableBalanceResult() + ", beginSponsoringFutureReservesResult=" + this.getBeginSponsoringFutureReservesResult() + ", endSponsoringFutureReservesResult=" + this.getEndSponsoringFutureReservesResult() + ", revokeSponsorshipResult=" + this.getRevokeSponsorshipResult() + ", clawbackResult=" + this.getClawbackResult() + ", clawbackClaimableBalanceResult=" + this.getClawbackClaimableBalanceResult() + ", setTrustLineFlagsResult=" + this.getSetTrustLineFlagsResult() + ", liquidityPoolDepositResult=" + this.getLiquidityPoolDepositResult() + ", liquidityPoolWithdrawResult=" + this.getLiquidityPoolWithdrawResult() + ", invokeHostFunctionResult=" + this.getInvokeHostFunctionResult() + ", extendFootprintTTLResult=" + this.getExtendFootprintTTLResult() + ", restoreFootprintResult=" + this.getRestoreFootprintResult() + ")";
        }

        @Generated
        public OperationResultTr() {
        }

        @Generated
        public OperationResultTr(OperationType discriminant, CreateAccountResult createAccountResult, PaymentResult paymentResult, PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult, ManageSellOfferResult manageSellOfferResult, ManageSellOfferResult createPassiveSellOfferResult, SetOptionsResult setOptionsResult, ChangeTrustResult changeTrustResult, AllowTrustResult allowTrustResult, AccountMergeResult accountMergeResult, InflationResult inflationResult, ManageDataResult manageDataResult, BumpSequenceResult bumpSeqResult, ManageBuyOfferResult manageBuyOfferResult, PathPaymentStrictSendResult pathPaymentStrictSendResult, CreateClaimableBalanceResult createClaimableBalanceResult, ClaimClaimableBalanceResult claimClaimableBalanceResult, BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult, EndSponsoringFutureReservesResult endSponsoringFutureReservesResult, RevokeSponsorshipResult revokeSponsorshipResult, ClawbackResult clawbackResult, ClawbackClaimableBalanceResult clawbackClaimableBalanceResult, SetTrustLineFlagsResult setTrustLineFlagsResult, LiquidityPoolDepositResult liquidityPoolDepositResult, LiquidityPoolWithdrawResult liquidityPoolWithdrawResult, InvokeHostFunctionResult invokeHostFunctionResult, ExtendFootprintTTLResult extendFootprintTTLResult, RestoreFootprintResult restoreFootprintResult) {
            this.discriminant = discriminant;
            this.createAccountResult = createAccountResult;
            this.paymentResult = paymentResult;
            this.pathPaymentStrictReceiveResult = pathPaymentStrictReceiveResult;
            this.manageSellOfferResult = manageSellOfferResult;
            this.createPassiveSellOfferResult = createPassiveSellOfferResult;
            this.setOptionsResult = setOptionsResult;
            this.changeTrustResult = changeTrustResult;
            this.allowTrustResult = allowTrustResult;
            this.accountMergeResult = accountMergeResult;
            this.inflationResult = inflationResult;
            this.manageDataResult = manageDataResult;
            this.bumpSeqResult = bumpSeqResult;
            this.manageBuyOfferResult = manageBuyOfferResult;
            this.pathPaymentStrictSendResult = pathPaymentStrictSendResult;
            this.createClaimableBalanceResult = createClaimableBalanceResult;
            this.claimClaimableBalanceResult = claimClaimableBalanceResult;
            this.beginSponsoringFutureReservesResult = beginSponsoringFutureReservesResult;
            this.endSponsoringFutureReservesResult = endSponsoringFutureReservesResult;
            this.revokeSponsorshipResult = revokeSponsorshipResult;
            this.clawbackResult = clawbackResult;
            this.clawbackClaimableBalanceResult = clawbackClaimableBalanceResult;
            this.setTrustLineFlagsResult = setTrustLineFlagsResult;
            this.liquidityPoolDepositResult = liquidityPoolDepositResult;
            this.liquidityPoolWithdrawResult = liquidityPoolWithdrawResult;
            this.invokeHostFunctionResult = invokeHostFunctionResult;
            this.extendFootprintTTLResult = extendFootprintTTLResult;
            this.restoreFootprintResult = restoreFootprintResult;
        }

        @Generated
        public static class OperationResultTrBuilder {
            @Generated
            private OperationType discriminant;
            @Generated
            private CreateAccountResult createAccountResult;
            @Generated
            private PaymentResult paymentResult;
            @Generated
            private PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
            @Generated
            private ManageSellOfferResult manageSellOfferResult;
            @Generated
            private ManageSellOfferResult createPassiveSellOfferResult;
            @Generated
            private SetOptionsResult setOptionsResult;
            @Generated
            private ChangeTrustResult changeTrustResult;
            @Generated
            private AllowTrustResult allowTrustResult;
            @Generated
            private AccountMergeResult accountMergeResult;
            @Generated
            private InflationResult inflationResult;
            @Generated
            private ManageDataResult manageDataResult;
            @Generated
            private BumpSequenceResult bumpSeqResult;
            @Generated
            private ManageBuyOfferResult manageBuyOfferResult;
            @Generated
            private PathPaymentStrictSendResult pathPaymentStrictSendResult;
            @Generated
            private CreateClaimableBalanceResult createClaimableBalanceResult;
            @Generated
            private ClaimClaimableBalanceResult claimClaimableBalanceResult;
            @Generated
            private BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
            @Generated
            private EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
            @Generated
            private RevokeSponsorshipResult revokeSponsorshipResult;
            @Generated
            private ClawbackResult clawbackResult;
            @Generated
            private ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
            @Generated
            private SetTrustLineFlagsResult setTrustLineFlagsResult;
            @Generated
            private LiquidityPoolDepositResult liquidityPoolDepositResult;
            @Generated
            private LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;
            @Generated
            private InvokeHostFunctionResult invokeHostFunctionResult;
            @Generated
            private ExtendFootprintTTLResult extendFootprintTTLResult;
            @Generated
            private RestoreFootprintResult restoreFootprintResult;

            @Generated
            OperationResultTrBuilder() {
            }

            @Generated
            public OperationResultTrBuilder discriminant(OperationType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public OperationResultTrBuilder createAccountResult(CreateAccountResult createAccountResult) {
                this.createAccountResult = createAccountResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder paymentResult(PaymentResult paymentResult) {
                this.paymentResult = paymentResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder pathPaymentStrictReceiveResult(PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult) {
                this.pathPaymentStrictReceiveResult = pathPaymentStrictReceiveResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder manageSellOfferResult(ManageSellOfferResult manageSellOfferResult) {
                this.manageSellOfferResult = manageSellOfferResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder createPassiveSellOfferResult(ManageSellOfferResult createPassiveSellOfferResult) {
                this.createPassiveSellOfferResult = createPassiveSellOfferResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder setOptionsResult(SetOptionsResult setOptionsResult) {
                this.setOptionsResult = setOptionsResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder changeTrustResult(ChangeTrustResult changeTrustResult) {
                this.changeTrustResult = changeTrustResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder allowTrustResult(AllowTrustResult allowTrustResult) {
                this.allowTrustResult = allowTrustResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder accountMergeResult(AccountMergeResult accountMergeResult) {
                this.accountMergeResult = accountMergeResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder inflationResult(InflationResult inflationResult) {
                this.inflationResult = inflationResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder manageDataResult(ManageDataResult manageDataResult) {
                this.manageDataResult = manageDataResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder bumpSeqResult(BumpSequenceResult bumpSeqResult) {
                this.bumpSeqResult = bumpSeqResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder manageBuyOfferResult(ManageBuyOfferResult manageBuyOfferResult) {
                this.manageBuyOfferResult = manageBuyOfferResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder pathPaymentStrictSendResult(PathPaymentStrictSendResult pathPaymentStrictSendResult) {
                this.pathPaymentStrictSendResult = pathPaymentStrictSendResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder createClaimableBalanceResult(CreateClaimableBalanceResult createClaimableBalanceResult) {
                this.createClaimableBalanceResult = createClaimableBalanceResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder claimClaimableBalanceResult(ClaimClaimableBalanceResult claimClaimableBalanceResult) {
                this.claimClaimableBalanceResult = claimClaimableBalanceResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder beginSponsoringFutureReservesResult(BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult) {
                this.beginSponsoringFutureReservesResult = beginSponsoringFutureReservesResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder endSponsoringFutureReservesResult(EndSponsoringFutureReservesResult endSponsoringFutureReservesResult) {
                this.endSponsoringFutureReservesResult = endSponsoringFutureReservesResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder revokeSponsorshipResult(RevokeSponsorshipResult revokeSponsorshipResult) {
                this.revokeSponsorshipResult = revokeSponsorshipResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder clawbackResult(ClawbackResult clawbackResult) {
                this.clawbackResult = clawbackResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder clawbackClaimableBalanceResult(ClawbackClaimableBalanceResult clawbackClaimableBalanceResult) {
                this.clawbackClaimableBalanceResult = clawbackClaimableBalanceResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder setTrustLineFlagsResult(SetTrustLineFlagsResult setTrustLineFlagsResult) {
                this.setTrustLineFlagsResult = setTrustLineFlagsResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder liquidityPoolDepositResult(LiquidityPoolDepositResult liquidityPoolDepositResult) {
                this.liquidityPoolDepositResult = liquidityPoolDepositResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder liquidityPoolWithdrawResult(LiquidityPoolWithdrawResult liquidityPoolWithdrawResult) {
                this.liquidityPoolWithdrawResult = liquidityPoolWithdrawResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder invokeHostFunctionResult(InvokeHostFunctionResult invokeHostFunctionResult) {
                this.invokeHostFunctionResult = invokeHostFunctionResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder extendFootprintTTLResult(ExtendFootprintTTLResult extendFootprintTTLResult) {
                this.extendFootprintTTLResult = extendFootprintTTLResult;
                return this;
            }

            @Generated
            public OperationResultTrBuilder restoreFootprintResult(RestoreFootprintResult restoreFootprintResult) {
                this.restoreFootprintResult = restoreFootprintResult;
                return this;
            }

            @Generated
            public OperationResultTr build() {
                return new OperationResultTr(this.discriminant, this.createAccountResult, this.paymentResult, this.pathPaymentStrictReceiveResult, this.manageSellOfferResult, this.createPassiveSellOfferResult, this.setOptionsResult, this.changeTrustResult, this.allowTrustResult, this.accountMergeResult, this.inflationResult, this.manageDataResult, this.bumpSeqResult, this.manageBuyOfferResult, this.pathPaymentStrictSendResult, this.createClaimableBalanceResult, this.claimClaimableBalanceResult, this.beginSponsoringFutureReservesResult, this.endSponsoringFutureReservesResult, this.revokeSponsorshipResult, this.clawbackResult, this.clawbackClaimableBalanceResult, this.setTrustLineFlagsResult, this.liquidityPoolDepositResult, this.liquidityPoolWithdrawResult, this.invokeHostFunctionResult, this.extendFootprintTTLResult, this.restoreFootprintResult);
            }

            @Generated
            public String toString() {
                return "OperationResult.OperationResultTr.OperationResultTrBuilder(discriminant=" + this.discriminant + ", createAccountResult=" + this.createAccountResult + ", paymentResult=" + this.paymentResult + ", pathPaymentStrictReceiveResult=" + this.pathPaymentStrictReceiveResult + ", manageSellOfferResult=" + this.manageSellOfferResult + ", createPassiveSellOfferResult=" + this.createPassiveSellOfferResult + ", setOptionsResult=" + this.setOptionsResult + ", changeTrustResult=" + this.changeTrustResult + ", allowTrustResult=" + this.allowTrustResult + ", accountMergeResult=" + this.accountMergeResult + ", inflationResult=" + this.inflationResult + ", manageDataResult=" + this.manageDataResult + ", bumpSeqResult=" + this.bumpSeqResult + ", manageBuyOfferResult=" + this.manageBuyOfferResult + ", pathPaymentStrictSendResult=" + this.pathPaymentStrictSendResult + ", createClaimableBalanceResult=" + this.createClaimableBalanceResult + ", claimClaimableBalanceResult=" + this.claimClaimableBalanceResult + ", beginSponsoringFutureReservesResult=" + this.beginSponsoringFutureReservesResult + ", endSponsoringFutureReservesResult=" + this.endSponsoringFutureReservesResult + ", revokeSponsorshipResult=" + this.revokeSponsorshipResult + ", clawbackResult=" + this.clawbackResult + ", clawbackClaimableBalanceResult=" + this.clawbackClaimableBalanceResult + ", setTrustLineFlagsResult=" + this.setTrustLineFlagsResult + ", liquidityPoolDepositResult=" + this.liquidityPoolDepositResult + ", liquidityPoolWithdrawResult=" + this.liquidityPoolWithdrawResult + ", invokeHostFunctionResult=" + this.invokeHostFunctionResult + ", extendFootprintTTLResult=" + this.extendFootprintTTLResult + ", restoreFootprintResult=" + this.restoreFootprintResult + ")";
            }
        }
    }

    @Generated
    public static class OperationResultBuilder {
        @Generated
        private OperationResultCode discriminant;
        @Generated
        private OperationResultTr tr;

        @Generated
        OperationResultBuilder() {
        }

        @Generated
        public OperationResultBuilder discriminant(OperationResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public OperationResultBuilder tr(OperationResultTr tr) {
            this.tr = tr;
            return this;
        }

        @Generated
        public OperationResult build() {
            return new OperationResult(this.discriminant, this.tr);
        }

        @Generated
        public String toString() {
            return "OperationResult.OperationResultBuilder(discriminant=" + this.discriminant + ", tr=" + this.tr + ")";
        }
    }
}

