/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.LedgerBounds;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PreconditionsV2
implements XdrElement {
    private TimeBounds timeBounds;
    private LedgerBounds ledgerBounds;
    private SequenceNumber minSeqNum;
    private Duration minSeqAge;
    private Uint32 minSeqLedgerGap;
    private SignerKey[] extraSigners;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        if (this.timeBounds != null) {
            stream.writeInt(1);
            this.timeBounds.encode(stream);
        } else {
            stream.writeInt(0);
        }
        if (this.ledgerBounds != null) {
            stream.writeInt(1);
            this.ledgerBounds.encode(stream);
        } else {
            stream.writeInt(0);
        }
        if (this.minSeqNum != null) {
            stream.writeInt(1);
            this.minSeqNum.encode(stream);
        } else {
            stream.writeInt(0);
        }
        this.minSeqAge.encode(stream);
        this.minSeqLedgerGap.encode(stream);
        int extraSignersSize = this.getExtraSigners().length;
        stream.writeInt(extraSignersSize);
        for (int i = 0; i < extraSignersSize; ++i) {
            this.extraSigners[i].encode(stream);
        }
    }

    public static PreconditionsV2 decode(XdrDataInputStream stream) throws IOException {
        int minSeqNumPresent;
        int ledgerBoundsPresent;
        PreconditionsV2 decodedPreconditionsV2 = new PreconditionsV2();
        int timeBoundsPresent = stream.readInt();
        if (timeBoundsPresent != 0) {
            decodedPreconditionsV2.timeBounds = TimeBounds.decode(stream);
        }
        if ((ledgerBoundsPresent = stream.readInt()) != 0) {
            decodedPreconditionsV2.ledgerBounds = LedgerBounds.decode(stream);
        }
        if ((minSeqNumPresent = stream.readInt()) != 0) {
            decodedPreconditionsV2.minSeqNum = SequenceNumber.decode(stream);
        }
        decodedPreconditionsV2.minSeqAge = Duration.decode(stream);
        decodedPreconditionsV2.minSeqLedgerGap = Uint32.decode(stream);
        int extraSignersSize = stream.readInt();
        decodedPreconditionsV2.extraSigners = new SignerKey[extraSignersSize];
        for (int i = 0; i < extraSignersSize; ++i) {
            decodedPreconditionsV2.extraSigners[i] = SignerKey.decode(stream);
        }
        return decodedPreconditionsV2;
    }

    public static PreconditionsV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PreconditionsV2.fromXdrByteArray(bytes);
    }

    public static PreconditionsV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PreconditionsV2.decode(xdrDataInputStream);
    }

    @Generated
    public static PreconditionsV2Builder builder() {
        return new PreconditionsV2Builder();
    }

    @Generated
    public PreconditionsV2Builder toBuilder() {
        return new PreconditionsV2Builder().timeBounds(this.timeBounds).ledgerBounds(this.ledgerBounds).minSeqNum(this.minSeqNum).minSeqAge(this.minSeqAge).minSeqLedgerGap(this.minSeqLedgerGap).extraSigners(this.extraSigners);
    }

    @Generated
    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    @Generated
    public LedgerBounds getLedgerBounds() {
        return this.ledgerBounds;
    }

    @Generated
    public SequenceNumber getMinSeqNum() {
        return this.minSeqNum;
    }

    @Generated
    public Duration getMinSeqAge() {
        return this.minSeqAge;
    }

    @Generated
    public Uint32 getMinSeqLedgerGap() {
        return this.minSeqLedgerGap;
    }

    @Generated
    public SignerKey[] getExtraSigners() {
        return this.extraSigners;
    }

    @Generated
    public void setTimeBounds(TimeBounds timeBounds) {
        this.timeBounds = timeBounds;
    }

    @Generated
    public void setLedgerBounds(LedgerBounds ledgerBounds) {
        this.ledgerBounds = ledgerBounds;
    }

    @Generated
    public void setMinSeqNum(SequenceNumber minSeqNum) {
        this.minSeqNum = minSeqNum;
    }

    @Generated
    public void setMinSeqAge(Duration minSeqAge) {
        this.minSeqAge = minSeqAge;
    }

    @Generated
    public void setMinSeqLedgerGap(Uint32 minSeqLedgerGap) {
        this.minSeqLedgerGap = minSeqLedgerGap;
    }

    @Generated
    public void setExtraSigners(SignerKey[] extraSigners) {
        this.extraSigners = extraSigners;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreconditionsV2)) {
            return false;
        }
        PreconditionsV2 other = (PreconditionsV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimeBounds this$timeBounds = this.getTimeBounds();
        TimeBounds other$timeBounds = other.getTimeBounds();
        if (this$timeBounds == null ? other$timeBounds != null : !((Object)this$timeBounds).equals(other$timeBounds)) {
            return false;
        }
        LedgerBounds this$ledgerBounds = this.getLedgerBounds();
        LedgerBounds other$ledgerBounds = other.getLedgerBounds();
        if (this$ledgerBounds == null ? other$ledgerBounds != null : !((Object)this$ledgerBounds).equals(other$ledgerBounds)) {
            return false;
        }
        SequenceNumber this$minSeqNum = this.getMinSeqNum();
        SequenceNumber other$minSeqNum = other.getMinSeqNum();
        if (this$minSeqNum == null ? other$minSeqNum != null : !((Object)this$minSeqNum).equals(other$minSeqNum)) {
            return false;
        }
        Duration this$minSeqAge = this.getMinSeqAge();
        Duration other$minSeqAge = other.getMinSeqAge();
        if (this$minSeqAge == null ? other$minSeqAge != null : !((Object)this$minSeqAge).equals(other$minSeqAge)) {
            return false;
        }
        Uint32 this$minSeqLedgerGap = this.getMinSeqLedgerGap();
        Uint32 other$minSeqLedgerGap = other.getMinSeqLedgerGap();
        if (this$minSeqLedgerGap == null ? other$minSeqLedgerGap != null : !((Object)this$minSeqLedgerGap).equals(other$minSeqLedgerGap)) {
            return false;
        }
        return Arrays.deepEquals(this.getExtraSigners(), other.getExtraSigners());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PreconditionsV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimeBounds $timeBounds = this.getTimeBounds();
        result = result * 59 + ($timeBounds == null ? 43 : ((Object)$timeBounds).hashCode());
        LedgerBounds $ledgerBounds = this.getLedgerBounds();
        result = result * 59 + ($ledgerBounds == null ? 43 : ((Object)$ledgerBounds).hashCode());
        SequenceNumber $minSeqNum = this.getMinSeqNum();
        result = result * 59 + ($minSeqNum == null ? 43 : ((Object)$minSeqNum).hashCode());
        Duration $minSeqAge = this.getMinSeqAge();
        result = result * 59 + ($minSeqAge == null ? 43 : ((Object)$minSeqAge).hashCode());
        Uint32 $minSeqLedgerGap = this.getMinSeqLedgerGap();
        result = result * 59 + ($minSeqLedgerGap == null ? 43 : ((Object)$minSeqLedgerGap).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getExtraSigners());
        return result;
    }

    @Generated
    public String toString() {
        return "PreconditionsV2(timeBounds=" + this.getTimeBounds() + ", ledgerBounds=" + this.getLedgerBounds() + ", minSeqNum=" + this.getMinSeqNum() + ", minSeqAge=" + this.getMinSeqAge() + ", minSeqLedgerGap=" + this.getMinSeqLedgerGap() + ", extraSigners=" + Arrays.deepToString(this.getExtraSigners()) + ")";
    }

    @Generated
    public PreconditionsV2() {
    }

    @Generated
    public PreconditionsV2(TimeBounds timeBounds, LedgerBounds ledgerBounds, SequenceNumber minSeqNum, Duration minSeqAge, Uint32 minSeqLedgerGap, SignerKey[] extraSigners) {
        this.timeBounds = timeBounds;
        this.ledgerBounds = ledgerBounds;
        this.minSeqNum = minSeqNum;
        this.minSeqAge = minSeqAge;
        this.minSeqLedgerGap = minSeqLedgerGap;
        this.extraSigners = extraSigners;
    }

    @Generated
    public static class PreconditionsV2Builder {
        @Generated
        private TimeBounds timeBounds;
        @Generated
        private LedgerBounds ledgerBounds;
        @Generated
        private SequenceNumber minSeqNum;
        @Generated
        private Duration minSeqAge;
        @Generated
        private Uint32 minSeqLedgerGap;
        @Generated
        private SignerKey[] extraSigners;

        @Generated
        PreconditionsV2Builder() {
        }

        @Generated
        public PreconditionsV2Builder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        @Generated
        public PreconditionsV2Builder ledgerBounds(LedgerBounds ledgerBounds) {
            this.ledgerBounds = ledgerBounds;
            return this;
        }

        @Generated
        public PreconditionsV2Builder minSeqNum(SequenceNumber minSeqNum) {
            this.minSeqNum = minSeqNum;
            return this;
        }

        @Generated
        public PreconditionsV2Builder minSeqAge(Duration minSeqAge) {
            this.minSeqAge = minSeqAge;
            return this;
        }

        @Generated
        public PreconditionsV2Builder minSeqLedgerGap(Uint32 minSeqLedgerGap) {
            this.minSeqLedgerGap = minSeqLedgerGap;
            return this;
        }

        @Generated
        public PreconditionsV2Builder extraSigners(SignerKey[] extraSigners) {
            this.extraSigners = extraSigners;
            return this;
        }

        @Generated
        public PreconditionsV2 build() {
            return new PreconditionsV2(this.timeBounds, this.ledgerBounds, this.minSeqNum, this.minSeqAge, this.minSeqLedgerGap, this.extraSigners);
        }

        @Generated
        public String toString() {
            return "PreconditionsV2.PreconditionsV2Builder(timeBounds=" + this.timeBounds + ", ledgerBounds=" + this.ledgerBounds + ", minSeqNum=" + this.minSeqNum + ", minSeqAge=" + this.minSeqAge + ", minSeqLedgerGap=" + this.minSeqLedgerGap + ", extraSigners=" + Arrays.deepToString(this.extraSigners) + ")";
        }
    }
}

