/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PublicKey
implements XdrElement {
    private PublicKeyType discriminant;
    private Uint256 ed25519;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case PUBLIC_KEY_TYPE_ED25519: {
                this.ed25519.encode(stream);
            }
        }
    }

    public static PublicKey decode(XdrDataInputStream stream) throws IOException {
        PublicKey decodedPublicKey = new PublicKey();
        PublicKeyType discriminant = PublicKeyType.decode(stream);
        decodedPublicKey.setDiscriminant(discriminant);
        switch (decodedPublicKey.getDiscriminant()) {
            case PUBLIC_KEY_TYPE_ED25519: {
                decodedPublicKey.ed25519 = Uint256.decode(stream);
            }
        }
        return decodedPublicKey;
    }

    public static PublicKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PublicKey.fromXdrByteArray(bytes);
    }

    public static PublicKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PublicKey.decode(xdrDataInputStream);
    }

    @Generated
    public static PublicKeyBuilder builder() {
        return new PublicKeyBuilder();
    }

    @Generated
    public PublicKeyBuilder toBuilder() {
        return new PublicKeyBuilder().discriminant(this.discriminant).ed25519(this.ed25519);
    }

    @Generated
    public PublicKeyType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Uint256 getEd25519() {
        return this.ed25519;
    }

    @Generated
    public void setDiscriminant(PublicKeyType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setEd25519(Uint256 ed25519) {
        this.ed25519 = ed25519;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublicKeyType this$discriminant = this.getDiscriminant();
        PublicKeyType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Uint256 this$ed25519 = this.getEd25519();
        Uint256 other$ed25519 = other.getEd25519();
        return !(this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PublicKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKeyType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Uint256 $ed25519 = this.getEd25519();
        result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKey(discriminant=" + this.getDiscriminant() + ", ed25519=" + this.getEd25519() + ")";
    }

    @Generated
    public PublicKey() {
    }

    @Generated
    public PublicKey(PublicKeyType discriminant, Uint256 ed25519) {
        this.discriminant = discriminant;
        this.ed25519 = ed25519;
    }

    @Generated
    public static class PublicKeyBuilder {
        @Generated
        private PublicKeyType discriminant;
        @Generated
        private Uint256 ed25519;

        @Generated
        PublicKeyBuilder() {
        }

        @Generated
        public PublicKeyBuilder discriminant(PublicKeyType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public PublicKeyBuilder ed25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
            return this;
        }

        @Generated
        public PublicKey build() {
            return new PublicKey(this.discriminant, this.ed25519);
        }

        @Generated
        public String toString() {
            return "PublicKey.PublicKeyBuilder(discriminant=" + this.discriminant + ", ed25519=" + this.ed25519 + ")";
        }
    }
}

