/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.FeeBumpTransactionEnvelope;
import org.stellar.sdk.xdr.TransactionV0Envelope;
import org.stellar.sdk.xdr.TransactionV1Envelope;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionEnvelope
implements XdrElement {
    private EnvelopeType discriminant;
    private TransactionV0Envelope v0;
    private TransactionV1Envelope v1;
    private FeeBumpTransactionEnvelope feeBump;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ENVELOPE_TYPE_TX_V0: {
                this.v0.encode(stream);
                break;
            }
            case ENVELOPE_TYPE_TX: {
                this.v1.encode(stream);
                break;
            }
            case ENVELOPE_TYPE_TX_FEE_BUMP: {
                this.feeBump.encode(stream);
            }
        }
    }

    public static TransactionEnvelope decode(XdrDataInputStream stream) throws IOException {
        TransactionEnvelope decodedTransactionEnvelope = new TransactionEnvelope();
        EnvelopeType discriminant = EnvelopeType.decode(stream);
        decodedTransactionEnvelope.setDiscriminant(discriminant);
        switch (decodedTransactionEnvelope.getDiscriminant()) {
            case ENVELOPE_TYPE_TX_V0: {
                decodedTransactionEnvelope.v0 = TransactionV0Envelope.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_TX: {
                decodedTransactionEnvelope.v1 = TransactionV1Envelope.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_TX_FEE_BUMP: {
                decodedTransactionEnvelope.feeBump = FeeBumpTransactionEnvelope.decode(stream);
            }
        }
        return decodedTransactionEnvelope;
    }

    public static TransactionEnvelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionEnvelope.fromXdrByteArray(bytes);
    }

    public static TransactionEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionEnvelope.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionEnvelopeBuilder builder() {
        return new TransactionEnvelopeBuilder();
    }

    @Generated
    public TransactionEnvelopeBuilder toBuilder() {
        return new TransactionEnvelopeBuilder().discriminant(this.discriminant).v0(this.v0).v1(this.v1).feeBump(this.feeBump);
    }

    @Generated
    public EnvelopeType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public TransactionV0Envelope getV0() {
        return this.v0;
    }

    @Generated
    public TransactionV1Envelope getV1() {
        return this.v1;
    }

    @Generated
    public FeeBumpTransactionEnvelope getFeeBump() {
        return this.feeBump;
    }

    @Generated
    public void setDiscriminant(EnvelopeType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0(TransactionV0Envelope v0) {
        this.v0 = v0;
    }

    @Generated
    public void setV1(TransactionV1Envelope v1) {
        this.v1 = v1;
    }

    @Generated
    public void setFeeBump(FeeBumpTransactionEnvelope feeBump) {
        this.feeBump = feeBump;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionEnvelope)) {
            return false;
        }
        TransactionEnvelope other = (TransactionEnvelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnvelopeType this$discriminant = this.getDiscriminant();
        EnvelopeType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        TransactionV0Envelope this$v0 = this.getV0();
        TransactionV0Envelope other$v0 = other.getV0();
        if (this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0)) {
            return false;
        }
        TransactionV1Envelope this$v1 = this.getV1();
        TransactionV1Envelope other$v1 = other.getV1();
        if (this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1)) {
            return false;
        }
        FeeBumpTransactionEnvelope this$feeBump = this.getFeeBump();
        FeeBumpTransactionEnvelope other$feeBump = other.getFeeBump();
        return !(this$feeBump == null ? other$feeBump != null : !((Object)this$feeBump).equals(other$feeBump));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionEnvelope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnvelopeType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        TransactionV0Envelope $v0 = this.getV0();
        result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
        TransactionV1Envelope $v1 = this.getV1();
        result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
        FeeBumpTransactionEnvelope $feeBump = this.getFeeBump();
        result = result * 59 + ($feeBump == null ? 43 : ((Object)$feeBump).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionEnvelope(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ", v1=" + this.getV1() + ", feeBump=" + this.getFeeBump() + ")";
    }

    @Generated
    public TransactionEnvelope() {
    }

    @Generated
    public TransactionEnvelope(EnvelopeType discriminant, TransactionV0Envelope v0, TransactionV1Envelope v1, FeeBumpTransactionEnvelope feeBump) {
        this.discriminant = discriminant;
        this.v0 = v0;
        this.v1 = v1;
        this.feeBump = feeBump;
    }

    @Generated
    public static class TransactionEnvelopeBuilder {
        @Generated
        private EnvelopeType discriminant;
        @Generated
        private TransactionV0Envelope v0;
        @Generated
        private TransactionV1Envelope v1;
        @Generated
        private FeeBumpTransactionEnvelope feeBump;

        @Generated
        TransactionEnvelopeBuilder() {
        }

        @Generated
        public TransactionEnvelopeBuilder discriminant(EnvelopeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public TransactionEnvelopeBuilder v0(TransactionV0Envelope v0) {
            this.v0 = v0;
            return this;
        }

        @Generated
        public TransactionEnvelopeBuilder v1(TransactionV1Envelope v1) {
            this.v1 = v1;
            return this;
        }

        @Generated
        public TransactionEnvelopeBuilder feeBump(FeeBumpTransactionEnvelope feeBump) {
            this.feeBump = feeBump;
            return this;
        }

        @Generated
        public TransactionEnvelope build() {
            return new TransactionEnvelope(this.discriminant, this.v0, this.v1, this.feeBump);
        }

        @Generated
        public String toString() {
            return "TransactionEnvelope.TransactionEnvelopeBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ", v1=" + this.v1 + ", feeBump=" + this.feeBump + ")";
        }
    }
}

