/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XdrDataInputStream
extends DataInputStream {
    private final XdrInputStream mIn;

    public XdrDataInputStream(InputStream in) {
        super(new XdrInputStream(in));
        this.mIn = (XdrInputStream)this.in;
    }

    public int[] readIntArray() throws IOException {
        int l = this.readInt();
        return this.readIntArray(l);
    }

    private int[] readIntArray(int l) throws IOException {
        int[] arr = new int[l];
        for (int i = 0; i < l; ++i) {
            arr[i] = this.readInt();
        }
        return arr;
    }

    public float[] readFloatArray() throws IOException {
        int l = this.readInt();
        return this.readFloatArray(l);
    }

    private float[] readFloatArray(int l) throws IOException {
        float[] arr = new float[l];
        for (int i = 0; i < l; ++i) {
            arr[i] = this.readFloat();
        }
        return arr;
    }

    public double[] readDoubleArray() throws IOException {
        int l = this.readInt();
        return this.readDoubleArray(l);
    }

    private double[] readDoubleArray(int l) throws IOException {
        double[] arr = new double[l];
        for (int i = 0; i < l; ++i) {
            arr[i] = this.readDouble();
        }
        return arr;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    private static final class XdrInputStream
    extends InputStream {
        private final InputStream mIn;
        private int mCount;

        public XdrInputStream(InputStream in) {
            this.mIn = in;
            this.mCount = 0;
        }

        @Override
        public int read() throws IOException {
            int read = this.mIn.read();
            if (read >= 0) {
                ++this.mCount;
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.mIn.read(b, off, len);
            this.mCount += read;
            this.pad();
            return read;
        }

        public void pad() throws IOException {
            int pad = 0;
            int mod = this.mCount % 4;
            if (mod > 0) {
                pad = 4 - mod;
            }
            while (pad-- > 0) {
                int b = this.read();
                if (b == 0) continue;
                throw new IOException("non-zero padding");
            }
        }
    }
}

