/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Account;
import org.stellar.sdk.Address;
import org.stellar.sdk.Asset;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.Network;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.AccountNotFoundException;
import org.stellar.sdk.exception.ConnectionErrorException;
import org.stellar.sdk.exception.PrepareTransactionException;
import org.stellar.sdk.exception.RequestTimeoutException;
import org.stellar.sdk.exception.SorobanRpcException;
import org.stellar.sdk.operations.InvokeHostFunctionOperation;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.requests.ClientIdentificationInterceptor;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.sorobanrpc.GetEventsRequest;
import org.stellar.sdk.requests.sorobanrpc.GetLedgerEntriesRequest;
import org.stellar.sdk.requests.sorobanrpc.GetLedgersRequest;
import org.stellar.sdk.requests.sorobanrpc.GetTransactionRequest;
import org.stellar.sdk.requests.sorobanrpc.GetTransactionsRequest;
import org.stellar.sdk.requests.sorobanrpc.SendTransactionRequest;
import org.stellar.sdk.requests.sorobanrpc.SimulateTransactionRequest;
import org.stellar.sdk.requests.sorobanrpc.SorobanRpcRequest;
import org.stellar.sdk.responses.sorobanrpc.GetEventsResponse;
import org.stellar.sdk.responses.sorobanrpc.GetFeeStatsResponse;
import org.stellar.sdk.responses.sorobanrpc.GetHealthResponse;
import org.stellar.sdk.responses.sorobanrpc.GetLatestLedgerResponse;
import org.stellar.sdk.responses.sorobanrpc.GetLedgerEntriesResponse;
import org.stellar.sdk.responses.sorobanrpc.GetLedgersResponse;
import org.stellar.sdk.responses.sorobanrpc.GetNetworkResponse;
import org.stellar.sdk.responses.sorobanrpc.GetSACBalanceResponse;
import org.stellar.sdk.responses.sorobanrpc.GetTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.GetTransactionsResponse;
import org.stellar.sdk.responses.sorobanrpc.GetVersionInfoResponse;
import org.stellar.sdk.responses.sorobanrpc.SendTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SimulateTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SorobanRpcResponse;
import org.stellar.sdk.scval.Scv;
import org.stellar.sdk.xdr.ContractDataDurability;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanTransactionData;

public class SorobanServer
implements Closeable {
    private static final int SUBMIT_TRANSACTION_TIMEOUT = 60;
    private static final int CONNECT_TIMEOUT = 10;
    private final HttpUrl serverURI;
    private final OkHttpClient httpClient;
    private final Gson gson = new Gson();

    public SorobanServer(String serverURI) {
        this(serverURI, new OkHttpClient.Builder().addInterceptor((Interceptor)new ClientIdentificationInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build());
    }

    public SorobanServer(String serverURI, OkHttpClient httpClient) {
        this.serverURI = HttpUrl.parse((String)serverURI);
        this.httpClient = httpClient;
    }

    public TransactionBuilderAccount getAccount(String address) {
        LedgerEntry.LedgerEntryData ledgerEntryData;
        MuxedAccount muxedAccount = new MuxedAccount(address);
        LedgerKey.LedgerKeyAccount ledgerKeyAccount = LedgerKey.LedgerKeyAccount.builder().accountID(KeyPair.fromAccountId(muxedAccount.getAccountId()).getXdrAccountId()).build();
        LedgerKey ledgerKey = LedgerKey.builder().account(ledgerKeyAccount).discriminant(LedgerEntryType.ACCOUNT).build();
        GetLedgerEntriesResponse getLedgerEntriesResponse = this.getLedgerEntries(Collections.singleton(ledgerKey));
        List<GetLedgerEntriesResponse.LedgerEntryResult> entries = getLedgerEntriesResponse.getEntries();
        if (entries == null || entries.isEmpty()) {
            throw new AccountNotFoundException(muxedAccount.getAccountId());
        }
        try {
            ledgerEntryData = LedgerEntry.LedgerEntryData.fromXdrBase64(entries.get(0).getXdr());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid ledgerEntryData: " + entries.get(0).getXdr(), e);
        }
        long sequence = ledgerEntryData.getAccount().getSeqNum().getSequenceNumber().getInt64();
        return new Account(address, sequence);
    }

    public GetHealthResponse getHealth() {
        return this.sendRequest("getHealth", null, new TypeToken<SorobanRpcResponse<GetHealthResponse>>(){});
    }

    public GetFeeStatsResponse getFeeStats() {
        return this.sendRequest("getFeeStats", null, new TypeToken<SorobanRpcResponse<GetFeeStatsResponse>>(){});
    }

    public Optional<GetLedgerEntriesResponse.LedgerEntryResult> getContractData(String contractId, SCVal key, Durability durability) {
        ContractDataDurability contractDataDurability;
        switch (durability.ordinal()) {
            case 0: {
                contractDataDurability = ContractDataDurability.TEMPORARY;
                break;
            }
            case 1: {
                contractDataDurability = ContractDataDurability.PERSISTENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid durability: " + (Object)((Object)durability));
            }
        }
        Address address = new Address(contractId);
        LedgerKey.LedgerKeyContractData ledgerKeyContractData = LedgerKey.LedgerKeyContractData.builder().contract(address.toSCAddress()).key(key).durability(contractDataDurability).build();
        LedgerKey ledgerKey = LedgerKey.builder().discriminant(LedgerEntryType.CONTRACT_DATA).contractData(ledgerKeyContractData).build();
        GetLedgerEntriesResponse getLedgerEntriesResponse = this.getLedgerEntries(Collections.singleton(ledgerKey));
        List<GetLedgerEntriesResponse.LedgerEntryResult> entries = getLedgerEntriesResponse.getEntries();
        if (entries == null || entries.isEmpty()) {
            return Optional.empty();
        }
        GetLedgerEntriesResponse.LedgerEntryResult result = entries.get(0);
        return Optional.of(result);
    }

    public GetLedgerEntriesResponse getLedgerEntries(Collection<LedgerKey> keys) {
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("At least one key must be provided.");
        }
        ArrayList<String> xdrKeys = new ArrayList<String>(keys.size());
        for (LedgerKey key : keys) {
            String xdrBase64;
            try {
                xdrBase64 = key.toXdrBase64();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid ledgerKey: " + key, e);
            }
            xdrKeys.add(xdrBase64);
        }
        GetLedgerEntriesRequest params = new GetLedgerEntriesRequest(xdrKeys);
        return this.sendRequest("getLedgerEntries", params, new TypeToken<SorobanRpcResponse<GetLedgerEntriesResponse>>(){});
    }

    public GetTransactionResponse getTransaction(String hash) {
        GetTransactionRequest params = new GetTransactionRequest(hash);
        return this.sendRequest("getTransaction", params, new TypeToken<SorobanRpcResponse<GetTransactionResponse>>(){});
    }

    public GetTransactionsResponse getTransactions(GetTransactionsRequest getTransactionsRequest) {
        return this.sendRequest("getTransactions", getTransactionsRequest, new TypeToken<SorobanRpcResponse<GetTransactionsResponse>>(){});
    }

    public GetLedgersResponse getLedgers(GetLedgersRequest getLedgersRequest) {
        return this.sendRequest("getLedgers", getLedgersRequest, new TypeToken<SorobanRpcResponse<GetLedgersResponse>>(){});
    }

    public GetEventsResponse getEvents(GetEventsRequest getEventsRequest) {
        return this.sendRequest("getEvents", getEventsRequest, new TypeToken<SorobanRpcResponse<GetEventsResponse>>(){});
    }

    public GetVersionInfoResponse getVersionInfo() {
        return this.sendRequest("getVersionInfo", null, new TypeToken<SorobanRpcResponse<GetVersionInfoResponse>>(){});
    }

    public GetNetworkResponse getNetwork() {
        return this.sendRequest("getNetwork", null, new TypeToken<SorobanRpcResponse<GetNetworkResponse>>(){});
    }

    public GetLatestLedgerResponse getLatestLedger() {
        return this.sendRequest("getLatestLedger", null, new TypeToken<SorobanRpcResponse<GetLatestLedgerResponse>>(){});
    }

    public SimulateTransactionResponse simulateTransaction(Transaction transaction, @Nullable SimulateTransactionRequest.ResourceConfig resourceConfig) {
        SimulateTransactionRequest params = new SimulateTransactionRequest(transaction.toEnvelopeXdrBase64(), resourceConfig);
        return this.sendRequest("simulateTransaction", params, new TypeToken<SorobanRpcResponse<SimulateTransactionResponse>>(){});
    }

    public SimulateTransactionResponse simulateTransaction(Transaction transaction) {
        return this.simulateTransaction(transaction, null);
    }

    public Transaction prepareTransaction(Transaction transaction) {
        SimulateTransactionResponse simulateTransactionResponse = this.simulateTransaction(transaction);
        return this.prepareTransaction(transaction, simulateTransactionResponse);
    }

    public Transaction prepareTransaction(Transaction transaction, SimulateTransactionResponse simulateTransactionResponse) {
        if (simulateTransactionResponse.getError() != null) {
            throw new PrepareTransactionException("simulation transaction failed, the response contains error information.", simulateTransactionResponse);
        }
        return SorobanServer.assembleTransaction(transaction, simulateTransactionResponse);
    }

    public SendTransactionResponse sendTransaction(Transaction transaction) {
        SendTransactionRequest params = new SendTransactionRequest(transaction.toEnvelopeXdrBase64());
        return this.sendRequest("sendTransaction", params, new TypeToken<SorobanRpcResponse<SendTransactionResponse>>(){});
    }

    public GetSACBalanceResponse getSACBalance(String contractId, Asset asset, Network network) {
        if (!StrKey.isValidContract(contractId)) {
            throw new IllegalArgumentException("Invalid contract ID: " + contractId);
        }
        LedgerKey ledgerKey = LedgerKey.builder().discriminant(LedgerEntryType.CONTRACT_DATA).contractData(LedgerKey.LedgerKeyContractData.builder().contract(Scv.toAddress(asset.getContractId(network)).getAddress()).key(Scv.toVec(Arrays.asList(Scv.toSymbol("Balance"), Scv.toAddress(contractId)))).durability(ContractDataDurability.PERSISTENT).build()).build();
        GetLedgerEntriesResponse response = this.getLedgerEntries(Collections.singleton(ledgerKey));
        List<GetLedgerEntriesResponse.LedgerEntryResult> entries = response.getEntries();
        if (entries == null || entries.isEmpty()) {
            return GetSACBalanceResponse.builder().latestLedger(response.getLatestLedger()).build();
        }
        GetLedgerEntriesResponse.LedgerEntryResult entry = entries.get(0);
        LedgerEntry.LedgerEntryData ledgerEntryData = Util.parseXdr(entry.getXdr(), LedgerEntry.LedgerEntryData::fromXdrBase64);
        LinkedHashMap<SCVal, SCVal> balanceMap = Scv.fromMap(ledgerEntryData.getContractData().getVal());
        return GetSACBalanceResponse.builder().latestLedger(response.getLatestLedger()).balanceEntry(GetSACBalanceResponse.BalanceEntry.builder().liveUntilLedgerSeq(entry.getLiveUntilLedger()).lastModifiedLedgerSeq(entry.getLastModifiedLedger()).amount(Scv.fromInt128(balanceMap.get(Scv.toSymbol("amount"))).toString()).authorized(Scv.fromBoolean(balanceMap.get(Scv.toSymbol("authorized")))).clawback(Scv.fromBoolean(balanceMap.get(Scv.toSymbol("clawback")))).build()).build();
    }

    public static Transaction assembleTransaction(Transaction transaction, SimulateTransactionResponse simulateTransactionResponse) {
        SorobanTransactionData sorobanData;
        if (!transaction.isSorobanTransaction()) {
            throw new IllegalArgumentException("unsupported transaction: must contain exactly one InvokeHostFunctionOperation, BumpSequenceOperation, or RestoreFootprintOperation");
        }
        long classicFeeNum = transaction.getFee();
        if (transaction.getSorobanData() != null) {
            classicFeeNum -= transaction.getSorobanData().getResourceFee().getInt64().longValue();
        }
        long minResourceFeeNum = Optional.ofNullable(simulateTransactionResponse.getMinResourceFee()).orElse(0L);
        long fee = classicFeeNum + minResourceFeeNum;
        Operation operation = transaction.getOperations()[0];
        if (operation instanceof InvokeHostFunctionOperation) {
            if (simulateTransactionResponse.getResults() == null || simulateTransactionResponse.getResults().size() != 1) {
                throw new IllegalArgumentException("invalid simulateTransactionResponse: results must contain exactly one element if the operation is an InvokeHostFunctionOperation");
            }
            SimulateTransactionResponse.SimulateHostFunctionResult simulateHostFunctionResult = simulateTransactionResponse.getResults().get(0);
            List<SorobanAuthorizationEntry> existingEntries = ((InvokeHostFunctionOperation)operation).getAuth();
            if (existingEntries.isEmpty() && simulateHostFunctionResult.getAuth() != null && !simulateHostFunctionResult.getAuth().isEmpty()) {
                ArrayList<SorobanAuthorizationEntry> authorizationEntries = new ArrayList<SorobanAuthorizationEntry>(simulateHostFunctionResult.getAuth().size());
                for (String auth : simulateHostFunctionResult.getAuth()) {
                    try {
                        authorizationEntries.add(SorobanAuthorizationEntry.fromXdrBase64(auth));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid auth: " + auth, e);
                    }
                }
                operation = ((InvokeHostFunctionOperation.InvokeHostFunctionOperationBuilder)((InvokeHostFunctionOperation.InvokeHostFunctionOperationBuilder)((Operation.OperationBuilder)InvokeHostFunctionOperation.builder().hostFunction(((InvokeHostFunctionOperation)operation).getHostFunction())).sourceAccount(operation.getSourceAccount())).auth(authorizationEntries)).build();
            }
        }
        try {
            sorobanData = SorobanTransactionData.fromXdrBase64(simulateTransactionResponse.getTransactionData());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid transactionData: " + simulateTransactionResponse.getTransactionData(), e);
        }
        return new Transaction(transaction.getSourceAccount(), fee, transaction.getSequenceNumber(), new Operation[]{operation}, transaction.getMemo(), transaction.getPreconditions(), sorobanData, transaction.getNetwork());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, R> R sendRequest(String method, @Nullable T params, TypeToken<SorobanRpcResponse<R>> responseType) {
        String requestId = SorobanServer.generateRequestId();
        ResponseHandler<SorobanRpcResponse<R>> responseHandler = new ResponseHandler<SorobanRpcResponse<R>>(responseType);
        SorobanRpcRequest<T> sorobanRpcRequest = new SorobanRpcRequest<T>(requestId, method, params);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((byte[])this.gson.toJson(sorobanRpcRequest).getBytes(), (MediaType)mediaType);
        Request request = new Request.Builder().url(this.serverURI).post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            SorobanRpcResponse<R> sorobanRpcResponse = responseHandler.handleResponse(response);
            if (sorobanRpcResponse.getError() != null) {
                SorobanRpcResponse.Error error = sorobanRpcResponse.getError();
                throw new SorobanRpcException(error.getCode(), error.getMessage(), error.getData());
            }
            R r = sorobanRpcResponse.getResult();
            return r;
        }
        catch (SocketTimeoutException e) {
            throw new RequestTimeoutException(e);
        }
        catch (IOException e) {
            throw new ConnectionErrorException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.connectionPool().evictAll();
    }

    private static String generateRequestId() {
        return UUID.randomUUID().toString();
    }

    public static enum Durability {
        TEMPORARY,
        PERSISTENT;

    }
}

