/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountEntryExtensionV3
implements XdrElement {
    private ExtensionPoint ext;
    private Uint32 seqLedger;
    private TimePoint seqTime;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.seqLedger.encode(stream);
        this.seqTime.encode(stream);
    }

    public static AccountEntryExtensionV3 decode(XdrDataInputStream stream) throws IOException {
        AccountEntryExtensionV3 decodedAccountEntryExtensionV3 = new AccountEntryExtensionV3();
        decodedAccountEntryExtensionV3.ext = ExtensionPoint.decode(stream);
        decodedAccountEntryExtensionV3.seqLedger = Uint32.decode(stream);
        decodedAccountEntryExtensionV3.seqTime = TimePoint.decode(stream);
        return decodedAccountEntryExtensionV3;
    }

    public static AccountEntryExtensionV3 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountEntryExtensionV3.fromXdrByteArray(bytes);
    }

    public static AccountEntryExtensionV3 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountEntryExtensionV3.decode(xdrDataInputStream);
    }

    @Generated
    public static AccountEntryExtensionV3Builder builder() {
        return new AccountEntryExtensionV3Builder();
    }

    @Generated
    public AccountEntryExtensionV3Builder toBuilder() {
        return new AccountEntryExtensionV3Builder().ext(this.ext).seqLedger(this.seqLedger).seqTime(this.seqTime);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public Uint32 getSeqLedger() {
        return this.seqLedger;
    }

    @Generated
    public TimePoint getSeqTime() {
        return this.seqTime;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setSeqLedger(Uint32 seqLedger) {
        this.seqLedger = seqLedger;
    }

    @Generated
    public void setSeqTime(TimePoint seqTime) {
        this.seqTime = seqTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountEntryExtensionV3)) {
            return false;
        }
        AccountEntryExtensionV3 other = (AccountEntryExtensionV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        Uint32 this$seqLedger = this.getSeqLedger();
        Uint32 other$seqLedger = other.getSeqLedger();
        if (this$seqLedger == null ? other$seqLedger != null : !((Object)this$seqLedger).equals(other$seqLedger)) {
            return false;
        }
        TimePoint this$seqTime = this.getSeqTime();
        TimePoint other$seqTime = other.getSeqTime();
        return !(this$seqTime == null ? other$seqTime != null : !((Object)this$seqTime).equals(other$seqTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountEntryExtensionV3;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        Uint32 $seqLedger = this.getSeqLedger();
        result = result * 59 + ($seqLedger == null ? 43 : ((Object)$seqLedger).hashCode());
        TimePoint $seqTime = this.getSeqTime();
        result = result * 59 + ($seqTime == null ? 43 : ((Object)$seqTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountEntryExtensionV3(ext=" + this.getExt() + ", seqLedger=" + this.getSeqLedger() + ", seqTime=" + this.getSeqTime() + ")";
    }

    @Generated
    public AccountEntryExtensionV3() {
    }

    @Generated
    public AccountEntryExtensionV3(ExtensionPoint ext, Uint32 seqLedger, TimePoint seqTime) {
        this.ext = ext;
        this.seqLedger = seqLedger;
        this.seqTime = seqTime;
    }

    @Generated
    public static class AccountEntryExtensionV3Builder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private Uint32 seqLedger;
        @Generated
        private TimePoint seqTime;

        @Generated
        AccountEntryExtensionV3Builder() {
        }

        @Generated
        public AccountEntryExtensionV3Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public AccountEntryExtensionV3Builder seqLedger(Uint32 seqLedger) {
            this.seqLedger = seqLedger;
            return this;
        }

        @Generated
        public AccountEntryExtensionV3Builder seqTime(TimePoint seqTime) {
            this.seqTime = seqTime;
            return this;
        }

        @Generated
        public AccountEntryExtensionV3 build() {
            return new AccountEntryExtensionV3(this.ext, this.seqLedger, this.seqTime);
        }

        @Generated
        public String toString() {
            return "AccountEntryExtensionV3.AccountEntryExtensionV3Builder(ext=" + this.ext + ", seqLedger=" + this.seqLedger + ", seqTime=" + this.seqTime + ")";
        }
    }
}

