/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ArchivalProofType;
import org.stellar.sdk.xdr.ExistenceProofBody;
import org.stellar.sdk.xdr.NonexistenceProofBody;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ArchivalProof
implements XdrElement {
    private Uint32 epoch;
    private ArchivalProofBody body;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.epoch.encode(stream);
        this.body.encode(stream);
    }

    public static ArchivalProof decode(XdrDataInputStream stream) throws IOException {
        ArchivalProof decodedArchivalProof = new ArchivalProof();
        decodedArchivalProof.epoch = Uint32.decode(stream);
        decodedArchivalProof.body = ArchivalProofBody.decode(stream);
        return decodedArchivalProof;
    }

    public static ArchivalProof fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ArchivalProof.fromXdrByteArray(bytes);
    }

    public static ArchivalProof fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ArchivalProof.decode(xdrDataInputStream);
    }

    @Generated
    public static ArchivalProofBuilder builder() {
        return new ArchivalProofBuilder();
    }

    @Generated
    public ArchivalProofBuilder toBuilder() {
        return new ArchivalProofBuilder().epoch(this.epoch).body(this.body);
    }

    @Generated
    public Uint32 getEpoch() {
        return this.epoch;
    }

    @Generated
    public ArchivalProofBody getBody() {
        return this.body;
    }

    @Generated
    public void setEpoch(Uint32 epoch) {
        this.epoch = epoch;
    }

    @Generated
    public void setBody(ArchivalProofBody body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivalProof)) {
            return false;
        }
        ArchivalProof other = (ArchivalProof)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$epoch = this.getEpoch();
        Uint32 other$epoch = other.getEpoch();
        if (this$epoch == null ? other$epoch != null : !((Object)this$epoch).equals(other$epoch)) {
            return false;
        }
        ArchivalProofBody this$body = this.getBody();
        ArchivalProofBody other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivalProof;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $epoch = this.getEpoch();
        result = result * 59 + ($epoch == null ? 43 : ((Object)$epoch).hashCode());
        ArchivalProofBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArchivalProof(epoch=" + this.getEpoch() + ", body=" + this.getBody() + ")";
    }

    @Generated
    public ArchivalProof() {
    }

    @Generated
    public ArchivalProof(Uint32 epoch, ArchivalProofBody body) {
        this.epoch = epoch;
        this.body = body;
    }

    public static class ArchivalProofBody
    implements XdrElement {
        private ArchivalProofType discriminant;
        private NonexistenceProofBody nonexistenceProof;
        private ExistenceProofBody existenceProof;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case EXISTENCE: {
                    this.nonexistenceProof.encode(stream);
                    break;
                }
                case NONEXISTENCE: {
                    this.existenceProof.encode(stream);
                }
            }
        }

        public static ArchivalProofBody decode(XdrDataInputStream stream) throws IOException {
            ArchivalProofBody decodedArchivalProofBody = new ArchivalProofBody();
            ArchivalProofType discriminant = ArchivalProofType.decode(stream);
            decodedArchivalProofBody.setDiscriminant(discriminant);
            switch (decodedArchivalProofBody.getDiscriminant()) {
                case EXISTENCE: {
                    decodedArchivalProofBody.nonexistenceProof = NonexistenceProofBody.decode(stream);
                    break;
                }
                case NONEXISTENCE: {
                    decodedArchivalProofBody.existenceProof = ExistenceProofBody.decode(stream);
                }
            }
            return decodedArchivalProofBody;
        }

        public static ArchivalProofBody fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ArchivalProofBody.fromXdrByteArray(bytes);
        }

        public static ArchivalProofBody fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ArchivalProofBody.decode(xdrDataInputStream);
        }

        @Generated
        public static ArchivalProofBodyBuilder builder() {
            return new ArchivalProofBodyBuilder();
        }

        @Generated
        public ArchivalProofBodyBuilder toBuilder() {
            return new ArchivalProofBodyBuilder().discriminant(this.discriminant).nonexistenceProof(this.nonexistenceProof).existenceProof(this.existenceProof);
        }

        @Generated
        public ArchivalProofType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public NonexistenceProofBody getNonexistenceProof() {
            return this.nonexistenceProof;
        }

        @Generated
        public ExistenceProofBody getExistenceProof() {
            return this.existenceProof;
        }

        @Generated
        public void setDiscriminant(ArchivalProofType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setNonexistenceProof(NonexistenceProofBody nonexistenceProof) {
            this.nonexistenceProof = nonexistenceProof;
        }

        @Generated
        public void setExistenceProof(ExistenceProofBody existenceProof) {
            this.existenceProof = existenceProof;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArchivalProofBody)) {
                return false;
            }
            ArchivalProofBody other = (ArchivalProofBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ArchivalProofType this$discriminant = this.getDiscriminant();
            ArchivalProofType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            NonexistenceProofBody this$nonexistenceProof = this.getNonexistenceProof();
            NonexistenceProofBody other$nonexistenceProof = other.getNonexistenceProof();
            if (this$nonexistenceProof == null ? other$nonexistenceProof != null : !((Object)this$nonexistenceProof).equals(other$nonexistenceProof)) {
                return false;
            }
            ExistenceProofBody this$existenceProof = this.getExistenceProof();
            ExistenceProofBody other$existenceProof = other.getExistenceProof();
            return !(this$existenceProof == null ? other$existenceProof != null : !((Object)this$existenceProof).equals(other$existenceProof));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ArchivalProofBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ArchivalProofType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            NonexistenceProofBody $nonexistenceProof = this.getNonexistenceProof();
            result = result * 59 + ($nonexistenceProof == null ? 43 : ((Object)$nonexistenceProof).hashCode());
            ExistenceProofBody $existenceProof = this.getExistenceProof();
            result = result * 59 + ($existenceProof == null ? 43 : ((Object)$existenceProof).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ArchivalProof.ArchivalProofBody(discriminant=" + this.getDiscriminant() + ", nonexistenceProof=" + this.getNonexistenceProof() + ", existenceProof=" + this.getExistenceProof() + ")";
        }

        @Generated
        public ArchivalProofBody() {
        }

        @Generated
        public ArchivalProofBody(ArchivalProofType discriminant, NonexistenceProofBody nonexistenceProof, ExistenceProofBody existenceProof) {
            this.discriminant = discriminant;
            this.nonexistenceProof = nonexistenceProof;
            this.existenceProof = existenceProof;
        }

        @Generated
        public static class ArchivalProofBodyBuilder {
            @Generated
            private ArchivalProofType discriminant;
            @Generated
            private NonexistenceProofBody nonexistenceProof;
            @Generated
            private ExistenceProofBody existenceProof;

            @Generated
            ArchivalProofBodyBuilder() {
            }

            @Generated
            public ArchivalProofBodyBuilder discriminant(ArchivalProofType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public ArchivalProofBodyBuilder nonexistenceProof(NonexistenceProofBody nonexistenceProof) {
                this.nonexistenceProof = nonexistenceProof;
                return this;
            }

            @Generated
            public ArchivalProofBodyBuilder existenceProof(ExistenceProofBody existenceProof) {
                this.existenceProof = existenceProof;
                return this;
            }

            @Generated
            public ArchivalProofBody build() {
                return new ArchivalProofBody(this.discriminant, this.nonexistenceProof, this.existenceProof);
            }

            @Generated
            public String toString() {
                return "ArchivalProof.ArchivalProofBody.ArchivalProofBodyBuilder(discriminant=" + this.discriminant + ", nonexistenceProof=" + this.nonexistenceProof + ", existenceProof=" + this.existenceProof + ")";
            }
        }
    }

    @Generated
    public static class ArchivalProofBuilder {
        @Generated
        private Uint32 epoch;
        @Generated
        private ArchivalProofBody body;

        @Generated
        ArchivalProofBuilder() {
        }

        @Generated
        public ArchivalProofBuilder epoch(Uint32 epoch) {
            this.epoch = epoch;
            return this;
        }

        @Generated
        public ArchivalProofBuilder body(ArchivalProofBody body) {
            this.body = body;
            return this;
        }

        @Generated
        public ArchivalProof build() {
            return new ArchivalProof(this.epoch, this.body);
        }

        @Generated
        public String toString() {
            return "ArchivalProof.ArchivalProofBuilder(epoch=" + this.epoch + ", body=" + this.body + ")";
        }
    }
}

