/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum CreateAccountResultCode implements XdrElement
{
    CREATE_ACCOUNT_SUCCESS(0),
    CREATE_ACCOUNT_MALFORMED(-1),
    CREATE_ACCOUNT_UNDERFUNDED(-2),
    CREATE_ACCOUNT_LOW_RESERVE(-3),
    CREATE_ACCOUNT_ALREADY_EXIST(-4);

    private final int value;

    private CreateAccountResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CreateAccountResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CREATE_ACCOUNT_SUCCESS;
            }
            case -1: {
                return CREATE_ACCOUNT_MALFORMED;
            }
            case -2: {
                return CREATE_ACCOUNT_UNDERFUNDED;
            }
            case -3: {
                return CREATE_ACCOUNT_LOW_RESERVE;
            }
            case -4: {
                return CREATE_ACCOUNT_ALREADY_EXIST;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static CreateAccountResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateAccountResultCode.fromXdrByteArray(bytes);
    }

    public static CreateAccountResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateAccountResultCode.decode(xdrDataInputStream);
    }
}

