/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerBounds
implements XdrElement {
    private Uint32 minLedger;
    private Uint32 maxLedger;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.minLedger.encode(stream);
        this.maxLedger.encode(stream);
    }

    public static LedgerBounds decode(XdrDataInputStream stream) throws IOException {
        LedgerBounds decodedLedgerBounds = new LedgerBounds();
        decodedLedgerBounds.minLedger = Uint32.decode(stream);
        decodedLedgerBounds.maxLedger = Uint32.decode(stream);
        return decodedLedgerBounds;
    }

    public static LedgerBounds fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerBounds.fromXdrByteArray(bytes);
    }

    public static LedgerBounds fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerBounds.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerBoundsBuilder builder() {
        return new LedgerBoundsBuilder();
    }

    @Generated
    public LedgerBoundsBuilder toBuilder() {
        return new LedgerBoundsBuilder().minLedger(this.minLedger).maxLedger(this.maxLedger);
    }

    @Generated
    public Uint32 getMinLedger() {
        return this.minLedger;
    }

    @Generated
    public Uint32 getMaxLedger() {
        return this.maxLedger;
    }

    @Generated
    public void setMinLedger(Uint32 minLedger) {
        this.minLedger = minLedger;
    }

    @Generated
    public void setMaxLedger(Uint32 maxLedger) {
        this.maxLedger = maxLedger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerBounds)) {
            return false;
        }
        LedgerBounds other = (LedgerBounds)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$minLedger = this.getMinLedger();
        Uint32 other$minLedger = other.getMinLedger();
        if (this$minLedger == null ? other$minLedger != null : !((Object)this$minLedger).equals(other$minLedger)) {
            return false;
        }
        Uint32 this$maxLedger = this.getMaxLedger();
        Uint32 other$maxLedger = other.getMaxLedger();
        return !(this$maxLedger == null ? other$maxLedger != null : !((Object)this$maxLedger).equals(other$maxLedger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerBounds;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $minLedger = this.getMinLedger();
        result = result * 59 + ($minLedger == null ? 43 : ((Object)$minLedger).hashCode());
        Uint32 $maxLedger = this.getMaxLedger();
        result = result * 59 + ($maxLedger == null ? 43 : ((Object)$maxLedger).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerBounds(minLedger=" + this.getMinLedger() + ", maxLedger=" + this.getMaxLedger() + ")";
    }

    @Generated
    public LedgerBounds() {
    }

    @Generated
    public LedgerBounds(Uint32 minLedger, Uint32 maxLedger) {
        this.minLedger = minLedger;
        this.maxLedger = maxLedger;
    }

    @Generated
    public static class LedgerBoundsBuilder {
        @Generated
        private Uint32 minLedger;
        @Generated
        private Uint32 maxLedger;

        @Generated
        LedgerBoundsBuilder() {
        }

        @Generated
        public LedgerBoundsBuilder minLedger(Uint32 minLedger) {
            this.minLedger = minLedger;
            return this;
        }

        @Generated
        public LedgerBoundsBuilder maxLedger(Uint32 maxLedger) {
            this.maxLedger = maxLedger;
            return this;
        }

        @Generated
        public LedgerBounds build() {
            return new LedgerBounds(this.minLedger, this.maxLedger);
        }

        @Generated
        public String toString() {
            return "LedgerBounds.LedgerBoundsBuilder(minLedger=" + this.minLedger + ", maxLedger=" + this.maxLedger + ")";
        }
    }
}

