/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ConfigUpgradeSetKey;
import org.stellar.sdk.xdr.LedgerUpgradeType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerUpgrade
implements XdrElement {
    private LedgerUpgradeType discriminant;
    private Uint32 newLedgerVersion;
    private Uint32 newBaseFee;
    private Uint32 newMaxTxSetSize;
    private Uint32 newBaseReserve;
    private Uint32 newFlags;
    private ConfigUpgradeSetKey newConfig;
    private Uint32 newMaxSorobanTxSetSize;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case LEDGER_UPGRADE_VERSION: {
                this.newLedgerVersion.encode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_FEE: {
                this.newBaseFee.encode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_TX_SET_SIZE: {
                this.newMaxTxSetSize.encode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_RESERVE: {
                this.newBaseReserve.encode(stream);
                break;
            }
            case LEDGER_UPGRADE_FLAGS: {
                this.newFlags.encode(stream);
                break;
            }
            case LEDGER_UPGRADE_CONFIG: {
                this.newConfig.encode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE: {
                this.newMaxSorobanTxSetSize.encode(stream);
            }
        }
    }

    public static LedgerUpgrade decode(XdrDataInputStream stream) throws IOException {
        LedgerUpgrade decodedLedgerUpgrade = new LedgerUpgrade();
        LedgerUpgradeType discriminant = LedgerUpgradeType.decode(stream);
        decodedLedgerUpgrade.setDiscriminant(discriminant);
        switch (decodedLedgerUpgrade.getDiscriminant()) {
            case LEDGER_UPGRADE_VERSION: {
                decodedLedgerUpgrade.newLedgerVersion = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_FEE: {
                decodedLedgerUpgrade.newBaseFee = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_TX_SET_SIZE: {
                decodedLedgerUpgrade.newMaxTxSetSize = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_RESERVE: {
                decodedLedgerUpgrade.newBaseReserve = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_FLAGS: {
                decodedLedgerUpgrade.newFlags = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_CONFIG: {
                decodedLedgerUpgrade.newConfig = ConfigUpgradeSetKey.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE: {
                decodedLedgerUpgrade.newMaxSorobanTxSetSize = Uint32.decode(stream);
            }
        }
        return decodedLedgerUpgrade;
    }

    public static LedgerUpgrade fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerUpgrade.fromXdrByteArray(bytes);
    }

    public static LedgerUpgrade fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerUpgrade.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerUpgradeBuilder builder() {
        return new LedgerUpgradeBuilder();
    }

    @Generated
    public LedgerUpgradeBuilder toBuilder() {
        return new LedgerUpgradeBuilder().discriminant(this.discriminant).newLedgerVersion(this.newLedgerVersion).newBaseFee(this.newBaseFee).newMaxTxSetSize(this.newMaxTxSetSize).newBaseReserve(this.newBaseReserve).newFlags(this.newFlags).newConfig(this.newConfig).newMaxSorobanTxSetSize(this.newMaxSorobanTxSetSize);
    }

    @Generated
    public LedgerUpgradeType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Uint32 getNewLedgerVersion() {
        return this.newLedgerVersion;
    }

    @Generated
    public Uint32 getNewBaseFee() {
        return this.newBaseFee;
    }

    @Generated
    public Uint32 getNewMaxTxSetSize() {
        return this.newMaxTxSetSize;
    }

    @Generated
    public Uint32 getNewBaseReserve() {
        return this.newBaseReserve;
    }

    @Generated
    public Uint32 getNewFlags() {
        return this.newFlags;
    }

    @Generated
    public ConfigUpgradeSetKey getNewConfig() {
        return this.newConfig;
    }

    @Generated
    public Uint32 getNewMaxSorobanTxSetSize() {
        return this.newMaxSorobanTxSetSize;
    }

    @Generated
    public void setDiscriminant(LedgerUpgradeType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setNewLedgerVersion(Uint32 newLedgerVersion) {
        this.newLedgerVersion = newLedgerVersion;
    }

    @Generated
    public void setNewBaseFee(Uint32 newBaseFee) {
        this.newBaseFee = newBaseFee;
    }

    @Generated
    public void setNewMaxTxSetSize(Uint32 newMaxTxSetSize) {
        this.newMaxTxSetSize = newMaxTxSetSize;
    }

    @Generated
    public void setNewBaseReserve(Uint32 newBaseReserve) {
        this.newBaseReserve = newBaseReserve;
    }

    @Generated
    public void setNewFlags(Uint32 newFlags) {
        this.newFlags = newFlags;
    }

    @Generated
    public void setNewConfig(ConfigUpgradeSetKey newConfig) {
        this.newConfig = newConfig;
    }

    @Generated
    public void setNewMaxSorobanTxSetSize(Uint32 newMaxSorobanTxSetSize) {
        this.newMaxSorobanTxSetSize = newMaxSorobanTxSetSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerUpgrade)) {
            return false;
        }
        LedgerUpgrade other = (LedgerUpgrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerUpgradeType this$discriminant = this.getDiscriminant();
        LedgerUpgradeType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Uint32 this$newLedgerVersion = this.getNewLedgerVersion();
        Uint32 other$newLedgerVersion = other.getNewLedgerVersion();
        if (this$newLedgerVersion == null ? other$newLedgerVersion != null : !((Object)this$newLedgerVersion).equals(other$newLedgerVersion)) {
            return false;
        }
        Uint32 this$newBaseFee = this.getNewBaseFee();
        Uint32 other$newBaseFee = other.getNewBaseFee();
        if (this$newBaseFee == null ? other$newBaseFee != null : !((Object)this$newBaseFee).equals(other$newBaseFee)) {
            return false;
        }
        Uint32 this$newMaxTxSetSize = this.getNewMaxTxSetSize();
        Uint32 other$newMaxTxSetSize = other.getNewMaxTxSetSize();
        if (this$newMaxTxSetSize == null ? other$newMaxTxSetSize != null : !((Object)this$newMaxTxSetSize).equals(other$newMaxTxSetSize)) {
            return false;
        }
        Uint32 this$newBaseReserve = this.getNewBaseReserve();
        Uint32 other$newBaseReserve = other.getNewBaseReserve();
        if (this$newBaseReserve == null ? other$newBaseReserve != null : !((Object)this$newBaseReserve).equals(other$newBaseReserve)) {
            return false;
        }
        Uint32 this$newFlags = this.getNewFlags();
        Uint32 other$newFlags = other.getNewFlags();
        if (this$newFlags == null ? other$newFlags != null : !((Object)this$newFlags).equals(other$newFlags)) {
            return false;
        }
        ConfigUpgradeSetKey this$newConfig = this.getNewConfig();
        ConfigUpgradeSetKey other$newConfig = other.getNewConfig();
        if (this$newConfig == null ? other$newConfig != null : !((Object)this$newConfig).equals(other$newConfig)) {
            return false;
        }
        Uint32 this$newMaxSorobanTxSetSize = this.getNewMaxSorobanTxSetSize();
        Uint32 other$newMaxSorobanTxSetSize = other.getNewMaxSorobanTxSetSize();
        return !(this$newMaxSorobanTxSetSize == null ? other$newMaxSorobanTxSetSize != null : !((Object)this$newMaxSorobanTxSetSize).equals(other$newMaxSorobanTxSetSize));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerUpgrade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerUpgradeType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Uint32 $newLedgerVersion = this.getNewLedgerVersion();
        result = result * 59 + ($newLedgerVersion == null ? 43 : ((Object)$newLedgerVersion).hashCode());
        Uint32 $newBaseFee = this.getNewBaseFee();
        result = result * 59 + ($newBaseFee == null ? 43 : ((Object)$newBaseFee).hashCode());
        Uint32 $newMaxTxSetSize = this.getNewMaxTxSetSize();
        result = result * 59 + ($newMaxTxSetSize == null ? 43 : ((Object)$newMaxTxSetSize).hashCode());
        Uint32 $newBaseReserve = this.getNewBaseReserve();
        result = result * 59 + ($newBaseReserve == null ? 43 : ((Object)$newBaseReserve).hashCode());
        Uint32 $newFlags = this.getNewFlags();
        result = result * 59 + ($newFlags == null ? 43 : ((Object)$newFlags).hashCode());
        ConfigUpgradeSetKey $newConfig = this.getNewConfig();
        result = result * 59 + ($newConfig == null ? 43 : ((Object)$newConfig).hashCode());
        Uint32 $newMaxSorobanTxSetSize = this.getNewMaxSorobanTxSetSize();
        result = result * 59 + ($newMaxSorobanTxSetSize == null ? 43 : ((Object)$newMaxSorobanTxSetSize).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerUpgrade(discriminant=" + this.getDiscriminant() + ", newLedgerVersion=" + this.getNewLedgerVersion() + ", newBaseFee=" + this.getNewBaseFee() + ", newMaxTxSetSize=" + this.getNewMaxTxSetSize() + ", newBaseReserve=" + this.getNewBaseReserve() + ", newFlags=" + this.getNewFlags() + ", newConfig=" + this.getNewConfig() + ", newMaxSorobanTxSetSize=" + this.getNewMaxSorobanTxSetSize() + ")";
    }

    @Generated
    public LedgerUpgrade() {
    }

    @Generated
    public LedgerUpgrade(LedgerUpgradeType discriminant, Uint32 newLedgerVersion, Uint32 newBaseFee, Uint32 newMaxTxSetSize, Uint32 newBaseReserve, Uint32 newFlags, ConfigUpgradeSetKey newConfig, Uint32 newMaxSorobanTxSetSize) {
        this.discriminant = discriminant;
        this.newLedgerVersion = newLedgerVersion;
        this.newBaseFee = newBaseFee;
        this.newMaxTxSetSize = newMaxTxSetSize;
        this.newBaseReserve = newBaseReserve;
        this.newFlags = newFlags;
        this.newConfig = newConfig;
        this.newMaxSorobanTxSetSize = newMaxSorobanTxSetSize;
    }

    @Generated
    public static class LedgerUpgradeBuilder {
        @Generated
        private LedgerUpgradeType discriminant;
        @Generated
        private Uint32 newLedgerVersion;
        @Generated
        private Uint32 newBaseFee;
        @Generated
        private Uint32 newMaxTxSetSize;
        @Generated
        private Uint32 newBaseReserve;
        @Generated
        private Uint32 newFlags;
        @Generated
        private ConfigUpgradeSetKey newConfig;
        @Generated
        private Uint32 newMaxSorobanTxSetSize;

        @Generated
        LedgerUpgradeBuilder() {
        }

        @Generated
        public LedgerUpgradeBuilder discriminant(LedgerUpgradeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newLedgerVersion(Uint32 newLedgerVersion) {
            this.newLedgerVersion = newLedgerVersion;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newBaseFee(Uint32 newBaseFee) {
            this.newBaseFee = newBaseFee;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newMaxTxSetSize(Uint32 newMaxTxSetSize) {
            this.newMaxTxSetSize = newMaxTxSetSize;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newBaseReserve(Uint32 newBaseReserve) {
            this.newBaseReserve = newBaseReserve;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newFlags(Uint32 newFlags) {
            this.newFlags = newFlags;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newConfig(ConfigUpgradeSetKey newConfig) {
            this.newConfig = newConfig;
            return this;
        }

        @Generated
        public LedgerUpgradeBuilder newMaxSorobanTxSetSize(Uint32 newMaxSorobanTxSetSize) {
            this.newMaxSorobanTxSetSize = newMaxSorobanTxSetSize;
            return this;
        }

        @Generated
        public LedgerUpgrade build() {
            return new LedgerUpgrade(this.discriminant, this.newLedgerVersion, this.newBaseFee, this.newMaxTxSetSize, this.newBaseReserve, this.newFlags, this.newConfig, this.newMaxSorobanTxSetSize);
        }

        @Generated
        public String toString() {
            return "LedgerUpgrade.LedgerUpgradeBuilder(discriminant=" + this.discriminant + ", newLedgerVersion=" + this.newLedgerVersion + ", newBaseFee=" + this.newBaseFee + ", newMaxTxSetSize=" + this.newMaxTxSetSize + ", newBaseReserve=" + this.newBaseReserve + ", newFlags=" + this.newFlags + ", newConfig=" + this.newConfig + ", newMaxSorobanTxSetSize=" + this.newMaxSorobanTxSetSize + ")";
        }
    }
}

