/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecUDTUnionCaseV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecUDTUnionV0
implements XdrElement {
    private XdrString doc;
    private XdrString lib;
    private XdrString name;
    private SCSpecUDTUnionCaseV0[] cases;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.doc.encode(stream);
        this.lib.encode(stream);
        this.name.encode(stream);
        int casesSize = this.getCases().length;
        stream.writeInt(casesSize);
        for (int i = 0; i < casesSize; ++i) {
            this.cases[i].encode(stream);
        }
    }

    public static SCSpecUDTUnionV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecUDTUnionV0 decodedSCSpecUDTUnionV0 = new SCSpecUDTUnionV0();
        decodedSCSpecUDTUnionV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecUDTUnionV0.lib = XdrString.decode(stream, 80);
        decodedSCSpecUDTUnionV0.name = XdrString.decode(stream, 60);
        int casesSize = stream.readInt();
        decodedSCSpecUDTUnionV0.cases = new SCSpecUDTUnionCaseV0[casesSize];
        for (int i = 0; i < casesSize; ++i) {
            decodedSCSpecUDTUnionV0.cases[i] = SCSpecUDTUnionCaseV0.decode(stream);
        }
        return decodedSCSpecUDTUnionV0;
    }

    public static SCSpecUDTUnionV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecUDTUnionV0.fromXdrByteArray(bytes);
    }

    public static SCSpecUDTUnionV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecUDTUnionV0.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecUDTUnionV0Builder builder() {
        return new SCSpecUDTUnionV0Builder();
    }

    @Generated
    public SCSpecUDTUnionV0Builder toBuilder() {
        return new SCSpecUDTUnionV0Builder().doc(this.doc).lib(this.lib).name(this.name).cases(this.cases);
    }

    @Generated
    public XdrString getDoc() {
        return this.doc;
    }

    @Generated
    public XdrString getLib() {
        return this.lib;
    }

    @Generated
    public XdrString getName() {
        return this.name;
    }

    @Generated
    public SCSpecUDTUnionCaseV0[] getCases() {
        return this.cases;
    }

    @Generated
    public void setDoc(XdrString doc) {
        this.doc = doc;
    }

    @Generated
    public void setLib(XdrString lib) {
        this.lib = lib;
    }

    @Generated
    public void setName(XdrString name) {
        this.name = name;
    }

    @Generated
    public void setCases(SCSpecUDTUnionCaseV0[] cases) {
        this.cases = cases;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecUDTUnionV0)) {
            return false;
        }
        SCSpecUDTUnionV0 other = (SCSpecUDTUnionV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XdrString this$doc = this.getDoc();
        XdrString other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        XdrString this$lib = this.getLib();
        XdrString other$lib = other.getLib();
        if (this$lib == null ? other$lib != null : !((Object)this$lib).equals(other$lib)) {
            return false;
        }
        XdrString this$name = this.getName();
        XdrString other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        return Arrays.deepEquals(this.getCases(), other.getCases());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecUDTUnionV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XdrString $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        XdrString $lib = this.getLib();
        result = result * 59 + ($lib == null ? 43 : ((Object)$lib).hashCode());
        XdrString $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCases());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecUDTUnionV0(doc=" + this.getDoc() + ", lib=" + this.getLib() + ", name=" + this.getName() + ", cases=" + Arrays.deepToString(this.getCases()) + ")";
    }

    @Generated
    public SCSpecUDTUnionV0() {
    }

    @Generated
    public SCSpecUDTUnionV0(XdrString doc, XdrString lib, XdrString name, SCSpecUDTUnionCaseV0[] cases) {
        this.doc = doc;
        this.lib = lib;
        this.name = name;
        this.cases = cases;
    }

    @Generated
    public static class SCSpecUDTUnionV0Builder {
        @Generated
        private XdrString doc;
        @Generated
        private XdrString lib;
        @Generated
        private XdrString name;
        @Generated
        private SCSpecUDTUnionCaseV0[] cases;

        @Generated
        SCSpecUDTUnionV0Builder() {
        }

        @Generated
        public SCSpecUDTUnionV0Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        @Generated
        public SCSpecUDTUnionV0Builder lib(XdrString lib) {
            this.lib = lib;
            return this;
        }

        @Generated
        public SCSpecUDTUnionV0Builder name(XdrString name) {
            this.name = name;
            return this;
        }

        @Generated
        public SCSpecUDTUnionV0Builder cases(SCSpecUDTUnionCaseV0[] cases) {
            this.cases = cases;
            return this;
        }

        @Generated
        public SCSpecUDTUnionV0 build() {
            return new SCSpecUDTUnionV0(this.doc, this.lib, this.name, this.cases);
        }

        @Generated
        public String toString() {
            return "SCSpecUDTUnionV0.SCSpecUDTUnionV0Builder(doc=" + this.doc + ", lib=" + this.lib + ", name=" + this.name + ", cases=" + Arrays.deepToString(this.cases) + ")";
        }
    }
}

