/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeOfferSponsorshipOperation
extends Operation {
    @NonNull
    private final String seller;
    @NonNull
    private final Long offerId;

    public static RevokeOfferSponsorshipOperation fromXdr(RevokeSponsorshipOp op) {
        long offerId = op.getLedgerKey().getOffer().getOfferID().getInt64();
        String seller = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getOffer().getSellerID());
        return new RevokeOfferSponsorshipOperation(seller, offerId);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.OFFER);
        LedgerKey.LedgerKeyOffer offer = new LedgerKey.LedgerKeyOffer();
        Int64 id = new Int64();
        id.setInt64(this.offerId);
        offer.setOfferID(id);
        offer.setSellerID(StrKey.encodeToXDRAccountId(this.seller));
        key.setOffer(offer);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @Generated
    protected RevokeOfferSponsorshipOperation(RevokeOfferSponsorshipOperationBuilder<?, ?> b) {
        super(b);
        this.seller = ((RevokeOfferSponsorshipOperationBuilder)b).seller;
        if (this.seller == null) {
            throw new NullPointerException("seller is marked non-null but is null");
        }
        this.offerId = ((RevokeOfferSponsorshipOperationBuilder)b).offerId;
        if (this.offerId == null) {
            throw new NullPointerException("offerId is marked non-null but is null");
        }
    }

    @Generated
    public static RevokeOfferSponsorshipOperationBuilder<?, ?> builder() {
        return new RevokeOfferSponsorshipOperationBuilderImpl();
    }

    @Generated
    public RevokeOfferSponsorshipOperationBuilder<?, ?> toBuilder() {
        return new RevokeOfferSponsorshipOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getSeller() {
        return this.seller;
    }

    @NonNull
    @Generated
    public Long getOfferId() {
        return this.offerId;
    }

    @Generated
    public String toString() {
        return "RevokeOfferSponsorshipOperation(super=" + super.toString() + ", seller=" + this.getSeller() + ", offerId=" + this.getOfferId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeOfferSponsorshipOperation)) {
            return false;
        }
        RevokeOfferSponsorshipOperation other = (RevokeOfferSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$offerId = this.getOfferId();
        Long other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !((Object)this$offerId).equals(other$offerId)) {
            return false;
        }
        String this$seller = this.getSeller();
        String other$seller = other.getSeller();
        return !(this$seller == null ? other$seller != null : !this$seller.equals(other$seller));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeOfferSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : ((Object)$offerId).hashCode());
        String $seller = this.getSeller();
        result = result * 59 + ($seller == null ? 43 : $seller.hashCode());
        return result;
    }

    @Generated
    private RevokeOfferSponsorshipOperation(@NonNull String seller, @NonNull Long offerId) {
        if (seller == null) {
            throw new NullPointerException("seller is marked non-null but is null");
        }
        if (offerId == null) {
            throw new NullPointerException("offerId is marked non-null but is null");
        }
        this.seller = seller;
        this.offerId = offerId;
    }

    @Generated
    public static abstract class RevokeOfferSponsorshipOperationBuilder<C extends RevokeOfferSponsorshipOperation, B extends RevokeOfferSponsorshipOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String seller;
        @Generated
        private Long offerId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RevokeOfferSponsorshipOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RevokeOfferSponsorshipOperation instance, RevokeOfferSponsorshipOperationBuilder<?, ?> b) {
            b.seller(instance.seller);
            b.offerId(instance.offerId);
        }

        @Generated
        public B seller(@NonNull String seller) {
            if (seller == null) {
                throw new NullPointerException("seller is marked non-null but is null");
            }
            this.seller = seller;
            return (B)this.self();
        }

        @Generated
        public B offerId(@NonNull Long offerId) {
            if (offerId == null) {
                throw new NullPointerException("offerId is marked non-null but is null");
            }
            this.offerId = offerId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RevokeOfferSponsorshipOperation.RevokeOfferSponsorshipOperationBuilder(super=" + super.toString() + ", seller=" + this.seller + ", offerId=" + this.offerId + ")";
        }
    }

    @Generated
    private static final class RevokeOfferSponsorshipOperationBuilderImpl
    extends RevokeOfferSponsorshipOperationBuilder<RevokeOfferSponsorshipOperation, RevokeOfferSponsorshipOperationBuilderImpl> {
        @Generated
        private RevokeOfferSponsorshipOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected RevokeOfferSponsorshipOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RevokeOfferSponsorshipOperation build() {
            return new RevokeOfferSponsorshipOperation(this);
        }
    }
}

