/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ClaimPredicateType;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimPredicate
implements XdrElement {
    private ClaimPredicateType discriminant;
    private ClaimPredicate[] andPredicates;
    private ClaimPredicate[] orPredicates;
    private ClaimPredicate notPredicate;
    private Int64 absBefore;
    private Int64 relBefore;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                break;
            }
            case CLAIM_PREDICATE_AND: {
                int andPredicatesSize = this.getAndPredicates().length;
                stream.writeInt(andPredicatesSize);
                for (int i = 0; i < andPredicatesSize; ++i) {
                    this.andPredicates[i].encode(stream);
                }
                break;
            }
            case CLAIM_PREDICATE_OR: {
                int orPredicatesSize = this.getOrPredicates().length;
                stream.writeInt(orPredicatesSize);
                for (int i = 0; i < orPredicatesSize; ++i) {
                    this.orPredicates[i].encode(stream);
                }
                break;
            }
            case CLAIM_PREDICATE_NOT: {
                if (this.notPredicate != null) {
                    stream.writeInt(1);
                    this.notPredicate.encode(stream);
                    break;
                }
                stream.writeInt(0);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                this.absBefore.encode(stream);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                this.relBefore.encode(stream);
            }
        }
    }

    public static ClaimPredicate decode(XdrDataInputStream stream) throws IOException {
        ClaimPredicate decodedClaimPredicate = new ClaimPredicate();
        ClaimPredicateType discriminant = ClaimPredicateType.decode(stream);
        decodedClaimPredicate.setDiscriminant(discriminant);
        switch (decodedClaimPredicate.getDiscriminant()) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                break;
            }
            case CLAIM_PREDICATE_AND: {
                int andPredicatesSize = stream.readInt();
                decodedClaimPredicate.andPredicates = new ClaimPredicate[andPredicatesSize];
                for (int i = 0; i < andPredicatesSize; ++i) {
                    decodedClaimPredicate.andPredicates[i] = ClaimPredicate.decode(stream);
                }
                break;
            }
            case CLAIM_PREDICATE_OR: {
                int orPredicatesSize = stream.readInt();
                decodedClaimPredicate.orPredicates = new ClaimPredicate[orPredicatesSize];
                for (int i = 0; i < orPredicatesSize; ++i) {
                    decodedClaimPredicate.orPredicates[i] = ClaimPredicate.decode(stream);
                }
                break;
            }
            case CLAIM_PREDICATE_NOT: {
                int notPredicatePresent = stream.readInt();
                if (notPredicatePresent == 0) break;
                decodedClaimPredicate.notPredicate = ClaimPredicate.decode(stream);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                decodedClaimPredicate.absBefore = Int64.decode(stream);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                decodedClaimPredicate.relBefore = Int64.decode(stream);
            }
        }
        return decodedClaimPredicate;
    }

    public static ClaimPredicate fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimPredicate.fromXdrByteArray(bytes);
    }

    public static ClaimPredicate fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimPredicate.decode(xdrDataInputStream);
    }

    @Generated
    public static ClaimPredicateBuilder builder() {
        return new ClaimPredicateBuilder();
    }

    @Generated
    public ClaimPredicateBuilder toBuilder() {
        return new ClaimPredicateBuilder().discriminant(this.discriminant).andPredicates(this.andPredicates).orPredicates(this.orPredicates).notPredicate(this.notPredicate).absBefore(this.absBefore).relBefore(this.relBefore);
    }

    @Generated
    public ClaimPredicateType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public ClaimPredicate[] getAndPredicates() {
        return this.andPredicates;
    }

    @Generated
    public ClaimPredicate[] getOrPredicates() {
        return this.orPredicates;
    }

    @Generated
    public ClaimPredicate getNotPredicate() {
        return this.notPredicate;
    }

    @Generated
    public Int64 getAbsBefore() {
        return this.absBefore;
    }

    @Generated
    public Int64 getRelBefore() {
        return this.relBefore;
    }

    @Generated
    public void setDiscriminant(ClaimPredicateType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAndPredicates(ClaimPredicate[] andPredicates) {
        this.andPredicates = andPredicates;
    }

    @Generated
    public void setOrPredicates(ClaimPredicate[] orPredicates) {
        this.orPredicates = orPredicates;
    }

    @Generated
    public void setNotPredicate(ClaimPredicate notPredicate) {
        this.notPredicate = notPredicate;
    }

    @Generated
    public void setAbsBefore(Int64 absBefore) {
        this.absBefore = absBefore;
    }

    @Generated
    public void setRelBefore(Int64 relBefore) {
        this.relBefore = relBefore;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimPredicate)) {
            return false;
        }
        ClaimPredicate other = (ClaimPredicate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClaimPredicateType this$discriminant = this.getDiscriminant();
        ClaimPredicateType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAndPredicates(), other.getAndPredicates())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOrPredicates(), other.getOrPredicates())) {
            return false;
        }
        ClaimPredicate this$notPredicate = this.getNotPredicate();
        ClaimPredicate other$notPredicate = other.getNotPredicate();
        if (this$notPredicate == null ? other$notPredicate != null : !((Object)this$notPredicate).equals(other$notPredicate)) {
            return false;
        }
        Int64 this$absBefore = this.getAbsBefore();
        Int64 other$absBefore = other.getAbsBefore();
        if (this$absBefore == null ? other$absBefore != null : !((Object)this$absBefore).equals(other$absBefore)) {
            return false;
        }
        Int64 this$relBefore = this.getRelBefore();
        Int64 other$relBefore = other.getRelBefore();
        return !(this$relBefore == null ? other$relBefore != null : !((Object)this$relBefore).equals(other$relBefore));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimPredicate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClaimPredicateType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAndPredicates());
        result = result * 59 + Arrays.deepHashCode(this.getOrPredicates());
        ClaimPredicate $notPredicate = this.getNotPredicate();
        result = result * 59 + ($notPredicate == null ? 43 : ((Object)$notPredicate).hashCode());
        Int64 $absBefore = this.getAbsBefore();
        result = result * 59 + ($absBefore == null ? 43 : ((Object)$absBefore).hashCode());
        Int64 $relBefore = this.getRelBefore();
        result = result * 59 + ($relBefore == null ? 43 : ((Object)$relBefore).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimPredicate(discriminant=" + this.getDiscriminant() + ", andPredicates=" + Arrays.deepToString(this.getAndPredicates()) + ", orPredicates=" + Arrays.deepToString(this.getOrPredicates()) + ", notPredicate=" + this.getNotPredicate() + ", absBefore=" + this.getAbsBefore() + ", relBefore=" + this.getRelBefore() + ")";
    }

    @Generated
    public ClaimPredicate() {
    }

    @Generated
    public ClaimPredicate(ClaimPredicateType discriminant, ClaimPredicate[] andPredicates, ClaimPredicate[] orPredicates, ClaimPredicate notPredicate, Int64 absBefore, Int64 relBefore) {
        this.discriminant = discriminant;
        this.andPredicates = andPredicates;
        this.orPredicates = orPredicates;
        this.notPredicate = notPredicate;
        this.absBefore = absBefore;
        this.relBefore = relBefore;
    }

    @Generated
    public static class ClaimPredicateBuilder {
        @Generated
        private ClaimPredicateType discriminant;
        @Generated
        private ClaimPredicate[] andPredicates;
        @Generated
        private ClaimPredicate[] orPredicates;
        @Generated
        private ClaimPredicate notPredicate;
        @Generated
        private Int64 absBefore;
        @Generated
        private Int64 relBefore;

        @Generated
        ClaimPredicateBuilder() {
        }

        @Generated
        public ClaimPredicateBuilder discriminant(ClaimPredicateType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ClaimPredicateBuilder andPredicates(ClaimPredicate[] andPredicates) {
            this.andPredicates = andPredicates;
            return this;
        }

        @Generated
        public ClaimPredicateBuilder orPredicates(ClaimPredicate[] orPredicates) {
            this.orPredicates = orPredicates;
            return this;
        }

        @Generated
        public ClaimPredicateBuilder notPredicate(ClaimPredicate notPredicate) {
            this.notPredicate = notPredicate;
            return this;
        }

        @Generated
        public ClaimPredicateBuilder absBefore(Int64 absBefore) {
            this.absBefore = absBefore;
            return this;
        }

        @Generated
        public ClaimPredicateBuilder relBefore(Int64 relBefore) {
            this.relBefore = relBefore;
            return this;
        }

        @Generated
        public ClaimPredicate build() {
            return new ClaimPredicate(this.discriminant, this.andPredicates, this.orPredicates, this.notPredicate, this.absBefore, this.relBefore);
        }

        @Generated
        public String toString() {
            return "ClaimPredicate.ClaimPredicateBuilder(discriminant=" + this.discriminant + ", andPredicates=" + Arrays.deepToString(this.andPredicates) + ", orPredicates=" + Arrays.deepToString(this.orPredicates) + ", notPredicate=" + this.notPredicate + ", absBefore=" + this.absBefore + ", relBefore=" + this.relBefore + ")";
        }
    }
}

