/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum EnvelopeType implements XdrElement
{
    ENVELOPE_TYPE_TX_V0(0),
    ENVELOPE_TYPE_SCP(1),
    ENVELOPE_TYPE_TX(2),
    ENVELOPE_TYPE_AUTH(3),
    ENVELOPE_TYPE_SCPVALUE(4),
    ENVELOPE_TYPE_TX_FEE_BUMP(5),
    ENVELOPE_TYPE_OP_ID(6),
    ENVELOPE_TYPE_POOL_REVOKE_OP_ID(7),
    ENVELOPE_TYPE_CONTRACT_ID(8),
    ENVELOPE_TYPE_SOROBAN_AUTHORIZATION(9);

    private final int value;

    private EnvelopeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EnvelopeType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ENVELOPE_TYPE_TX_V0;
            }
            case 1: {
                return ENVELOPE_TYPE_SCP;
            }
            case 2: {
                return ENVELOPE_TYPE_TX;
            }
            case 3: {
                return ENVELOPE_TYPE_AUTH;
            }
            case 4: {
                return ENVELOPE_TYPE_SCPVALUE;
            }
            case 5: {
                return ENVELOPE_TYPE_TX_FEE_BUMP;
            }
            case 6: {
                return ENVELOPE_TYPE_OP_ID;
            }
            case 7: {
                return ENVELOPE_TYPE_POOL_REVOKE_OP_ID;
            }
            case 8: {
                return ENVELOPE_TYPE_CONTRACT_ID;
            }
            case 9: {
                return ENVELOPE_TYPE_SOROBAN_AUTHORIZATION;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static EnvelopeType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return EnvelopeType.fromXdrByteArray(bytes);
    }

    public static EnvelopeType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return EnvelopeType.decode(xdrDataInputStream);
    }
}

