/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class FeeBumpTransactionEnvelope
implements XdrElement {
    private FeeBumpTransaction tx;
    private DecoratedSignature[] signatures;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.tx.encode(stream);
        int signaturesSize = this.getSignatures().length;
        stream.writeInt(signaturesSize);
        for (int i = 0; i < signaturesSize; ++i) {
            this.signatures[i].encode(stream);
        }
    }

    public static FeeBumpTransactionEnvelope decode(XdrDataInputStream stream) throws IOException {
        FeeBumpTransactionEnvelope decodedFeeBumpTransactionEnvelope = new FeeBumpTransactionEnvelope();
        decodedFeeBumpTransactionEnvelope.tx = FeeBumpTransaction.decode(stream);
        int signaturesSize = stream.readInt();
        decodedFeeBumpTransactionEnvelope.signatures = new DecoratedSignature[signaturesSize];
        for (int i = 0; i < signaturesSize; ++i) {
            decodedFeeBumpTransactionEnvelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedFeeBumpTransactionEnvelope;
    }

    public static FeeBumpTransactionEnvelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return FeeBumpTransactionEnvelope.fromXdrByteArray(bytes);
    }

    public static FeeBumpTransactionEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return FeeBumpTransactionEnvelope.decode(xdrDataInputStream);
    }

    @Generated
    public static FeeBumpTransactionEnvelopeBuilder builder() {
        return new FeeBumpTransactionEnvelopeBuilder();
    }

    @Generated
    public FeeBumpTransactionEnvelopeBuilder toBuilder() {
        return new FeeBumpTransactionEnvelopeBuilder().tx(this.tx).signatures(this.signatures);
    }

    @Generated
    public FeeBumpTransaction getTx() {
        return this.tx;
    }

    @Generated
    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    @Generated
    public void setTx(FeeBumpTransaction tx) {
        this.tx = tx;
    }

    @Generated
    public void setSignatures(DecoratedSignature[] signatures) {
        this.signatures = signatures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeeBumpTransactionEnvelope)) {
            return false;
        }
        FeeBumpTransactionEnvelope other = (FeeBumpTransactionEnvelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FeeBumpTransaction this$tx = this.getTx();
        FeeBumpTransaction other$tx = other.getTx();
        if (this$tx == null ? other$tx != null : !((Object)this$tx).equals(other$tx)) {
            return false;
        }
        return Arrays.deepEquals(this.getSignatures(), other.getSignatures());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeeBumpTransactionEnvelope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FeeBumpTransaction $tx = this.getTx();
        result = result * 59 + ($tx == null ? 43 : ((Object)$tx).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSignatures());
        return result;
    }

    @Generated
    public String toString() {
        return "FeeBumpTransactionEnvelope(tx=" + this.getTx() + ", signatures=" + Arrays.deepToString(this.getSignatures()) + ")";
    }

    @Generated
    public FeeBumpTransactionEnvelope() {
    }

    @Generated
    public FeeBumpTransactionEnvelope(FeeBumpTransaction tx, DecoratedSignature[] signatures) {
        this.tx = tx;
        this.signatures = signatures;
    }

    @Generated
    public static class FeeBumpTransactionEnvelopeBuilder {
        @Generated
        private FeeBumpTransaction tx;
        @Generated
        private DecoratedSignature[] signatures;

        @Generated
        FeeBumpTransactionEnvelopeBuilder() {
        }

        @Generated
        public FeeBumpTransactionEnvelopeBuilder tx(FeeBumpTransaction tx) {
            this.tx = tx;
            return this;
        }

        @Generated
        public FeeBumpTransactionEnvelopeBuilder signatures(DecoratedSignature[] signatures) {
            this.signatures = signatures;
            return this;
        }

        @Generated
        public FeeBumpTransactionEnvelope build() {
            return new FeeBumpTransactionEnvelope(this.tx, this.signatures);
        }

        @Generated
        public String toString() {
            return "FeeBumpTransactionEnvelope.FeeBumpTransactionEnvelopeBuilder(tx=" + this.tx + ", signatures=" + Arrays.deepToString(this.signatures) + ")";
        }
    }
}

