/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.InflationPayout;
import org.stellar.sdk.xdr.InflationResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InflationResult
implements XdrElement {
    private InflationResultCode discriminant;
    private InflationPayout[] payouts;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case INFLATION_SUCCESS: {
                int payoutsSize = this.getPayouts().length;
                stream.writeInt(payoutsSize);
                for (int i = 0; i < payoutsSize; ++i) {
                    this.payouts[i].encode(stream);
                }
                break;
            }
        }
    }

    public static InflationResult decode(XdrDataInputStream stream) throws IOException {
        InflationResult decodedInflationResult = new InflationResult();
        InflationResultCode discriminant = InflationResultCode.decode(stream);
        decodedInflationResult.setDiscriminant(discriminant);
        switch (decodedInflationResult.getDiscriminant()) {
            case INFLATION_SUCCESS: {
                int payoutsSize = stream.readInt();
                decodedInflationResult.payouts = new InflationPayout[payoutsSize];
                for (int i = 0; i < payoutsSize; ++i) {
                    decodedInflationResult.payouts[i] = InflationPayout.decode(stream);
                }
                break;
            }
        }
        return decodedInflationResult;
    }

    public static InflationResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InflationResult.fromXdrByteArray(bytes);
    }

    public static InflationResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InflationResult.decode(xdrDataInputStream);
    }

    @Generated
    public static InflationResultBuilder builder() {
        return new InflationResultBuilder();
    }

    @Generated
    public InflationResultBuilder toBuilder() {
        return new InflationResultBuilder().discriminant(this.discriminant).payouts(this.payouts);
    }

    @Generated
    public InflationResultCode getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public InflationPayout[] getPayouts() {
        return this.payouts;
    }

    @Generated
    public void setDiscriminant(InflationResultCode discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setPayouts(InflationPayout[] payouts) {
        this.payouts = payouts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InflationResult)) {
            return false;
        }
        InflationResult other = (InflationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InflationResultCode this$discriminant = this.getDiscriminant();
        InflationResultCode other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        return Arrays.deepEquals(this.getPayouts(), other.getPayouts());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InflationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InflationResultCode $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPayouts());
        return result;
    }

    @Generated
    public String toString() {
        return "InflationResult(discriminant=" + this.getDiscriminant() + ", payouts=" + Arrays.deepToString(this.getPayouts()) + ")";
    }

    @Generated
    public InflationResult() {
    }

    @Generated
    public InflationResult(InflationResultCode discriminant, InflationPayout[] payouts) {
        this.discriminant = discriminant;
        this.payouts = payouts;
    }

    @Generated
    public static class InflationResultBuilder {
        @Generated
        private InflationResultCode discriminant;
        @Generated
        private InflationPayout[] payouts;

        @Generated
        InflationResultBuilder() {
        }

        @Generated
        public InflationResultBuilder discriminant(InflationResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public InflationResultBuilder payouts(InflationPayout[] payouts) {
            this.payouts = payouts;
            return this;
        }

        @Generated
        public InflationResult build() {
            return new InflationResult(this.discriminant, this.payouts);
        }

        @Generated
        public String toString() {
            return "InflationResult.InflationResultBuilder(discriminant=" + this.discriminant + ", payouts=" + Arrays.deepToString(this.payouts) + ")";
        }
    }
}

