/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerHeaderHistoryEntry;
import org.stellar.sdk.xdr.SCPHistoryEntry;
import org.stellar.sdk.xdr.TransactionResultMeta;
import org.stellar.sdk.xdr.TransactionSet;
import org.stellar.sdk.xdr.UpgradeEntryMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseMetaV0
implements XdrElement {
    private LedgerHeaderHistoryEntry ledgerHeader;
    private TransactionSet txSet;
    private TransactionResultMeta[] txProcessing;
    private UpgradeEntryMeta[] upgradesProcessing;
    private SCPHistoryEntry[] scpInfo;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ledgerHeader.encode(stream);
        this.txSet.encode(stream);
        int txProcessingSize = this.getTxProcessing().length;
        stream.writeInt(txProcessingSize);
        for (int i = 0; i < txProcessingSize; ++i) {
            this.txProcessing[i].encode(stream);
        }
        int upgradesProcessingSize = this.getUpgradesProcessing().length;
        stream.writeInt(upgradesProcessingSize);
        for (int i = 0; i < upgradesProcessingSize; ++i) {
            this.upgradesProcessing[i].encode(stream);
        }
        int scpInfoSize = this.getScpInfo().length;
        stream.writeInt(scpInfoSize);
        for (int i = 0; i < scpInfoSize; ++i) {
            this.scpInfo[i].encode(stream);
        }
    }

    public static LedgerCloseMetaV0 decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMetaV0 decodedLedgerCloseMetaV0 = new LedgerCloseMetaV0();
        decodedLedgerCloseMetaV0.ledgerHeader = LedgerHeaderHistoryEntry.decode(stream);
        decodedLedgerCloseMetaV0.txSet = TransactionSet.decode(stream);
        int txProcessingSize = stream.readInt();
        decodedLedgerCloseMetaV0.txProcessing = new TransactionResultMeta[txProcessingSize];
        for (int i = 0; i < txProcessingSize; ++i) {
            decodedLedgerCloseMetaV0.txProcessing[i] = TransactionResultMeta.decode(stream);
        }
        int upgradesProcessingSize = stream.readInt();
        decodedLedgerCloseMetaV0.upgradesProcessing = new UpgradeEntryMeta[upgradesProcessingSize];
        for (int i = 0; i < upgradesProcessingSize; ++i) {
            decodedLedgerCloseMetaV0.upgradesProcessing[i] = UpgradeEntryMeta.decode(stream);
        }
        int scpInfoSize = stream.readInt();
        decodedLedgerCloseMetaV0.scpInfo = new SCPHistoryEntry[scpInfoSize];
        for (int i = 0; i < scpInfoSize; ++i) {
            decodedLedgerCloseMetaV0.scpInfo[i] = SCPHistoryEntry.decode(stream);
        }
        return decodedLedgerCloseMetaV0;
    }

    public static LedgerCloseMetaV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseMetaV0.fromXdrByteArray(bytes);
    }

    public static LedgerCloseMetaV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseMetaV0.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerCloseMetaV0Builder builder() {
        return new LedgerCloseMetaV0Builder();
    }

    @Generated
    public LedgerCloseMetaV0Builder toBuilder() {
        return new LedgerCloseMetaV0Builder().ledgerHeader(this.ledgerHeader).txSet(this.txSet).txProcessing(this.txProcessing).upgradesProcessing(this.upgradesProcessing).scpInfo(this.scpInfo);
    }

    @Generated
    public LedgerHeaderHistoryEntry getLedgerHeader() {
        return this.ledgerHeader;
    }

    @Generated
    public TransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public TransactionResultMeta[] getTxProcessing() {
        return this.txProcessing;
    }

    @Generated
    public UpgradeEntryMeta[] getUpgradesProcessing() {
        return this.upgradesProcessing;
    }

    @Generated
    public SCPHistoryEntry[] getScpInfo() {
        return this.scpInfo;
    }

    @Generated
    public void setLedgerHeader(LedgerHeaderHistoryEntry ledgerHeader) {
        this.ledgerHeader = ledgerHeader;
    }

    @Generated
    public void setTxSet(TransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setTxProcessing(TransactionResultMeta[] txProcessing) {
        this.txProcessing = txProcessing;
    }

    @Generated
    public void setUpgradesProcessing(UpgradeEntryMeta[] upgradesProcessing) {
        this.upgradesProcessing = upgradesProcessing;
    }

    @Generated
    public void setScpInfo(SCPHistoryEntry[] scpInfo) {
        this.scpInfo = scpInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerCloseMetaV0)) {
            return false;
        }
        LedgerCloseMetaV0 other = (LedgerCloseMetaV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerHeaderHistoryEntry this$ledgerHeader = this.getLedgerHeader();
        LedgerHeaderHistoryEntry other$ledgerHeader = other.getLedgerHeader();
        if (this$ledgerHeader == null ? other$ledgerHeader != null : !((Object)this$ledgerHeader).equals(other$ledgerHeader)) {
            return false;
        }
        TransactionSet this$txSet = this.getTxSet();
        TransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTxProcessing(), other.getTxProcessing())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUpgradesProcessing(), other.getUpgradesProcessing())) {
            return false;
        }
        return Arrays.deepEquals(this.getScpInfo(), other.getScpInfo());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerCloseMetaV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerHeaderHistoryEntry $ledgerHeader = this.getLedgerHeader();
        result = result * 59 + ($ledgerHeader == null ? 43 : ((Object)$ledgerHeader).hashCode());
        TransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTxProcessing());
        result = result * 59 + Arrays.deepHashCode(this.getUpgradesProcessing());
        result = result * 59 + Arrays.deepHashCode(this.getScpInfo());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerCloseMetaV0(ledgerHeader=" + this.getLedgerHeader() + ", txSet=" + this.getTxSet() + ", txProcessing=" + Arrays.deepToString(this.getTxProcessing()) + ", upgradesProcessing=" + Arrays.deepToString(this.getUpgradesProcessing()) + ", scpInfo=" + Arrays.deepToString(this.getScpInfo()) + ")";
    }

    @Generated
    public LedgerCloseMetaV0() {
    }

    @Generated
    public LedgerCloseMetaV0(LedgerHeaderHistoryEntry ledgerHeader, TransactionSet txSet, TransactionResultMeta[] txProcessing, UpgradeEntryMeta[] upgradesProcessing, SCPHistoryEntry[] scpInfo) {
        this.ledgerHeader = ledgerHeader;
        this.txSet = txSet;
        this.txProcessing = txProcessing;
        this.upgradesProcessing = upgradesProcessing;
        this.scpInfo = scpInfo;
    }

    @Generated
    public static class LedgerCloseMetaV0Builder {
        @Generated
        private LedgerHeaderHistoryEntry ledgerHeader;
        @Generated
        private TransactionSet txSet;
        @Generated
        private TransactionResultMeta[] txProcessing;
        @Generated
        private UpgradeEntryMeta[] upgradesProcessing;
        @Generated
        private SCPHistoryEntry[] scpInfo;

        @Generated
        LedgerCloseMetaV0Builder() {
        }

        @Generated
        public LedgerCloseMetaV0Builder ledgerHeader(LedgerHeaderHistoryEntry ledgerHeader) {
            this.ledgerHeader = ledgerHeader;
            return this;
        }

        @Generated
        public LedgerCloseMetaV0Builder txSet(TransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public LedgerCloseMetaV0Builder txProcessing(TransactionResultMeta[] txProcessing) {
            this.txProcessing = txProcessing;
            return this;
        }

        @Generated
        public LedgerCloseMetaV0Builder upgradesProcessing(UpgradeEntryMeta[] upgradesProcessing) {
            this.upgradesProcessing = upgradesProcessing;
            return this;
        }

        @Generated
        public LedgerCloseMetaV0Builder scpInfo(SCPHistoryEntry[] scpInfo) {
            this.scpInfo = scpInfo;
            return this;
        }

        @Generated
        public LedgerCloseMetaV0 build() {
            return new LedgerCloseMetaV0(this.ledgerHeader, this.txSet, this.txProcessing, this.upgradesProcessing, this.scpInfo);
        }

        @Generated
        public String toString() {
            return "LedgerCloseMetaV0.LedgerCloseMetaV0Builder(ledgerHeader=" + this.ledgerHeader + ", txSet=" + this.txSet + ", txProcessing=" + Arrays.deepToString(this.txProcessing) + ", upgradesProcessing=" + Arrays.deepToString(this.upgradesProcessing) + ", scpInfo=" + Arrays.deepToString(this.scpInfo) + ")";
        }
    }
}

