/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PreconditionType;
import org.stellar.sdk.xdr.PreconditionsV2;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Preconditions
implements XdrElement {
    private PreconditionType discriminant;
    private TimeBounds timeBounds;
    private PreconditionsV2 v2;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case PRECOND_NONE: {
                break;
            }
            case PRECOND_TIME: {
                this.timeBounds.encode(stream);
                break;
            }
            case PRECOND_V2: {
                this.v2.encode(stream);
            }
        }
    }

    public static Preconditions decode(XdrDataInputStream stream) throws IOException {
        Preconditions decodedPreconditions = new Preconditions();
        PreconditionType discriminant = PreconditionType.decode(stream);
        decodedPreconditions.setDiscriminant(discriminant);
        switch (decodedPreconditions.getDiscriminant()) {
            case PRECOND_NONE: {
                break;
            }
            case PRECOND_TIME: {
                decodedPreconditions.timeBounds = TimeBounds.decode(stream);
                break;
            }
            case PRECOND_V2: {
                decodedPreconditions.v2 = PreconditionsV2.decode(stream);
            }
        }
        return decodedPreconditions;
    }

    public static Preconditions fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Preconditions.fromXdrByteArray(bytes);
    }

    public static Preconditions fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Preconditions.decode(xdrDataInputStream);
    }

    @Generated
    public static PreconditionsBuilder builder() {
        return new PreconditionsBuilder();
    }

    @Generated
    public PreconditionsBuilder toBuilder() {
        return new PreconditionsBuilder().discriminant(this.discriminant).timeBounds(this.timeBounds).v2(this.v2);
    }

    @Generated
    public PreconditionType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    @Generated
    public PreconditionsV2 getV2() {
        return this.v2;
    }

    @Generated
    public void setDiscriminant(PreconditionType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setTimeBounds(TimeBounds timeBounds) {
        this.timeBounds = timeBounds;
    }

    @Generated
    public void setV2(PreconditionsV2 v2) {
        this.v2 = v2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Preconditions)) {
            return false;
        }
        Preconditions other = (Preconditions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PreconditionType this$discriminant = this.getDiscriminant();
        PreconditionType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        TimeBounds this$timeBounds = this.getTimeBounds();
        TimeBounds other$timeBounds = other.getTimeBounds();
        if (this$timeBounds == null ? other$timeBounds != null : !((Object)this$timeBounds).equals(other$timeBounds)) {
            return false;
        }
        PreconditionsV2 this$v2 = this.getV2();
        PreconditionsV2 other$v2 = other.getV2();
        return !(this$v2 == null ? other$v2 != null : !((Object)this$v2).equals(other$v2));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Preconditions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PreconditionType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        TimeBounds $timeBounds = this.getTimeBounds();
        result = result * 59 + ($timeBounds == null ? 43 : ((Object)$timeBounds).hashCode());
        PreconditionsV2 $v2 = this.getV2();
        result = result * 59 + ($v2 == null ? 43 : ((Object)$v2).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Preconditions(discriminant=" + this.getDiscriminant() + ", timeBounds=" + this.getTimeBounds() + ", v2=" + this.getV2() + ")";
    }

    @Generated
    public Preconditions() {
    }

    @Generated
    public Preconditions(PreconditionType discriminant, TimeBounds timeBounds, PreconditionsV2 v2) {
        this.discriminant = discriminant;
        this.timeBounds = timeBounds;
        this.v2 = v2;
    }

    @Generated
    public static class PreconditionsBuilder {
        @Generated
        private PreconditionType discriminant;
        @Generated
        private TimeBounds timeBounds;
        @Generated
        private PreconditionsV2 v2;

        @Generated
        PreconditionsBuilder() {
        }

        @Generated
        public PreconditionsBuilder discriminant(PreconditionType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public PreconditionsBuilder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        @Generated
        public PreconditionsBuilder v2(PreconditionsV2 v2) {
            this.v2 = v2;
            return this;
        }

        @Generated
        public Preconditions build() {
            return new Preconditions(this.discriminant, this.timeBounds, this.v2);
        }

        @Generated
        public String toString() {
            return "Preconditions.PreconditionsBuilder(discriminant=" + this.discriminant + ", timeBounds=" + this.timeBounds + ", v2=" + this.v2 + ")";
        }
    }
}

