/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.DiagnosticEvent;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanTransactionMetaExt;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanTransactionMeta
implements XdrElement {
    private SorobanTransactionMetaExt ext;
    private ContractEvent[] events;
    private SCVal returnValue;
    private DiagnosticEvent[] diagnosticEvents;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        int eventsSize = this.getEvents().length;
        stream.writeInt(eventsSize);
        for (int i = 0; i < eventsSize; ++i) {
            this.events[i].encode(stream);
        }
        this.returnValue.encode(stream);
        int diagnosticEventsSize = this.getDiagnosticEvents().length;
        stream.writeInt(diagnosticEventsSize);
        for (int i = 0; i < diagnosticEventsSize; ++i) {
            this.diagnosticEvents[i].encode(stream);
        }
    }

    public static SorobanTransactionMeta decode(XdrDataInputStream stream) throws IOException {
        SorobanTransactionMeta decodedSorobanTransactionMeta = new SorobanTransactionMeta();
        decodedSorobanTransactionMeta.ext = SorobanTransactionMetaExt.decode(stream);
        int eventsSize = stream.readInt();
        decodedSorobanTransactionMeta.events = new ContractEvent[eventsSize];
        for (int i = 0; i < eventsSize; ++i) {
            decodedSorobanTransactionMeta.events[i] = ContractEvent.decode(stream);
        }
        decodedSorobanTransactionMeta.returnValue = SCVal.decode(stream);
        int diagnosticEventsSize = stream.readInt();
        decodedSorobanTransactionMeta.diagnosticEvents = new DiagnosticEvent[diagnosticEventsSize];
        for (int i = 0; i < diagnosticEventsSize; ++i) {
            decodedSorobanTransactionMeta.diagnosticEvents[i] = DiagnosticEvent.decode(stream);
        }
        return decodedSorobanTransactionMeta;
    }

    public static SorobanTransactionMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanTransactionMeta.fromXdrByteArray(bytes);
    }

    public static SorobanTransactionMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanTransactionMeta.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanTransactionMetaBuilder builder() {
        return new SorobanTransactionMetaBuilder();
    }

    @Generated
    public SorobanTransactionMetaBuilder toBuilder() {
        return new SorobanTransactionMetaBuilder().ext(this.ext).events(this.events).returnValue(this.returnValue).diagnosticEvents(this.diagnosticEvents);
    }

    @Generated
    public SorobanTransactionMetaExt getExt() {
        return this.ext;
    }

    @Generated
    public ContractEvent[] getEvents() {
        return this.events;
    }

    @Generated
    public SCVal getReturnValue() {
        return this.returnValue;
    }

    @Generated
    public DiagnosticEvent[] getDiagnosticEvents() {
        return this.diagnosticEvents;
    }

    @Generated
    public void setExt(SorobanTransactionMetaExt ext) {
        this.ext = ext;
    }

    @Generated
    public void setEvents(ContractEvent[] events) {
        this.events = events;
    }

    @Generated
    public void setReturnValue(SCVal returnValue) {
        this.returnValue = returnValue;
    }

    @Generated
    public void setDiagnosticEvents(DiagnosticEvent[] diagnosticEvents) {
        this.diagnosticEvents = diagnosticEvents;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanTransactionMeta)) {
            return false;
        }
        SorobanTransactionMeta other = (SorobanTransactionMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SorobanTransactionMetaExt this$ext = this.getExt();
        SorobanTransactionMetaExt other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEvents(), other.getEvents())) {
            return false;
        }
        SCVal this$returnValue = this.getReturnValue();
        SCVal other$returnValue = other.getReturnValue();
        if (this$returnValue == null ? other$returnValue != null : !((Object)this$returnValue).equals(other$returnValue)) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticEvents(), other.getDiagnosticEvents());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanTransactionMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SorobanTransactionMetaExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEvents());
        SCVal $returnValue = this.getReturnValue();
        result = result * 59 + ($returnValue == null ? 43 : ((Object)$returnValue).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticEvents());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanTransactionMeta(ext=" + this.getExt() + ", events=" + Arrays.deepToString(this.getEvents()) + ", returnValue=" + this.getReturnValue() + ", diagnosticEvents=" + Arrays.deepToString(this.getDiagnosticEvents()) + ")";
    }

    @Generated
    public SorobanTransactionMeta() {
    }

    @Generated
    public SorobanTransactionMeta(SorobanTransactionMetaExt ext, ContractEvent[] events, SCVal returnValue, DiagnosticEvent[] diagnosticEvents) {
        this.ext = ext;
        this.events = events;
        this.returnValue = returnValue;
        this.diagnosticEvents = diagnosticEvents;
    }

    @Generated
    public static class SorobanTransactionMetaBuilder {
        @Generated
        private SorobanTransactionMetaExt ext;
        @Generated
        private ContractEvent[] events;
        @Generated
        private SCVal returnValue;
        @Generated
        private DiagnosticEvent[] diagnosticEvents;

        @Generated
        SorobanTransactionMetaBuilder() {
        }

        @Generated
        public SorobanTransactionMetaBuilder ext(SorobanTransactionMetaExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public SorobanTransactionMetaBuilder events(ContractEvent[] events) {
            this.events = events;
            return this;
        }

        @Generated
        public SorobanTransactionMetaBuilder returnValue(SCVal returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        @Generated
        public SorobanTransactionMetaBuilder diagnosticEvents(DiagnosticEvent[] diagnosticEvents) {
            this.diagnosticEvents = diagnosticEvents;
            return this;
        }

        @Generated
        public SorobanTransactionMeta build() {
            return new SorobanTransactionMeta(this.ext, this.events, this.returnValue, this.diagnosticEvents);
        }

        @Generated
        public String toString() {
            return "SorobanTransactionMeta.SorobanTransactionMetaBuilder(ext=" + this.ext + ", events=" + Arrays.deepToString(this.events) + ", returnValue=" + this.returnValue + ", diagnosticEvents=" + Arrays.deepToString(this.diagnosticEvents) + ")";
        }
    }
}

