/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TimeSlicedNodeData;
import org.stellar.sdk.xdr.TimeSlicedPeerDataList;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TopologyResponseBodyV2
implements XdrElement {
    private TimeSlicedPeerDataList inboundPeers;
    private TimeSlicedPeerDataList outboundPeers;
    private TimeSlicedNodeData nodeData;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.inboundPeers.encode(stream);
        this.outboundPeers.encode(stream);
        this.nodeData.encode(stream);
    }

    public static TopologyResponseBodyV2 decode(XdrDataInputStream stream) throws IOException {
        TopologyResponseBodyV2 decodedTopologyResponseBodyV2 = new TopologyResponseBodyV2();
        decodedTopologyResponseBodyV2.inboundPeers = TimeSlicedPeerDataList.decode(stream);
        decodedTopologyResponseBodyV2.outboundPeers = TimeSlicedPeerDataList.decode(stream);
        decodedTopologyResponseBodyV2.nodeData = TimeSlicedNodeData.decode(stream);
        return decodedTopologyResponseBodyV2;
    }

    public static TopologyResponseBodyV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TopologyResponseBodyV2.fromXdrByteArray(bytes);
    }

    public static TopologyResponseBodyV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TopologyResponseBodyV2.decode(xdrDataInputStream);
    }

    @Generated
    public static TopologyResponseBodyV2Builder builder() {
        return new TopologyResponseBodyV2Builder();
    }

    @Generated
    public TopologyResponseBodyV2Builder toBuilder() {
        return new TopologyResponseBodyV2Builder().inboundPeers(this.inboundPeers).outboundPeers(this.outboundPeers).nodeData(this.nodeData);
    }

    @Generated
    public TimeSlicedPeerDataList getInboundPeers() {
        return this.inboundPeers;
    }

    @Generated
    public TimeSlicedPeerDataList getOutboundPeers() {
        return this.outboundPeers;
    }

    @Generated
    public TimeSlicedNodeData getNodeData() {
        return this.nodeData;
    }

    @Generated
    public void setInboundPeers(TimeSlicedPeerDataList inboundPeers) {
        this.inboundPeers = inboundPeers;
    }

    @Generated
    public void setOutboundPeers(TimeSlicedPeerDataList outboundPeers) {
        this.outboundPeers = outboundPeers;
    }

    @Generated
    public void setNodeData(TimeSlicedNodeData nodeData) {
        this.nodeData = nodeData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopologyResponseBodyV2)) {
            return false;
        }
        TopologyResponseBodyV2 other = (TopologyResponseBodyV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimeSlicedPeerDataList this$inboundPeers = this.getInboundPeers();
        TimeSlicedPeerDataList other$inboundPeers = other.getInboundPeers();
        if (this$inboundPeers == null ? other$inboundPeers != null : !((Object)this$inboundPeers).equals(other$inboundPeers)) {
            return false;
        }
        TimeSlicedPeerDataList this$outboundPeers = this.getOutboundPeers();
        TimeSlicedPeerDataList other$outboundPeers = other.getOutboundPeers();
        if (this$outboundPeers == null ? other$outboundPeers != null : !((Object)this$outboundPeers).equals(other$outboundPeers)) {
            return false;
        }
        TimeSlicedNodeData this$nodeData = this.getNodeData();
        TimeSlicedNodeData other$nodeData = other.getNodeData();
        return !(this$nodeData == null ? other$nodeData != null : !((Object)this$nodeData).equals(other$nodeData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopologyResponseBodyV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimeSlicedPeerDataList $inboundPeers = this.getInboundPeers();
        result = result * 59 + ($inboundPeers == null ? 43 : ((Object)$inboundPeers).hashCode());
        TimeSlicedPeerDataList $outboundPeers = this.getOutboundPeers();
        result = result * 59 + ($outboundPeers == null ? 43 : ((Object)$outboundPeers).hashCode());
        TimeSlicedNodeData $nodeData = this.getNodeData();
        result = result * 59 + ($nodeData == null ? 43 : ((Object)$nodeData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopologyResponseBodyV2(inboundPeers=" + this.getInboundPeers() + ", outboundPeers=" + this.getOutboundPeers() + ", nodeData=" + this.getNodeData() + ")";
    }

    @Generated
    public TopologyResponseBodyV2() {
    }

    @Generated
    public TopologyResponseBodyV2(TimeSlicedPeerDataList inboundPeers, TimeSlicedPeerDataList outboundPeers, TimeSlicedNodeData nodeData) {
        this.inboundPeers = inboundPeers;
        this.outboundPeers = outboundPeers;
        this.nodeData = nodeData;
    }

    @Generated
    public static class TopologyResponseBodyV2Builder {
        @Generated
        private TimeSlicedPeerDataList inboundPeers;
        @Generated
        private TimeSlicedPeerDataList outboundPeers;
        @Generated
        private TimeSlicedNodeData nodeData;

        @Generated
        TopologyResponseBodyV2Builder() {
        }

        @Generated
        public TopologyResponseBodyV2Builder inboundPeers(TimeSlicedPeerDataList inboundPeers) {
            this.inboundPeers = inboundPeers;
            return this;
        }

        @Generated
        public TopologyResponseBodyV2Builder outboundPeers(TimeSlicedPeerDataList outboundPeers) {
            this.outboundPeers = outboundPeers;
            return this;
        }

        @Generated
        public TopologyResponseBodyV2Builder nodeData(TimeSlicedNodeData nodeData) {
            this.nodeData = nodeData;
            return this;
        }

        @Generated
        public TopologyResponseBodyV2 build() {
            return new TopologyResponseBodyV2(this.inboundPeers, this.outboundPeers, this.nodeData);
        }

        @Generated
        public String toString() {
            return "TopologyResponseBodyV2.TopologyResponseBodyV2Builder(inboundPeers=" + this.inboundPeers + ", outboundPeers=" + this.outboundPeers + ", nodeData=" + this.nodeData + ")";
        }
    }
}

