/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class MuxedAccount {
    @NonNull
    private final String accountId;
    @Nullable
    private final BigInteger muxedId;

    public MuxedAccount(@NonNull String accountId, @Nullable BigInteger muxedId) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (!StrKey.isValidEd25519PublicKey(accountId)) {
            throw new IllegalArgumentException("accountId is invalid");
        }
        this.accountId = accountId;
        this.muxedId = muxedId;
    }

    public MuxedAccount(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (StrKey.isValidEd25519PublicKey(address)) {
            this.accountId = address;
            this.muxedId = null;
        } else if (StrKey.isValidMed25519PublicKey(address)) {
            byte[] rawMed25519 = StrKey.decodeMed25519PublicKey(address);
            byte[] ed25519PublicKey = new byte[32];
            System.arraycopy(rawMed25519, 0, ed25519PublicKey, 0, 32);
            byte[] muxedIdBytes = new byte[8];
            System.arraycopy(rawMed25519, 32, muxedIdBytes, 0, 8);
            this.accountId = StrKey.encodeEd25519PublicKey(ed25519PublicKey);
            this.muxedId = new BigInteger(1, muxedIdBytes);
        } else {
            throw new IllegalArgumentException("Invalid address");
        }
    }

    public String getAddress() {
        if (this.muxedId == null) {
            return this.accountId;
        }
        return StrKey.encodeMed25519PublicKey(MuxedAccount.getMuxedEd25519AccountBytes(this.toXdr().getMed25519()));
    }

    public static MuxedAccount fromXdr(org.stellar.sdk.xdr.MuxedAccount xdr) {
        switch (xdr.getDiscriminant()) {
            case KEY_TYPE_ED25519: {
                return new MuxedAccount(StrKey.encodeEd25519PublicKey(xdr.getEd25519().getUint256()), null);
            }
            case KEY_TYPE_MUXED_ED25519: {
                return new MuxedAccount(StrKey.encodeEd25519PublicKey(xdr.getMed25519().getEd25519().getUint256()), xdr.getMed25519().getId().getUint64().getNumber());
            }
        }
        throw new IllegalArgumentException("Invalid address");
    }

    public org.stellar.sdk.xdr.MuxedAccount toXdr() {
        if (this.muxedId == null) {
            return new org.stellar.sdk.xdr.MuxedAccount(CryptoKeyType.KEY_TYPE_ED25519, new Uint256(StrKey.decodeEd25519PublicKey(this.accountId)), null);
        }
        return new org.stellar.sdk.xdr.MuxedAccount(CryptoKeyType.KEY_TYPE_MUXED_ED25519, null, new MuxedAccount.MuxedAccountMed25519(new Uint64(new XdrUnsignedHyperInteger(this.muxedId)), new Uint256(StrKey.decodeEd25519PublicKey(this.accountId))));
    }

    private static byte[] getMuxedEd25519AccountBytes(MuxedAccount.MuxedAccountMed25519 muxedAccountMed25519) {
        byte[] accountBytes = muxedAccountMed25519.getEd25519().getUint256();
        byte[] idBytes = muxedAccountMed25519.getId().getUint64().getNumber().toByteArray();
        byte[] idPaddedBytes = new byte[8];
        int idNumBytesToCopy = Math.min(idBytes.length, 8);
        int idCopyStartIndex = idBytes.length - idNumBytesToCopy;
        System.arraycopy(idBytes, idCopyStartIndex, idPaddedBytes, 8 - idNumBytesToCopy, idNumBytesToCopy);
        byte[] result = new byte[accountBytes.length + idPaddedBytes.length];
        System.arraycopy(accountBytes, 0, result, 0, accountBytes.length);
        System.arraycopy(idPaddedBytes, 0, result, accountBytes.length, idPaddedBytes.length);
        return result;
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    @Generated
    public BigInteger getMuxedId() {
        return this.muxedId;
    }

    @Generated
    public String toString() {
        return "MuxedAccount(accountId=" + this.getAccountId() + ", muxedId=" + this.getMuxedId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MuxedAccount)) {
            return false;
        }
        MuxedAccount other = (MuxedAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        BigInteger this$muxedId = this.getMuxedId();
        BigInteger other$muxedId = other.getMuxedId();
        return !(this$muxedId == null ? other$muxedId != null : !((Object)this$muxedId).equals(other$muxedId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MuxedAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        BigInteger $muxedId = this.getMuxedId();
        result = result * 59 + ($muxedId == null ? 43 : ((Object)$muxedId).hashCode());
        return result;
    }
}

