/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.Account;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Memo;
import org.stellar.sdk.MemoId;
import org.stellar.sdk.MemoNone;
import org.stellar.sdk.Network;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilder;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.exception.InvalidSep10ChallengeException;
import org.stellar.sdk.operations.ManageDataOperation;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;

public class Sep10Challenge {
    static final BigInteger GRACE_PERIOD_SECONDS = BigInteger.valueOf(300L);
    static final String CLIENT_DOMAIN_DATA_NAME = "client_domain";
    private static final String HOME_DOMAIN_MANAGER_DATA_NAME_FLAG = "auth";
    private static final String WEB_AUTH_DOMAIN_MANAGER_DATA_NAME = "web_auth_domain";

    private Sep10Challenge() {
    }

    public static Transaction newChallenge(KeyPair signer, Network network, String clientAccountId, String domainName, String webAuthDomain, TimeBounds timebounds) {
        return Sep10Challenge.newChallenge(signer, network, clientAccountId, domainName, webAuthDomain, timebounds, "", "");
    }

    public static Transaction newChallenge(KeyPair signer, Network network, String clientAccountId, String domainName, String webAuthDomain, TimeBounds timebounds, String clientDomain, String clientSigningKey, Memo memo) {
        byte[] nonce = new byte[48];
        SecureRandom random = new SecureRandom();
        random.nextBytes(nonce);
        byte[] encodedNonce = Base64Factory.getInstance().encode(nonce);
        if (clientDomain.isEmpty() != clientSigningKey.isEmpty()) {
            throw new InvalidSep10ChallengeException("clientDomain is required if clientSigningKey is provided");
        }
        if (StrKey.decodeVersionByte(clientAccountId) != StrKey.VersionByte.ACCOUNT_ID) {
            throw new InvalidSep10ChallengeException(clientAccountId + " is not a valid account id");
        }
        Account sourceAccount = new Account(signer.getAccountId(), -1L);
        Operation domainNameOperation = ((ManageDataOperation.ManageDataOperationBuilder)((Operation.OperationBuilder)((ManageDataOperation.ManageDataOperationBuilder)ManageDataOperation.builder().name(String.format("%s %s", domainName, HOME_DOMAIN_MANAGER_DATA_NAME_FLAG))).value(encodedNonce)).sourceAccount(clientAccountId)).build();
        Operation webAuthDomainOperation = ((ManageDataOperation.ManageDataOperationBuilder)((Operation.OperationBuilder)((ManageDataOperation.ManageDataOperationBuilder)ManageDataOperation.builder().name(WEB_AUTH_DOMAIN_MANAGER_DATA_NAME)).value(webAuthDomain.getBytes())).sourceAccount(sourceAccount.getAccountId())).build();
        TransactionBuilder builder = new TransactionBuilder(sourceAccount, network).addPreconditions(TransactionPreconditions.builder().timeBounds(timebounds).build()).setBaseFee(100L).addOperation(domainNameOperation).addOperation(webAuthDomainOperation);
        if (memo != null) {
            if (!(memo instanceof MemoId)) {
                throw new InvalidSep10ChallengeException("only memo type `id` is supported");
            }
            builder.addMemo(memo);
        }
        if (!clientSigningKey.isEmpty()) {
            if (StrKey.decodeVersionByte(clientSigningKey) != StrKey.VersionByte.ACCOUNT_ID) {
                throw new InvalidSep10ChallengeException(clientSigningKey + " is not a valid account id");
            }
            builder.addOperation(((ManageDataOperation.ManageDataOperationBuilder)((Operation.OperationBuilder)((ManageDataOperation.ManageDataOperationBuilder)ManageDataOperation.builder().name(CLIENT_DOMAIN_DATA_NAME)).value(clientDomain.getBytes())).sourceAccount(clientSigningKey)).build());
        }
        Transaction transaction = builder.build();
        transaction.sign(signer);
        return transaction;
    }

    public static Transaction newChallenge(KeyPair signer, Network network, String clientAccountId, String domainName, String webAuthDomain, TimeBounds timebounds, String clientDomain, String clientSigningKey) {
        return Sep10Challenge.newChallenge(signer, network, clientAccountId, domainName, webAuthDomain, timebounds, clientDomain, clientSigningKey, null);
    }

    public static ChallengeTransaction readChallengeTransaction(String challengeXdr, String serverAccountId, Network network, String[] domainNames, String webAuthDomain) {
        byte[] nonce;
        if (domainNames == null || domainNames.length == 0) {
            throw new IllegalArgumentException("At least one domain name must be included in domainNames.");
        }
        AbstractTransaction parsed = Transaction.fromEnvelopeXdr(challengeXdr, network);
        if (!(parsed instanceof Transaction)) {
            throw new InvalidSep10ChallengeException("Transaction cannot be a fee bump transaction");
        }
        Transaction transaction = (Transaction)parsed;
        if (StrKey.decodeVersionByte(serverAccountId) != StrKey.VersionByte.ACCOUNT_ID) {
            throw new InvalidSep10ChallengeException("serverAccountId: " + serverAccountId + " is not a valid account id");
        }
        if (!serverAccountId.equals(transaction.getSourceAccount())) {
            throw new InvalidSep10ChallengeException("Transaction source account is not equal to server's account.");
        }
        if (transaction.getSequenceNumber() != 0L) {
            throw new InvalidSep10ChallengeException("The transaction sequence number should be zero.");
        }
        Memo memo = transaction.getMemo();
        if (!(memo instanceof MemoNone) && !(memo instanceof MemoId)) {
            throw new InvalidSep10ChallengeException("only memo type `id` is supported");
        }
        BigInteger maxTime = transaction.getTimeBounds().getMaxTime();
        BigInteger minTime = transaction.getTimeBounds().getMinTime();
        if (maxTime.equals(BigInteger.ZERO)) {
            throw new InvalidSep10ChallengeException("Transaction requires non-infinite timebounds.");
        }
        BigInteger currentTime = BigInteger.valueOf(System.currentTimeMillis() / 1000L);
        if (currentTime.add(GRACE_PERIOD_SECONDS).compareTo(minTime) < 0 || currentTime.compareTo(maxTime) > 0) {
            throw new InvalidSep10ChallengeException("Transaction is not within range of the specified timebounds.");
        }
        if (transaction.getOperations().length < 1) {
            throw new InvalidSep10ChallengeException("Transaction requires at least one ManageData operation.");
        }
        Operation operation = transaction.getOperations()[0];
        if (!(operation instanceof ManageDataOperation)) {
            throw new InvalidSep10ChallengeException("Operation type should be ManageData.");
        }
        ManageDataOperation manageDataOperation = (ManageDataOperation)operation;
        String clientAccountId = manageDataOperation.getSourceAccount();
        if (clientAccountId == null) {
            throw new InvalidSep10ChallengeException("Operation should have a source account.");
        }
        String matchedDomainName = null;
        for (String homeDomain : domainNames) {
            if (!(homeDomain + " " + HOME_DOMAIN_MANAGER_DATA_NAME_FLAG).equals(manageDataOperation.getName())) continue;
            matchedDomainName = homeDomain;
            break;
        }
        if (matchedDomainName == null) {
            throw new InvalidSep10ChallengeException("The transaction's operation key name does not include one of the expected home domains.");
        }
        if (StrKey.decodeVersionByte(clientAccountId) != StrKey.VersionByte.ACCOUNT_ID) {
            throw new InvalidSep10ChallengeException("clientAccountId: " + clientAccountId + " is not a valid account id");
        }
        if (manageDataOperation.getValue() == null) {
            throw new InvalidSep10ChallengeException("The transaction's operation value should not be null.");
        }
        if (manageDataOperation.getValue().length != 64) {
            throw new InvalidSep10ChallengeException("Random nonce encoded as base64 should be 64 bytes long.");
        }
        try {
            nonce = Base64Factory.getInstance().decode(new String(manageDataOperation.getValue()));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSep10ChallengeException("Failed to decode random nonce provided in ManageData operation.", e);
        }
        if (nonce.length != 48) {
            throw new InvalidSep10ChallengeException("Random nonce before encoding as base64 should be 48 bytes long.");
        }
        for (int i = 1; i < transaction.getOperations().length; ++i) {
            Operation op = transaction.getOperations()[i];
            if (!(op instanceof ManageDataOperation)) {
                throw new InvalidSep10ChallengeException("Operation type should be ManageData.");
            }
            ManageDataOperation manageDataOp = (ManageDataOperation)op;
            if (manageDataOp.getSourceAccount() == null) {
                throw new InvalidSep10ChallengeException("Operation should have a source account.");
            }
            if (!manageDataOp.getName().equals(CLIENT_DOMAIN_DATA_NAME) && !manageDataOp.getSourceAccount().equals(serverAccountId)) {
                throw new InvalidSep10ChallengeException("Subsequent operations are unrecognized.");
            }
            if (!WEB_AUTH_DOMAIN_MANAGER_DATA_NAME.equals(manageDataOp.getName())) continue;
            if (manageDataOp.getValue() == null) {
                throw new InvalidSep10ChallengeException("'web_auth_domain' operation value should not be null.");
            }
            if (Arrays.equals(webAuthDomain.getBytes(), manageDataOp.getValue())) continue;
            throw new InvalidSep10ChallengeException(String.format("'web_auth_domain' operation value does not match %s.", webAuthDomain));
        }
        if (!Sep10Challenge.verifyTransactionSignature(transaction, serverAccountId)) {
            throw new InvalidSep10ChallengeException(String.format("Transaction not signed by server: %s.", serverAccountId));
        }
        return new ChallengeTransaction(transaction, clientAccountId, matchedDomainName);
    }

    public static ChallengeTransaction readChallengeTransaction(String challengeXdr, String serverAccountId, Network network, String domainName, String webAuthDomain) {
        return Sep10Challenge.readChallengeTransaction(challengeXdr, serverAccountId, network, new String[]{domainName}, webAuthDomain);
    }

    public static Set<String> verifyChallengeTransactionSigners(String challengeXdr, String serverAccountId, Network network, String domainName, String webAuthDomain, Set<String> signers) {
        return Sep10Challenge.verifyChallengeTransactionSigners(challengeXdr, serverAccountId, network, new String[]{domainName}, webAuthDomain, signers);
    }

    public static Set<String> verifyChallengeTransactionSigners(String challengeXdr, String serverAccountId, Network network, String[] domainNames, String webAuthDomain, Set<String> signers) {
        Set<String> signersFound;
        boolean serverSignerFound;
        if (signers == null || signers.isEmpty()) {
            throw new InvalidSep10ChallengeException("No verifiable signers provided, at least one G... address must be provided.");
        }
        ChallengeTransaction parsedChallengeTransaction = Sep10Challenge.readChallengeTransaction(challengeXdr, serverAccountId, network, domainNames, webAuthDomain);
        Transaction transaction = parsedChallengeTransaction.getTransaction();
        KeyPair serverKeyPair = KeyPair.fromAccountId(serverAccountId);
        HashSet<String> clientSigners = new HashSet<String>();
        for (String signer : signers) {
            Operation[] versionByte;
            try {
                versionByte = StrKey.decodeVersionByte(signer);
            }
            catch (Exception e) {
                continue;
            }
            if (!StrKey.VersionByte.ACCOUNT_ID.equals(versionByte) || serverKeyPair.getAccountId().equals(signer)) continue;
            clientSigners.add(signer);
        }
        if (clientSigners.isEmpty()) {
            throw new InvalidSep10ChallengeException("No verifiable signers provided, at least one G... address must be provided.");
        }
        HashSet<String> allSigners = new HashSet<String>(clientSigners);
        allSigners.add(serverKeyPair.getAccountId());
        Optional<Object> clientDomainSigner = Optional.empty();
        for (Operation op : transaction.getOperations()) {
            if (!(op instanceof ManageDataOperation)) {
                throw new InvalidSep10ChallengeException("Operation type should be ManageData.");
            }
            ManageDataOperation manageDataOp = (ManageDataOperation)op;
            if (manageDataOp.getSourceAccount() == null) {
                throw new InvalidSep10ChallengeException("Operation should have a source account.");
            }
            if (!manageDataOp.getName().equals(CLIENT_DOMAIN_DATA_NAME)) continue;
            allSigners.add(manageDataOp.getSourceAccount());
            clientDomainSigner = Optional.of(manageDataOp.getSourceAccount());
            break;
        }
        if (!(serverSignerFound = (signersFound = Sep10Challenge.verifyTransactionSignatures(transaction, allSigners)).remove(serverKeyPair.getAccountId()))) {
            throw new InvalidSep10ChallengeException(String.format("Transaction not signed by server: %s.", serverAccountId));
        }
        if (signersFound.isEmpty()) {
            throw new InvalidSep10ChallengeException("Transaction not signed by any client signer.");
        }
        int expectedSignaturesLength = transaction.getSignatures().size() - 1;
        if (clientDomainSigner.isPresent()) {
            boolean clientSignerFound = signersFound.remove(clientDomainSigner.get());
            if (!clientSignerFound) {
                throw new InvalidSep10ChallengeException(String.format("Transaction not signed by by the source account of the 'client_domain' ManageDataOperation: %s.", clientDomainSigner.get()));
            }
            --expectedSignaturesLength;
        }
        if (signersFound.size() != expectedSignaturesLength) {
            throw new InvalidSep10ChallengeException("Transaction has unrecognized signatures.");
        }
        return signersFound;
    }

    public static Set<String> verifyChallengeTransactionThreshold(String challengeXdr, String serverAccountId, Network network, String[] domainNames, String webAuthDomain, int threshold, Set<Signer> signers) {
        if (signers == null || signers.isEmpty()) {
            throw new InvalidSep10ChallengeException("No verifiable signers provided, at least one G... address must be provided.");
        }
        HashMap<String, Integer> weightsForSigner = new HashMap<String, Integer>();
        for (Signer signer : signers) {
            weightsForSigner.put(signer.getKey(), signer.getWeight());
        }
        Set<String> signersFound = Sep10Challenge.verifyChallengeTransactionSigners(challengeXdr, serverAccountId, network, domainNames, webAuthDomain, weightsForSigner.keySet());
        int sum = 0;
        for (String signer : signersFound) {
            Integer weight = (Integer)weightsForSigner.get(signer);
            if (weight == null) continue;
            sum += weight.intValue();
        }
        if (sum < threshold) {
            throw new InvalidSep10ChallengeException(String.format("Signers with weight %d do not meet threshold %d.", sum, threshold));
        }
        return signersFound;
    }

    public static Set<String> verifyChallengeTransactionThreshold(String challengeXdr, String serverAccountId, Network network, String domainName, String webAuthDomain, int threshold, Set<Signer> signers) {
        return Sep10Challenge.verifyChallengeTransactionThreshold(challengeXdr, serverAccountId, network, new String[]{domainName}, webAuthDomain, threshold, signers);
    }

    private static Set<String> verifyTransactionSignatures(Transaction transaction, Set<String> signers) {
        List signatureList;
        if (transaction.getSignatures().isEmpty()) {
            throw new InvalidSep10ChallengeException("Transaction has no signatures.");
        }
        byte[] txHash = transaction.hash();
        HashSet<String> signersFound = new HashSet<String>();
        HashMap signatures = new HashMap();
        for (DecoratedSignature decoratedSignature : transaction.getSignatures()) {
            SignatureHint hint = decoratedSignature.getHint();
            Signature signature = decoratedSignature.getSignature();
            signatureList = signatures.computeIfAbsent(hint, k -> new ArrayList());
            signatureList.add(signature);
        }
        block3: for (String signer : signers) {
            KeyPair keyPair;
            try {
                keyPair = KeyPair.fromAccountId(signer);
            }
            catch (RuntimeException e) {
                continue;
            }
            SignatureHint hint = keyPair.getSignatureHint();
            signatureList = signatures.getOrDefault(hint, Collections.emptyList());
            for (Signature signature : signatureList) {
                if (!keyPair.verify(txHash, signature.getSignature())) continue;
                signersFound.add(signer);
                signatureList.remove(signature);
                continue block3;
            }
        }
        return signersFound;
    }

    private static boolean verifyTransactionSignature(Transaction transaction, String accountId) {
        return !Sep10Challenge.verifyTransactionSignatures(transaction, Collections.singleton(accountId)).isEmpty();
    }

    public static final class ChallengeTransaction {
        private final Transaction transaction;
        private final String clientAccountId;
        private final String matchedHomeDomain;

        @Generated
        public ChallengeTransaction(Transaction transaction, String clientAccountId, String matchedHomeDomain) {
            this.transaction = transaction;
            this.clientAccountId = clientAccountId;
            this.matchedHomeDomain = matchedHomeDomain;
        }

        @Generated
        public Transaction getTransaction() {
            return this.transaction;
        }

        @Generated
        public String getClientAccountId() {
            return this.clientAccountId;
        }

        @Generated
        public String getMatchedHomeDomain() {
            return this.matchedHomeDomain;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChallengeTransaction)) {
                return false;
            }
            ChallengeTransaction other = (ChallengeTransaction)o;
            Transaction this$transaction = this.getTransaction();
            Transaction other$transaction = other.getTransaction();
            if (this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction)) {
                return false;
            }
            String this$clientAccountId = this.getClientAccountId();
            String other$clientAccountId = other.getClientAccountId();
            if (this$clientAccountId == null ? other$clientAccountId != null : !this$clientAccountId.equals(other$clientAccountId)) {
                return false;
            }
            String this$matchedHomeDomain = this.getMatchedHomeDomain();
            String other$matchedHomeDomain = other.getMatchedHomeDomain();
            return !(this$matchedHomeDomain == null ? other$matchedHomeDomain != null : !this$matchedHomeDomain.equals(other$matchedHomeDomain));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Transaction $transaction = this.getTransaction();
            result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
            String $clientAccountId = this.getClientAccountId();
            result = result * 59 + ($clientAccountId == null ? 43 : $clientAccountId.hashCode());
            String $matchedHomeDomain = this.getMatchedHomeDomain();
            result = result * 59 + ($matchedHomeDomain == null ? 43 : $matchedHomeDomain.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Sep10Challenge.ChallengeTransaction(transaction=" + this.getTransaction() + ", clientAccountId=" + this.getClientAccountId() + ", matchedHomeDomain=" + this.getMatchedHomeDomain() + ")";
        }
    }

    public static final class Signer {
        private final String key;
        private final int weight;

        @Generated
        public Signer(String key, int weight) {
            this.key = key;
            this.weight = weight;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public int getWeight() {
            return this.weight;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signer)) {
                return false;
            }
            Signer other = (Signer)o;
            if (this.getWeight() != other.getWeight()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWeight();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Sep10Challenge.Signer(key=" + this.getKey() + ", weight=" + this.getWeight() + ")";
        }
    }
}

