/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Memo;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.Network;
import org.stellar.sdk.SorobanDataBuilder;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.operations.CreateClaimableBalanceOperation;
import org.stellar.sdk.operations.ExtendFootprintTTLOperation;
import org.stellar.sdk.operations.InvokeHostFunctionOperation;
import org.stellar.sdk.operations.RestoreFootprintOperation;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClaimableBalanceIDType;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HashIDPreimage;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SorobanTransactionData;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;
import org.stellar.sdk.xdr.TransactionV0;
import org.stellar.sdk.xdr.TransactionV0Envelope;
import org.stellar.sdk.xdr.TransactionV1Envelope;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class Transaction
extends AbstractTransaction {
    private final long fee;
    @NonNull
    private final String sourceAccount;
    private final long sequenceNumber;
    @NonNull
    private final org.stellar.sdk.operations.Operation[] operations;
    @NonNull
    private final Memo memo;
    private final TransactionPreconditions preconditions;
    private final SorobanTransactionData sorobanData;
    private EnvelopeType envelopeType = EnvelopeType.ENVELOPE_TYPE_TX;

    Transaction(@NonNull String sourceAccount, long fee, long sequenceNumber, @NonNull org.stellar.sdk.operations.Operation[] operations, Memo memo, TransactionPreconditions preconditions, SorobanTransactionData sorobanData, Network network) {
        super(network);
        if (sourceAccount == null) {
            throw new NullPointerException("sourceAccount is marked non-null but is null");
        }
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.sourceAccount = sourceAccount;
        this.sequenceNumber = sequenceNumber;
        this.operations = operations;
        if (operations.length == 0) {
            throw new IllegalArgumentException("At least one operation required");
        }
        this.preconditions = preconditions;
        this.fee = fee;
        this.memo = memo != null ? memo : Memo.none();
        this.sorobanData = sorobanData != null ? new SorobanDataBuilder(sorobanData).build() : null;
    }

    void setEnvelopeType(EnvelopeType envelopeType) {
        this.envelopeType = envelopeType;
    }

    @Override
    public byte[] signatureBase() {
        TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
        taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
        taggedTransaction.setTx(this.toV1Xdr());
        return Transaction.getTransactionSignatureBase(taggedTransaction, this.network);
    }

    public TimeBounds getTimeBounds() {
        return this.preconditions.getTimeBounds();
    }

    public String getClaimableBalanceId(int index) {
        if (index < 0 || index >= this.operations.length) {
            throw new IllegalArgumentException("index: " + index + " is outside the bounds of the operations within this transaction");
        }
        if (!(this.operations[index] instanceof CreateClaimableBalanceOperation)) {
            throw new IllegalArgumentException("operation at index " + index + " is not of type CreateClaimableBalanceOperation: " + this.operations[index].getClass());
        }
        Uint32 opIndex = new Uint32(new XdrUnsignedInteger(index));
        SequenceNumber sequenceNumber = new SequenceNumber(new Int64(this.getSequenceNumber()));
        MuxedAccount sourceMuxedAccount = new MuxedAccount(this.getSourceAccount());
        HashIDPreimage.HashIDPreimageOperationID operationID = HashIDPreimage.HashIDPreimageOperationID.builder().opNum(opIndex).seqNum(sequenceNumber).sourceAccount(KeyPair.fromAccountId(sourceMuxedAccount.getAccountId()).getXdrAccountId()).build();
        HashIDPreimage hashIDPreimage = HashIDPreimage.builder().discriminant(EnvelopeType.ENVELOPE_TYPE_OP_ID).operationID(operationID).build();
        try {
            Hash operationIDHash = new Hash(Util.hash(hashIDPreimage.toXdrByteArray()));
            ClaimableBalanceID claimableBalanceID = ClaimableBalanceID.builder().v0(operationIDHash).discriminant(ClaimableBalanceIDType.CLAIMABLE_BALANCE_ID_TYPE_V0).build();
            return Util.bytesToHex(claimableBalanceID.toXdrByteArray()).toLowerCase();
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    private TransactionV0 toXdr() {
        Uint32 fee = new Uint32();
        fee.setUint32(new XdrUnsignedInteger(this.fee));
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.sequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        Operation[] operations = new Operation[this.operations.length];
        for (int i = 0; i < this.operations.length; ++i) {
            operations[i] = this.operations[i].toXdr();
        }
        TransactionV0.TransactionV0Ext ext = new TransactionV0.TransactionV0Ext();
        ext.setDiscriminant(0);
        TransactionV0 transaction = new TransactionV0();
        transaction.setFee(fee);
        transaction.setSeqNum(sequenceNumber);
        transaction.setSourceAccountEd25519(KeyPair.fromAccountId(this.sourceAccount).getXdrAccountId().getAccountID().getEd25519());
        transaction.setOperations(operations);
        transaction.setMemo(this.memo.toXdr());
        transaction.setTimeBounds(this.getTimeBounds() == null ? null : this.getTimeBounds().toXdr());
        transaction.setExt(ext);
        return transaction;
    }

    private org.stellar.sdk.xdr.Transaction toV1Xdr() {
        Uint32 fee = new Uint32();
        fee.setUint32(new XdrUnsignedInteger(this.fee));
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.sequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        Operation[] operations = new Operation[this.operations.length];
        for (int i = 0; i < this.operations.length; ++i) {
            operations[i] = this.operations[i].toXdr();
        }
        Transaction.TransactionExt ext = new Transaction.TransactionExt();
        if (this.sorobanData != null) {
            ext.setDiscriminant(1);
            ext.setSorobanData(this.sorobanData);
        } else {
            ext.setDiscriminant(0);
        }
        org.stellar.sdk.xdr.Transaction v1Tx = new org.stellar.sdk.xdr.Transaction();
        v1Tx.setFee(fee);
        v1Tx.setSeqNum(sequenceNumber);
        v1Tx.setSourceAccount(new MuxedAccount(this.sourceAccount).toXdr());
        v1Tx.setOperations(operations);
        v1Tx.setMemo(this.memo.toXdr());
        v1Tx.setCond(this.preconditions.toXdr());
        v1Tx.setExt(ext);
        return v1Tx;
    }

    public static Transaction fromV0EnvelopeXdr(TransactionV0Envelope envelope, Network network) {
        long mFee = envelope.getTx().getFee().getUint32().getNumber();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        TimeBounds mTimeBounds = TimeBounds.fromXdr(envelope.getTx().getTimeBounds());
        org.stellar.sdk.operations.Operation[] mOperations = new org.stellar.sdk.operations.Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = org.stellar.sdk.operations.Operation.fromXdr(envelope.getTx().getOperations()[i]);
        }
        Transaction transaction = new Transaction(StrKey.encodeEd25519PublicKey(envelope.getTx().getSourceAccountEd25519().getUint256()), mFee, mSequenceNumber, mOperations, mMemo, TransactionPreconditions.builder().timeBounds(mTimeBounds).build(), null, network);
        transaction.setEnvelopeType(EnvelopeType.ENVELOPE_TYPE_TX_V0);
        transaction.signatures.addAll(Arrays.asList(envelope.getSignatures()));
        return transaction;
    }

    public static Transaction fromV1EnvelopeXdr(TransactionV1Envelope envelope, Network network) {
        long mFee = envelope.getTx().getFee().getUint32().getNumber();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        org.stellar.sdk.operations.Operation[] mOperations = new org.stellar.sdk.operations.Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = org.stellar.sdk.operations.Operation.fromXdr(envelope.getTx().getOperations()[i]);
        }
        SorobanTransactionData sorobanData = envelope.getTx().getExt().getSorobanData();
        Transaction transaction = new Transaction(MuxedAccount.fromXdr(envelope.getTx().getSourceAccount()).getAddress(), mFee, mSequenceNumber, mOperations, mMemo, TransactionPreconditions.fromXdr(envelope.getTx().getCond()), sorobanData, network);
        transaction.signatures.addAll(Arrays.asList(envelope.getSignatures()));
        return transaction;
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        DecoratedSignature[] signatures = new DecoratedSignature[this.signatures.size()];
        signatures = this.signatures.toArray(signatures);
        if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX) {
            TransactionV1Envelope v1Envelope = new TransactionV1Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
            v1Envelope.setTx(this.toV1Xdr());
            v1Envelope.setSignatures(signatures);
            xdr.setV1(v1Envelope);
        } else if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
            TransactionV0Envelope v0Envelope = new TransactionV0Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_V0);
            v0Envelope.setTx(this.toXdr());
            v0Envelope.setSignatures(signatures);
            xdr.setV0(v0Envelope);
        } else {
            throw new IllegalStateException("invalid envelope type: " + this.envelopeType);
        }
        return xdr;
    }

    public boolean isSorobanTransaction() {
        if (this.operations.length != 1) {
            return false;
        }
        org.stellar.sdk.operations.Operation op = this.operations[0];
        return op instanceof InvokeHostFunctionOperation || op instanceof ExtendFootprintTTLOperation || op instanceof RestoreFootprintOperation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Transaction that = (Transaction)object;
        return Arrays.equals(this.signatureBase(), that.signatureBase());
    }

    public int hashCode() {
        return Arrays.hashCode(this.signatureBase());
    }

    @Generated
    public long getFee() {
        return this.fee;
    }

    @NonNull
    @Generated
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @NonNull
    @Generated
    public org.stellar.sdk.operations.Operation[] getOperations() {
        return this.operations;
    }

    @NonNull
    @Generated
    public Memo getMemo() {
        return this.memo;
    }

    @Generated
    public TransactionPreconditions getPreconditions() {
        return this.preconditions;
    }

    @Generated
    public SorobanTransactionData getSorobanData() {
        return this.sorobanData;
    }
}

