/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.AllowTrustOp;
import org.stellar.sdk.xdr.AssetCode;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.TrustLineFlags;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

@Deprecated
public class AllowTrustOperation
extends Operation {
    @NonNull
    private final String trustor;
    @NonNull
    private final String assetCode;
    @NonNull
    private final TrustLineEntryFlag authorize;

    public static AllowTrustOperation fromXdr(AllowTrustOp op) {
        String assetCode;
        String trustor = StrKey.encodeEd25519PublicKey(op.getTrustor().getAccountID().getEd25519().getUint256());
        switch (op.getAsset().getDiscriminant()) {
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                assetCode = new String(op.getAsset().getAssetCode4().getAssetCode4()).trim();
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                assetCode = new String(op.getAsset().getAssetCode12().getAssetCode12()).trim();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown asset code");
            }
        }
        int flag = op.getAuthorize().getUint32().getNumber().intValue();
        TrustLineEntryFlag authorize = TrustLineEntryFlag.fromValue(flag);
        return new AllowTrustOperation(trustor, assetCode, authorize);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        AllowTrustOp op = new AllowTrustOp();
        op.setTrustor(KeyPair.fromAccountId(this.trustor).getXdrAccountId());
        AssetCode asset = new AssetCode();
        if (this.assetCode.length() <= 4) {
            AssetCode4 assetCode4 = new AssetCode4();
            assetCode4.setAssetCode4(Util.paddedByteArray(this.assetCode, 4));
            asset.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM4);
            asset.setAssetCode4(assetCode4);
        } else {
            AssetCode12 assetCode12 = new AssetCode12();
            assetCode12.setAssetCode12(Util.paddedByteArray(this.assetCode, 12));
            asset.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM12);
            asset.setAssetCode12(assetCode12);
        }
        op.setAsset(asset);
        Uint32 flag = new Uint32(new XdrUnsignedInteger(this.authorize.value));
        op.setAuthorize(flag);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.ALLOW_TRUST);
        body.setAllowTrustOp(op);
        return body;
    }

    @Generated
    protected AllowTrustOperation(AllowTrustOperationBuilder<?, ?> b) {
        super(b);
        this.trustor = ((AllowTrustOperationBuilder)b).trustor;
        if (this.trustor == null) {
            throw new NullPointerException("trustor is marked non-null but is null");
        }
        this.assetCode = ((AllowTrustOperationBuilder)b).assetCode;
        if (this.assetCode == null) {
            throw new NullPointerException("assetCode is marked non-null but is null");
        }
        this.authorize = ((AllowTrustOperationBuilder)b).authorize;
        if (this.authorize == null) {
            throw new NullPointerException("authorize is marked non-null but is null");
        }
    }

    @Generated
    public static AllowTrustOperationBuilder<?, ?> builder() {
        return new AllowTrustOperationBuilderImpl();
    }

    @Generated
    public AllowTrustOperationBuilder<?, ?> toBuilder() {
        return new AllowTrustOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getTrustor() {
        return this.trustor;
    }

    @NonNull
    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @NonNull
    @Generated
    public TrustLineEntryFlag getAuthorize() {
        return this.authorize;
    }

    @Generated
    public String toString() {
        return "AllowTrustOperation(super=" + super.toString() + ", trustor=" + this.getTrustor() + ", assetCode=" + this.getAssetCode() + ", authorize=" + (Object)((Object)this.getAuthorize()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowTrustOperation)) {
            return false;
        }
        AllowTrustOperation other = (AllowTrustOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$trustor = this.getTrustor();
        String other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !this$trustor.equals(other$trustor)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        TrustLineEntryFlag this$authorize = this.getAuthorize();
        TrustLineEntryFlag other$authorize = other.getAuthorize();
        return !(this$authorize == null ? other$authorize != null : !((Object)((Object)this$authorize)).equals((Object)other$authorize));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AllowTrustOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : $trustor.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        TrustLineEntryFlag $authorize = this.getAuthorize();
        result = result * 59 + ($authorize == null ? 43 : ((Object)((Object)$authorize)).hashCode());
        return result;
    }

    @Generated
    private AllowTrustOperation(@NonNull String trustor, @NonNull String assetCode, @NonNull TrustLineEntryFlag authorize) {
        if (trustor == null) {
            throw new NullPointerException("trustor is marked non-null but is null");
        }
        if (assetCode == null) {
            throw new NullPointerException("assetCode is marked non-null but is null");
        }
        if (authorize == null) {
            throw new NullPointerException("authorize is marked non-null but is null");
        }
        this.trustor = trustor;
        this.assetCode = assetCode;
        this.authorize = authorize;
    }

    public static enum TrustLineEntryFlag {
        UNAUTHORIZED_FLAG(0),
        AUTHORIZED_FLAG(TrustLineFlags.AUTHORIZED_FLAG.getValue()),
        AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG(TrustLineFlags.AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG.getValue());

        private final int value;

        private TrustLineEntryFlag(int value) {
            this.value = value;
        }

        static TrustLineEntryFlag fromValue(int value) {
            for (TrustLineEntryFlag flag : TrustLineEntryFlag.values()) {
                if (flag.getValue() != value) continue;
                return flag;
            }
            throw new IllegalArgumentException("Invalid TrustLineEntryFlag value: " + value);
        }

        @Generated
        public int getValue() {
            return this.value;
        }
    }

    @Generated
    public static abstract class AllowTrustOperationBuilder<C extends AllowTrustOperation, B extends AllowTrustOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String trustor;
        @Generated
        private String assetCode;
        @Generated
        private TrustLineEntryFlag authorize;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AllowTrustOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AllowTrustOperation instance, AllowTrustOperationBuilder<?, ?> b) {
            b.trustor(instance.trustor);
            b.assetCode(instance.assetCode);
            b.authorize(instance.authorize);
        }

        @Generated
        public B trustor(@NonNull String trustor) {
            if (trustor == null) {
                throw new NullPointerException("trustor is marked non-null but is null");
            }
            this.trustor = trustor;
            return (B)this.self();
        }

        @Generated
        public B assetCode(@NonNull String assetCode) {
            if (assetCode == null) {
                throw new NullPointerException("assetCode is marked non-null but is null");
            }
            this.assetCode = assetCode;
            return (B)this.self();
        }

        @Generated
        public B authorize(@NonNull TrustLineEntryFlag authorize) {
            if (authorize == null) {
                throw new NullPointerException("authorize is marked non-null but is null");
            }
            this.authorize = authorize;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AllowTrustOperation.AllowTrustOperationBuilder(super=" + super.toString() + ", trustor=" + this.trustor + ", assetCode=" + this.assetCode + ", authorize=" + (Object)((Object)this.authorize) + ")";
        }
    }

    @Generated
    private static final class AllowTrustOperationBuilderImpl
    extends AllowTrustOperationBuilder<AllowTrustOperation, AllowTrustOperationBuilderImpl> {
        @Generated
        private AllowTrustOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected AllowTrustOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AllowTrustOperation build() {
            return new AllowTrustOperation(this);
        }
    }
}

