/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.CreateAccountOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class CreateAccountOperation
extends Operation {
    @NonNull
    private final String destination;
    @NonNull
    private final BigDecimal startingBalance;

    public static CreateAccountOperation fromXdr(CreateAccountOp op) {
        String destination = StrKey.encodeEd25519PublicKey(op.getDestination().getAccountID().getEd25519().getUint256());
        BigDecimal startingBalance = Operation.fromXdrAmount(op.getStartingBalance().getInt64());
        return new CreateAccountOperation(destination, startingBalance);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        CreateAccountOp op = new CreateAccountOp();
        op.setDestination(KeyPair.fromAccountId(this.destination).getXdrAccountId());
        Int64 startingBalance = new Int64();
        startingBalance.setInt64(Operation.toXdrAmount(this.startingBalance));
        op.setStartingBalance(startingBalance);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_ACCOUNT);
        body.setCreateAccountOp(op);
        return body;
    }

    @Generated
    protected CreateAccountOperation(CreateAccountOperationBuilder<?, ?> b) {
        super(b);
        this.destination = ((CreateAccountOperationBuilder)b).destination;
        if (this.destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.startingBalance = ((CreateAccountOperationBuilder)b).startingBalance;
        if (this.startingBalance == null) {
            throw new NullPointerException("startingBalance is marked non-null but is null");
        }
    }

    @Generated
    public static CreateAccountOperationBuilder<?, ?> builder() {
        return new CreateAccountOperationBuilderImpl();
    }

    @Generated
    public CreateAccountOperationBuilder<?, ?> toBuilder() {
        return new CreateAccountOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public BigDecimal getStartingBalance() {
        return this.startingBalance;
    }

    @Generated
    public String toString() {
        return "CreateAccountOperation(super=" + super.toString() + ", destination=" + this.getDestination() + ", startingBalance=" + this.getStartingBalance() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAccountOperation)) {
            return false;
        }
        CreateAccountOperation other = (CreateAccountOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        BigDecimal this$startingBalance = this.getStartingBalance();
        BigDecimal other$startingBalance = other.getStartingBalance();
        return !(this$startingBalance == null ? other$startingBalance != null : !((Object)this$startingBalance).equals(other$startingBalance));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateAccountOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        BigDecimal $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : ((Object)$startingBalance).hashCode());
        return result;
    }

    @Generated
    private CreateAccountOperation(@NonNull String destination, @NonNull BigDecimal startingBalance) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (startingBalance == null) {
            throw new NullPointerException("startingBalance is marked non-null but is null");
        }
        this.destination = destination;
        this.startingBalance = startingBalance;
    }

    public static abstract class CreateAccountOperationBuilder<C extends CreateAccountOperation, B extends CreateAccountOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String destination;
        @Generated
        private BigDecimal startingBalance;

        public B startingBalance(@NonNull BigDecimal startingBalance) {
            if (startingBalance == null) {
                throw new NullPointerException("startingBalance is marked non-null but is null");
            }
            this.startingBalance = Operation.formatAmountScale(startingBalance);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateAccountOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CreateAccountOperation instance, CreateAccountOperationBuilder<?, ?> b) {
            b.destination(instance.destination);
            b.startingBalance(instance.startingBalance);
        }

        @Generated
        public B destination(@NonNull String destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination = destination;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreateAccountOperation.CreateAccountOperationBuilder(super=" + super.toString() + ", destination=" + this.destination + ", startingBalance=" + this.startingBalance + ")";
        }
    }

    @Generated
    private static final class CreateAccountOperationBuilderImpl
    extends CreateAccountOperationBuilder<CreateAccountOperation, CreateAccountOperationBuilderImpl> {
        @Generated
        private CreateAccountOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateAccountOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreateAccountOperation build() {
            return new CreateAccountOperation(this);
        }
    }
}

