/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TrustLineAsset;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeTrustlineSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;
    @NonNull
    private final TrustLineAsset asset;

    public static RevokeTrustlineSponsorshipOperation fromXdr(RevokeSponsorshipOp op) {
        String accountId = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getTrustLine().getAccountID().getAccountID().getEd25519().getUint256());
        TrustLineAsset asset = TrustLineAsset.fromXdr(op.getLedgerKey().getTrustLine().getAsset());
        return new RevokeTrustlineSponsorshipOperation(accountId, asset);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.TRUSTLINE);
        LedgerKey.LedgerKeyTrustLine trustLine = new LedgerKey.LedgerKeyTrustLine();
        trustLine.setAccountID(KeyPair.fromAccountId(this.accountId).getXdrAccountId());
        trustLine.setAsset(this.asset.toXdr());
        key.setTrustLine(trustLine);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @Generated
    protected RevokeTrustlineSponsorshipOperation(RevokeTrustlineSponsorshipOperationBuilder<?, ?> b) {
        super(b);
        this.accountId = ((RevokeTrustlineSponsorshipOperationBuilder)b).accountId;
        if (this.accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        this.asset = ((RevokeTrustlineSponsorshipOperationBuilder)b).asset;
        if (this.asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
    }

    @Generated
    public static RevokeTrustlineSponsorshipOperationBuilder<?, ?> builder() {
        return new RevokeTrustlineSponsorshipOperationBuilderImpl();
    }

    @Generated
    public RevokeTrustlineSponsorshipOperationBuilder<?, ?> toBuilder() {
        return new RevokeTrustlineSponsorshipOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @NonNull
    @Generated
    public TrustLineAsset getAsset() {
        return this.asset;
    }

    @Generated
    public String toString() {
        return "RevokeTrustlineSponsorshipOperation(super=" + super.toString() + ", accountId=" + this.getAccountId() + ", asset=" + this.getAsset() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeTrustlineSponsorshipOperation)) {
            return false;
        }
        RevokeTrustlineSponsorshipOperation other = (RevokeTrustlineSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        TrustLineAsset this$asset = this.getAsset();
        TrustLineAsset other$asset = other.getAsset();
        return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeTrustlineSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        TrustLineAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        return result;
    }

    @Generated
    private RevokeTrustlineSponsorshipOperation(@NonNull String accountId, @NonNull TrustLineAsset asset) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.accountId = accountId;
        this.asset = asset;
    }

    @Generated
    public static abstract class RevokeTrustlineSponsorshipOperationBuilder<C extends RevokeTrustlineSponsorshipOperation, B extends RevokeTrustlineSponsorshipOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String accountId;
        @Generated
        private TrustLineAsset asset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RevokeTrustlineSponsorshipOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RevokeTrustlineSponsorshipOperation instance, RevokeTrustlineSponsorshipOperationBuilder<?, ?> b) {
            b.accountId(instance.accountId);
            b.asset(instance.asset);
        }

        @Generated
        public B accountId(@NonNull String accountId) {
            if (accountId == null) {
                throw new NullPointerException("accountId is marked non-null but is null");
            }
            this.accountId = accountId;
            return (B)this.self();
        }

        @Generated
        public B asset(@NonNull TrustLineAsset asset) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            this.asset = asset;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RevokeTrustlineSponsorshipOperation.RevokeTrustlineSponsorshipOperationBuilder(super=" + super.toString() + ", accountId=" + this.accountId + ", asset=" + this.asset + ")";
        }
    }

    @Generated
    private static final class RevokeTrustlineSponsorshipOperationBuilderImpl
    extends RevokeTrustlineSponsorshipOperationBuilder<RevokeTrustlineSponsorshipOperation, RevokeTrustlineSponsorshipOperationBuilderImpl> {
        @Generated
        private RevokeTrustlineSponsorshipOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected RevokeTrustlineSponsorshipOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RevokeTrustlineSponsorshipOperation build() {
            return new RevokeTrustlineSponsorshipOperation(this);
        }
    }
}

