/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.util.EnumSet;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SetTrustLineFlagsOp;
import org.stellar.sdk.xdr.TrustLineFlags;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class SetTrustlineFlagsOperation
extends Operation {
    @NonNull
    private final String trustor;
    @NonNull
    private final Asset asset;
    @NonNull
    private final EnumSet<TrustLineFlags> setFlags;
    @NonNull
    private final EnumSet<TrustLineFlags> clearFlags;

    public static SetTrustlineFlagsOperation fromXdr(SetTrustLineFlagsOp op) {
        String trustor = StrKey.encodeEd25519PublicKey(op.getTrustor().getAccountID().getEd25519().getUint256());
        AssetTypeCreditAlphaNum asset = Util.assertNonNativeAsset(Asset.fromXdr(op.getAsset()));
        EnumSet<TrustLineFlags> clearFlags = SetTrustlineFlagsOperation.flagSetFromInt(op.getClearFlags().getUint32().getNumber().intValue());
        EnumSet<TrustLineFlags> setFlags = SetTrustlineFlagsOperation.flagSetFromInt(op.getSetFlags().getUint32().getNumber().intValue());
        return new SetTrustlineFlagsOperation(trustor, asset, setFlags, clearFlags);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        SetTrustLineFlagsOp op = new SetTrustLineFlagsOp();
        op.setTrustor(KeyPair.fromAccountId(this.trustor).getXdrAccountId());
        op.setAsset(this.asset.toXdr());
        op.setClearFlags(SetTrustlineFlagsOperation.bitwiseOr(this.clearFlags));
        op.setSetFlags(SetTrustlineFlagsOperation.bitwiseOr(this.setFlags));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.SET_TRUST_LINE_FLAGS);
        body.setSetTrustLineFlagsOp(op);
        return body;
    }

    private static EnumSet<TrustLineFlags> flagSetFromInt(int x) {
        EnumSet<TrustLineFlags> set = EnumSet.noneOf(TrustLineFlags.class);
        for (TrustLineFlags flag : TrustLineFlags.values()) {
            if ((flag.getValue() & x) == 0) continue;
            set.add(flag);
        }
        return set;
    }

    private static Uint32 bitwiseOr(EnumSet<TrustLineFlags> set) {
        int v = 0;
        for (TrustLineFlags f : set) {
            v |= f.getValue();
        }
        Uint32 combined = new Uint32();
        combined.setUint32(new XdrUnsignedInteger(v));
        return combined;
    }

    @Generated
    protected SetTrustlineFlagsOperation(SetTrustlineFlagsOperationBuilder<?, ?> b) {
        super(b);
        this.trustor = ((SetTrustlineFlagsOperationBuilder)b).trustor;
        if (this.trustor == null) {
            throw new NullPointerException("trustor is marked non-null but is null");
        }
        this.asset = ((SetTrustlineFlagsOperationBuilder)b).asset;
        if (this.asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.setFlags = ((SetTrustlineFlagsOperationBuilder)b).setFlags;
        if (this.setFlags == null) {
            throw new NullPointerException("setFlags is marked non-null but is null");
        }
        this.clearFlags = ((SetTrustlineFlagsOperationBuilder)b).clearFlags;
        if (this.clearFlags == null) {
            throw new NullPointerException("clearFlags is marked non-null but is null");
        }
    }

    @Generated
    public static SetTrustlineFlagsOperationBuilder<?, ?> builder() {
        return new SetTrustlineFlagsOperationBuilderImpl();
    }

    @Generated
    public SetTrustlineFlagsOperationBuilder<?, ?> toBuilder() {
        return new SetTrustlineFlagsOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getTrustor() {
        return this.trustor;
    }

    @NonNull
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public EnumSet<TrustLineFlags> getSetFlags() {
        return this.setFlags;
    }

    @NonNull
    @Generated
    public EnumSet<TrustLineFlags> getClearFlags() {
        return this.clearFlags;
    }

    @Generated
    public String toString() {
        return "SetTrustlineFlagsOperation(super=" + super.toString() + ", trustor=" + this.getTrustor() + ", asset=" + this.getAsset() + ", setFlags=" + this.getSetFlags() + ", clearFlags=" + this.getClearFlags() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetTrustlineFlagsOperation)) {
            return false;
        }
        SetTrustlineFlagsOperation other = (SetTrustlineFlagsOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$trustor = this.getTrustor();
        String other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !this$trustor.equals(other$trustor)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        EnumSet<TrustLineFlags> this$setFlags = this.getSetFlags();
        EnumSet<TrustLineFlags> other$setFlags = other.getSetFlags();
        if (this$setFlags == null ? other$setFlags != null : !((Object)this$setFlags).equals(other$setFlags)) {
            return false;
        }
        EnumSet<TrustLineFlags> this$clearFlags = this.getClearFlags();
        EnumSet<TrustLineFlags> other$clearFlags = other.getClearFlags();
        return !(this$clearFlags == null ? other$clearFlags != null : !((Object)this$clearFlags).equals(other$clearFlags));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetTrustlineFlagsOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : $trustor.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        EnumSet<TrustLineFlags> $setFlags = this.getSetFlags();
        result = result * 59 + ($setFlags == null ? 43 : ((Object)$setFlags).hashCode());
        EnumSet<TrustLineFlags> $clearFlags = this.getClearFlags();
        result = result * 59 + ($clearFlags == null ? 43 : ((Object)$clearFlags).hashCode());
        return result;
    }

    @Generated
    private SetTrustlineFlagsOperation(@NonNull String trustor, @NonNull Asset asset, @NonNull EnumSet<TrustLineFlags> setFlags, @NonNull EnumSet<TrustLineFlags> clearFlags) {
        if (trustor == null) {
            throw new NullPointerException("trustor is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (setFlags == null) {
            throw new NullPointerException("setFlags is marked non-null but is null");
        }
        if (clearFlags == null) {
            throw new NullPointerException("clearFlags is marked non-null but is null");
        }
        this.trustor = trustor;
        this.asset = asset;
        this.setFlags = setFlags;
        this.clearFlags = clearFlags;
    }

    @Generated
    public static abstract class SetTrustlineFlagsOperationBuilder<C extends SetTrustlineFlagsOperation, B extends SetTrustlineFlagsOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String trustor;
        @Generated
        private Asset asset;
        @Generated
        private EnumSet<TrustLineFlags> setFlags;
        @Generated
        private EnumSet<TrustLineFlags> clearFlags;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetTrustlineFlagsOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SetTrustlineFlagsOperation instance, SetTrustlineFlagsOperationBuilder<?, ?> b) {
            b.trustor(instance.trustor);
            b.asset(instance.asset);
            b.setFlags(instance.setFlags);
            b.clearFlags(instance.clearFlags);
        }

        @Generated
        public B trustor(@NonNull String trustor) {
            if (trustor == null) {
                throw new NullPointerException("trustor is marked non-null but is null");
            }
            this.trustor = trustor;
            return (B)this.self();
        }

        @Generated
        public B asset(@NonNull Asset asset) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            this.asset = asset;
            return (B)this.self();
        }

        @Generated
        public B setFlags(@NonNull EnumSet<TrustLineFlags> setFlags) {
            if (setFlags == null) {
                throw new NullPointerException("setFlags is marked non-null but is null");
            }
            this.setFlags = setFlags;
            return (B)this.self();
        }

        @Generated
        public B clearFlags(@NonNull EnumSet<TrustLineFlags> clearFlags) {
            if (clearFlags == null) {
                throw new NullPointerException("clearFlags is marked non-null but is null");
            }
            this.clearFlags = clearFlags;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetTrustlineFlagsOperation.SetTrustlineFlagsOperationBuilder(super=" + super.toString() + ", trustor=" + this.trustor + ", asset=" + this.asset + ", setFlags=" + this.setFlags + ", clearFlags=" + this.clearFlags + ")";
        }
    }

    private static final class SetTrustlineFlagsOperationBuilderImpl
    extends SetTrustlineFlagsOperationBuilder<SetTrustlineFlagsOperation, SetTrustlineFlagsOperationBuilderImpl> {
        @Override
        public SetTrustlineFlagsOperation build() {
            SetTrustlineFlagsOperation op = new SetTrustlineFlagsOperation(this);
            if (!(op.asset instanceof AssetTypeCreditAlphaNum)) {
                throw new IllegalArgumentException("native assets are not supported");
            }
            return op;
        }

        @Generated
        private SetTrustlineFlagsOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected SetTrustlineFlagsOperationBuilderImpl self() {
            return this;
        }
    }
}

