/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;

public final class AssetResponse
extends Response
implements Pageable {
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="contract_id")
    private final String contractId;
    @SerializedName(value="num_claimable_balances")
    private final Integer numClaimableBalances;
    @SerializedName(value="num_liquidity_pools")
    private final Integer numLiquidityPools;
    @SerializedName(value="num_contracts")
    private final Integer numContracts;
    @SerializedName(value="accounts")
    private final Accounts accounts;
    @SerializedName(value="claimable_balances_amount")
    private final String claimableBalancesAmount;
    @SerializedName(value="liquidity_pools_amount")
    private final String liquidityPoolsAmount;
    @SerializedName(value="contracts_amount")
    private final String contractsAmount;
    @SerializedName(value="balances")
    private final Balances balances;
    @SerializedName(value="flags")
    private final Flags flags;
    @SerializedName(value="_links")
    private final Links links;

    public Asset getAsset() {
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    @Generated
    public AssetResponse(String assetType, String assetCode, String assetIssuer, String pagingToken, String contractId, Integer numClaimableBalances, Integer numLiquidityPools, Integer numContracts, Accounts accounts, String claimableBalancesAmount, String liquidityPoolsAmount, String contractsAmount, Balances balances, Flags flags, Links links) {
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.pagingToken = pagingToken;
        this.contractId = contractId;
        this.numClaimableBalances = numClaimableBalances;
        this.numLiquidityPools = numLiquidityPools;
        this.numContracts = numContracts;
        this.accounts = accounts;
        this.claimableBalancesAmount = claimableBalancesAmount;
        this.liquidityPoolsAmount = liquidityPoolsAmount;
        this.contractsAmount = contractsAmount;
        this.balances = balances;
        this.flags = flags;
        this.links = links;
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    @Override
    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public String getContractId() {
        return this.contractId;
    }

    @Generated
    public Integer getNumClaimableBalances() {
        return this.numClaimableBalances;
    }

    @Generated
    public Integer getNumLiquidityPools() {
        return this.numLiquidityPools;
    }

    @Generated
    public Integer getNumContracts() {
        return this.numContracts;
    }

    @Generated
    public Accounts getAccounts() {
        return this.accounts;
    }

    @Generated
    public String getClaimableBalancesAmount() {
        return this.claimableBalancesAmount;
    }

    @Generated
    public String getLiquidityPoolsAmount() {
        return this.liquidityPoolsAmount;
    }

    @Generated
    public String getContractsAmount() {
        return this.contractsAmount;
    }

    @Generated
    public Balances getBalances() {
        return this.balances;
    }

    @Generated
    public Flags getFlags() {
        return this.flags;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "AssetResponse(assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", pagingToken=" + this.getPagingToken() + ", contractId=" + this.getContractId() + ", numClaimableBalances=" + this.getNumClaimableBalances() + ", numLiquidityPools=" + this.getNumLiquidityPools() + ", numContracts=" + this.getNumContracts() + ", accounts=" + this.getAccounts() + ", claimableBalancesAmount=" + this.getClaimableBalancesAmount() + ", liquidityPoolsAmount=" + this.getLiquidityPoolsAmount() + ", contractsAmount=" + this.getContractsAmount() + ", balances=" + this.getBalances() + ", flags=" + this.getFlags() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetResponse)) {
            return false;
        }
        AssetResponse other = (AssetResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$numClaimableBalances = this.getNumClaimableBalances();
        Integer other$numClaimableBalances = other.getNumClaimableBalances();
        if (this$numClaimableBalances == null ? other$numClaimableBalances != null : !((Object)this$numClaimableBalances).equals(other$numClaimableBalances)) {
            return false;
        }
        Integer this$numLiquidityPools = this.getNumLiquidityPools();
        Integer other$numLiquidityPools = other.getNumLiquidityPools();
        if (this$numLiquidityPools == null ? other$numLiquidityPools != null : !((Object)this$numLiquidityPools).equals(other$numLiquidityPools)) {
            return false;
        }
        Integer this$numContracts = this.getNumContracts();
        Integer other$numContracts = other.getNumContracts();
        if (this$numContracts == null ? other$numContracts != null : !((Object)this$numContracts).equals(other$numContracts)) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        String this$assetIssuer = this.getAssetIssuer();
        String other$assetIssuer = other.getAssetIssuer();
        if (this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        String this$contractId = this.getContractId();
        String other$contractId = other.getContractId();
        if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
            return false;
        }
        Accounts this$accounts = this.getAccounts();
        Accounts other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        String this$claimableBalancesAmount = this.getClaimableBalancesAmount();
        String other$claimableBalancesAmount = other.getClaimableBalancesAmount();
        if (this$claimableBalancesAmount == null ? other$claimableBalancesAmount != null : !this$claimableBalancesAmount.equals(other$claimableBalancesAmount)) {
            return false;
        }
        String this$liquidityPoolsAmount = this.getLiquidityPoolsAmount();
        String other$liquidityPoolsAmount = other.getLiquidityPoolsAmount();
        if (this$liquidityPoolsAmount == null ? other$liquidityPoolsAmount != null : !this$liquidityPoolsAmount.equals(other$liquidityPoolsAmount)) {
            return false;
        }
        String this$contractsAmount = this.getContractsAmount();
        String other$contractsAmount = other.getContractsAmount();
        if (this$contractsAmount == null ? other$contractsAmount != null : !this$contractsAmount.equals(other$contractsAmount)) {
            return false;
        }
        Balances this$balances = this.getBalances();
        Balances other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $numClaimableBalances = this.getNumClaimableBalances();
        result = result * 59 + ($numClaimableBalances == null ? 43 : ((Object)$numClaimableBalances).hashCode());
        Integer $numLiquidityPools = this.getNumLiquidityPools();
        result = result * 59 + ($numLiquidityPools == null ? 43 : ((Object)$numLiquidityPools).hashCode());
        Integer $numContracts = this.getNumContracts();
        result = result * 59 + ($numContracts == null ? 43 : ((Object)$numContracts).hashCode());
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        String $assetIssuer = this.getAssetIssuer();
        result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        String $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
        Accounts $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        String $claimableBalancesAmount = this.getClaimableBalancesAmount();
        result = result * 59 + ($claimableBalancesAmount == null ? 43 : $claimableBalancesAmount.hashCode());
        String $liquidityPoolsAmount = this.getLiquidityPoolsAmount();
        result = result * 59 + ($liquidityPoolsAmount == null ? 43 : $liquidityPoolsAmount.hashCode());
        String $contractsAmount = this.getContractsAmount();
        result = result * 59 + ($contractsAmount == null ? 43 : $contractsAmount.hashCode());
        Balances $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Accounts {
        @SerializedName(value="authorized")
        private final Integer authorized;
        @SerializedName(value="authorized_to_maintain_liabilities")
        private final Integer authorizedToMaintainLiabilities;
        @SerializedName(value="unauthorized")
        private final Integer unauthorized;

        @Generated
        public Accounts(Integer authorized, Integer authorizedToMaintainLiabilities, Integer unauthorized) {
            this.authorized = authorized;
            this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
            this.unauthorized = unauthorized;
        }

        @Generated
        public Integer getAuthorized() {
            return this.authorized;
        }

        @Generated
        public Integer getAuthorizedToMaintainLiabilities() {
            return this.authorizedToMaintainLiabilities;
        }

        @Generated
        public Integer getUnauthorized() {
            return this.unauthorized;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accounts)) {
                return false;
            }
            Accounts other = (Accounts)o;
            Integer this$authorized = this.getAuthorized();
            Integer other$authorized = other.getAuthorized();
            if (this$authorized == null ? other$authorized != null : !((Object)this$authorized).equals(other$authorized)) {
                return false;
            }
            Integer this$authorizedToMaintainLiabilities = this.getAuthorizedToMaintainLiabilities();
            Integer other$authorizedToMaintainLiabilities = other.getAuthorizedToMaintainLiabilities();
            if (this$authorizedToMaintainLiabilities == null ? other$authorizedToMaintainLiabilities != null : !((Object)this$authorizedToMaintainLiabilities).equals(other$authorizedToMaintainLiabilities)) {
                return false;
            }
            Integer this$unauthorized = this.getUnauthorized();
            Integer other$unauthorized = other.getUnauthorized();
            return !(this$unauthorized == null ? other$unauthorized != null : !((Object)this$unauthorized).equals(other$unauthorized));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $authorized = this.getAuthorized();
            result = result * 59 + ($authorized == null ? 43 : ((Object)$authorized).hashCode());
            Integer $authorizedToMaintainLiabilities = this.getAuthorizedToMaintainLiabilities();
            result = result * 59 + ($authorizedToMaintainLiabilities == null ? 43 : ((Object)$authorizedToMaintainLiabilities).hashCode());
            Integer $unauthorized = this.getUnauthorized();
            result = result * 59 + ($unauthorized == null ? 43 : ((Object)$unauthorized).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssetResponse.Accounts(authorized=" + this.getAuthorized() + ", authorizedToMaintainLiabilities=" + this.getAuthorizedToMaintainLiabilities() + ", unauthorized=" + this.getUnauthorized() + ")";
        }
    }

    public static final class Balances {
        @SerializedName(value="authorized")
        private final String authorized;
        @SerializedName(value="authorized_to_maintain_liabilities")
        private final String authorizedToMaintainLiabilities;
        @SerializedName(value="unauthorized")
        private final String unauthorized;

        @Generated
        public Balances(String authorized, String authorizedToMaintainLiabilities, String unauthorized) {
            this.authorized = authorized;
            this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
            this.unauthorized = unauthorized;
        }

        @Generated
        public String getAuthorized() {
            return this.authorized;
        }

        @Generated
        public String getAuthorizedToMaintainLiabilities() {
            return this.authorizedToMaintainLiabilities;
        }

        @Generated
        public String getUnauthorized() {
            return this.unauthorized;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balances)) {
                return false;
            }
            Balances other = (Balances)o;
            String this$authorized = this.getAuthorized();
            String other$authorized = other.getAuthorized();
            if (this$authorized == null ? other$authorized != null : !this$authorized.equals(other$authorized)) {
                return false;
            }
            String this$authorizedToMaintainLiabilities = this.getAuthorizedToMaintainLiabilities();
            String other$authorizedToMaintainLiabilities = other.getAuthorizedToMaintainLiabilities();
            if (this$authorizedToMaintainLiabilities == null ? other$authorizedToMaintainLiabilities != null : !this$authorizedToMaintainLiabilities.equals(other$authorizedToMaintainLiabilities)) {
                return false;
            }
            String this$unauthorized = this.getUnauthorized();
            String other$unauthorized = other.getUnauthorized();
            return !(this$unauthorized == null ? other$unauthorized != null : !this$unauthorized.equals(other$unauthorized));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $authorized = this.getAuthorized();
            result = result * 59 + ($authorized == null ? 43 : $authorized.hashCode());
            String $authorizedToMaintainLiabilities = this.getAuthorizedToMaintainLiabilities();
            result = result * 59 + ($authorizedToMaintainLiabilities == null ? 43 : $authorizedToMaintainLiabilities.hashCode());
            String $unauthorized = this.getUnauthorized();
            result = result * 59 + ($unauthorized == null ? 43 : $unauthorized.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssetResponse.Balances(authorized=" + this.getAuthorized() + ", authorizedToMaintainLiabilities=" + this.getAuthorizedToMaintainLiabilities() + ", unauthorized=" + this.getUnauthorized() + ")";
        }
    }

    public static final class Flags {
        @SerializedName(value="auth_required")
        private final Boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final Boolean authRevocable;
        @SerializedName(value="auth_immutable")
        private final Boolean authImmutable;
        @SerializedName(value="auth_clawback_enabled")
        private final Boolean authClawbackEnabled;

        @Generated
        public Flags(Boolean authRequired, Boolean authRevocable, Boolean authImmutable, Boolean authClawbackEnabled) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
            this.authImmutable = authImmutable;
            this.authClawbackEnabled = authClawbackEnabled;
        }

        @Generated
        public Boolean getAuthRequired() {
            return this.authRequired;
        }

        @Generated
        public Boolean getAuthRevocable() {
            return this.authRevocable;
        }

        @Generated
        public Boolean getAuthImmutable() {
            return this.authImmutable;
        }

        @Generated
        public Boolean getAuthClawbackEnabled() {
            return this.authClawbackEnabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Flags)) {
                return false;
            }
            Flags other = (Flags)o;
            Boolean this$authRequired = this.getAuthRequired();
            Boolean other$authRequired = other.getAuthRequired();
            if (this$authRequired == null ? other$authRequired != null : !((Object)this$authRequired).equals(other$authRequired)) {
                return false;
            }
            Boolean this$authRevocable = this.getAuthRevocable();
            Boolean other$authRevocable = other.getAuthRevocable();
            if (this$authRevocable == null ? other$authRevocable != null : !((Object)this$authRevocable).equals(other$authRevocable)) {
                return false;
            }
            Boolean this$authImmutable = this.getAuthImmutable();
            Boolean other$authImmutable = other.getAuthImmutable();
            if (this$authImmutable == null ? other$authImmutable != null : !((Object)this$authImmutable).equals(other$authImmutable)) {
                return false;
            }
            Boolean this$authClawbackEnabled = this.getAuthClawbackEnabled();
            Boolean other$authClawbackEnabled = other.getAuthClawbackEnabled();
            return !(this$authClawbackEnabled == null ? other$authClawbackEnabled != null : !((Object)this$authClawbackEnabled).equals(other$authClawbackEnabled));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $authRequired = this.getAuthRequired();
            result = result * 59 + ($authRequired == null ? 43 : ((Object)$authRequired).hashCode());
            Boolean $authRevocable = this.getAuthRevocable();
            result = result * 59 + ($authRevocable == null ? 43 : ((Object)$authRevocable).hashCode());
            Boolean $authImmutable = this.getAuthImmutable();
            result = result * 59 + ($authImmutable == null ? 43 : ((Object)$authImmutable).hashCode());
            Boolean $authClawbackEnabled = this.getAuthClawbackEnabled();
            result = result * 59 + ($authClawbackEnabled == null ? 43 : ((Object)$authClawbackEnabled).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssetResponse.Flags(authRequired=" + this.getAuthRequired() + ", authRevocable=" + this.getAuthRevocable() + ", authImmutable=" + this.getAuthImmutable() + ", authClawbackEnabled=" + this.getAuthClawbackEnabled() + ")";
        }
    }

    public static final class Links {
        @SerializedName(value="toml")
        private final Link toml;

        @Generated
        public Links(Link toml) {
            this.toml = toml;
        }

        @Generated
        public Link getToml() {
            return this.toml;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$toml = this.getToml();
            Link other$toml = other.getToml();
            return !(this$toml == null ? other$toml != null : !((Object)this$toml).equals(other$toml));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $toml = this.getToml();
            result = result * 59 + ($toml == null ? 43 : ((Object)$toml).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssetResponse.Links(toml=" + this.getToml() + ")";
        }
    }
}

