/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ContractIDPreimage;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SorobanAuthorizedInvocation;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HashIDPreimage
implements XdrElement {
    private EnvelopeType discriminant;
    private HashIDPreimageOperationID operationID;
    private HashIDPreimageRevokeID revokeID;
    private HashIDPreimageContractID contractID;
    private HashIDPreimageSorobanAuthorization sorobanAuthorization;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ENVELOPE_TYPE_OP_ID: {
                this.operationID.encode(stream);
                break;
            }
            case ENVELOPE_TYPE_POOL_REVOKE_OP_ID: {
                this.revokeID.encode(stream);
                break;
            }
            case ENVELOPE_TYPE_CONTRACT_ID: {
                this.contractID.encode(stream);
                break;
            }
            case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION: {
                this.sorobanAuthorization.encode(stream);
            }
        }
    }

    public static HashIDPreimage decode(XdrDataInputStream stream) throws IOException {
        HashIDPreimage decodedHashIDPreimage = new HashIDPreimage();
        EnvelopeType discriminant = EnvelopeType.decode(stream);
        decodedHashIDPreimage.setDiscriminant(discriminant);
        switch (decodedHashIDPreimage.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                decodedHashIDPreimage.operationID = HashIDPreimageOperationID.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_POOL_REVOKE_OP_ID: {
                decodedHashIDPreimage.revokeID = HashIDPreimageRevokeID.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_CONTRACT_ID: {
                decodedHashIDPreimage.contractID = HashIDPreimageContractID.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION: {
                decodedHashIDPreimage.sorobanAuthorization = HashIDPreimageSorobanAuthorization.decode(stream);
            }
        }
        return decodedHashIDPreimage;
    }

    public static HashIDPreimage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HashIDPreimage.fromXdrByteArray(bytes);
    }

    public static HashIDPreimage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HashIDPreimage.decode(xdrDataInputStream);
    }

    @Generated
    public static HashIDPreimageBuilder builder() {
        return new HashIDPreimageBuilder();
    }

    @Generated
    public HashIDPreimageBuilder toBuilder() {
        return new HashIDPreimageBuilder().discriminant(this.discriminant).operationID(this.operationID).revokeID(this.revokeID).contractID(this.contractID).sorobanAuthorization(this.sorobanAuthorization);
    }

    @Generated
    public EnvelopeType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public HashIDPreimageOperationID getOperationID() {
        return this.operationID;
    }

    @Generated
    public HashIDPreimageRevokeID getRevokeID() {
        return this.revokeID;
    }

    @Generated
    public HashIDPreimageContractID getContractID() {
        return this.contractID;
    }

    @Generated
    public HashIDPreimageSorobanAuthorization getSorobanAuthorization() {
        return this.sorobanAuthorization;
    }

    @Generated
    public void setDiscriminant(EnvelopeType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setOperationID(HashIDPreimageOperationID operationID) {
        this.operationID = operationID;
    }

    @Generated
    public void setRevokeID(HashIDPreimageRevokeID revokeID) {
        this.revokeID = revokeID;
    }

    @Generated
    public void setContractID(HashIDPreimageContractID contractID) {
        this.contractID = contractID;
    }

    @Generated
    public void setSorobanAuthorization(HashIDPreimageSorobanAuthorization sorobanAuthorization) {
        this.sorobanAuthorization = sorobanAuthorization;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashIDPreimage)) {
            return false;
        }
        HashIDPreimage other = (HashIDPreimage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnvelopeType this$discriminant = this.getDiscriminant();
        EnvelopeType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        HashIDPreimageOperationID this$operationID = this.getOperationID();
        HashIDPreimageOperationID other$operationID = other.getOperationID();
        if (this$operationID == null ? other$operationID != null : !((Object)this$operationID).equals(other$operationID)) {
            return false;
        }
        HashIDPreimageRevokeID this$revokeID = this.getRevokeID();
        HashIDPreimageRevokeID other$revokeID = other.getRevokeID();
        if (this$revokeID == null ? other$revokeID != null : !((Object)this$revokeID).equals(other$revokeID)) {
            return false;
        }
        HashIDPreimageContractID this$contractID = this.getContractID();
        HashIDPreimageContractID other$contractID = other.getContractID();
        if (this$contractID == null ? other$contractID != null : !((Object)this$contractID).equals(other$contractID)) {
            return false;
        }
        HashIDPreimageSorobanAuthorization this$sorobanAuthorization = this.getSorobanAuthorization();
        HashIDPreimageSorobanAuthorization other$sorobanAuthorization = other.getSorobanAuthorization();
        return !(this$sorobanAuthorization == null ? other$sorobanAuthorization != null : !((Object)this$sorobanAuthorization).equals(other$sorobanAuthorization));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HashIDPreimage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnvelopeType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        HashIDPreimageOperationID $operationID = this.getOperationID();
        result = result * 59 + ($operationID == null ? 43 : ((Object)$operationID).hashCode());
        HashIDPreimageRevokeID $revokeID = this.getRevokeID();
        result = result * 59 + ($revokeID == null ? 43 : ((Object)$revokeID).hashCode());
        HashIDPreimageContractID $contractID = this.getContractID();
        result = result * 59 + ($contractID == null ? 43 : ((Object)$contractID).hashCode());
        HashIDPreimageSorobanAuthorization $sorobanAuthorization = this.getSorobanAuthorization();
        result = result * 59 + ($sorobanAuthorization == null ? 43 : ((Object)$sorobanAuthorization).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HashIDPreimage(discriminant=" + this.getDiscriminant() + ", operationID=" + this.getOperationID() + ", revokeID=" + this.getRevokeID() + ", contractID=" + this.getContractID() + ", sorobanAuthorization=" + this.getSorobanAuthorization() + ")";
    }

    @Generated
    public HashIDPreimage() {
    }

    @Generated
    public HashIDPreimage(EnvelopeType discriminant, HashIDPreimageOperationID operationID, HashIDPreimageRevokeID revokeID, HashIDPreimageContractID contractID, HashIDPreimageSorobanAuthorization sorobanAuthorization) {
        this.discriminant = discriminant;
        this.operationID = operationID;
        this.revokeID = revokeID;
        this.contractID = contractID;
        this.sorobanAuthorization = sorobanAuthorization;
    }

    public static class HashIDPreimageOperationID
    implements XdrElement {
        private AccountID sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.sourceAccount.encode(stream);
            this.seqNum.encode(stream);
            this.opNum.encode(stream);
        }

        public static HashIDPreimageOperationID decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageOperationID decodedHashIDPreimageOperationID = new HashIDPreimageOperationID();
            decodedHashIDPreimageOperationID.sourceAccount = AccountID.decode(stream);
            decodedHashIDPreimageOperationID.seqNum = SequenceNumber.decode(stream);
            decodedHashIDPreimageOperationID.opNum = Uint32.decode(stream);
            return decodedHashIDPreimageOperationID;
        }

        public static HashIDPreimageOperationID fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageOperationID.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageOperationID fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageOperationID.decode(xdrDataInputStream);
        }

        @Generated
        public static HashIDPreimageOperationIDBuilder builder() {
            return new HashIDPreimageOperationIDBuilder();
        }

        @Generated
        public HashIDPreimageOperationIDBuilder toBuilder() {
            return new HashIDPreimageOperationIDBuilder().sourceAccount(this.sourceAccount).seqNum(this.seqNum).opNum(this.opNum);
        }

        @Generated
        public AccountID getSourceAccount() {
            return this.sourceAccount;
        }

        @Generated
        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        @Generated
        public Uint32 getOpNum() {
            return this.opNum;
        }

        @Generated
        public void setSourceAccount(AccountID sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Generated
        public void setSeqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
        }

        @Generated
        public void setOpNum(Uint32 opNum) {
            this.opNum = opNum;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashIDPreimageOperationID)) {
                return false;
            }
            HashIDPreimageOperationID other = (HashIDPreimageOperationID)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$sourceAccount = this.getSourceAccount();
            AccountID other$sourceAccount = other.getSourceAccount();
            if (this$sourceAccount == null ? other$sourceAccount != null : !((Object)this$sourceAccount).equals(other$sourceAccount)) {
                return false;
            }
            SequenceNumber this$seqNum = this.getSeqNum();
            SequenceNumber other$seqNum = other.getSeqNum();
            if (this$seqNum == null ? other$seqNum != null : !((Object)this$seqNum).equals(other$seqNum)) {
                return false;
            }
            Uint32 this$opNum = this.getOpNum();
            Uint32 other$opNum = other.getOpNum();
            return !(this$opNum == null ? other$opNum != null : !((Object)this$opNum).equals(other$opNum));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HashIDPreimageOperationID;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $sourceAccount = this.getSourceAccount();
            result = result * 59 + ($sourceAccount == null ? 43 : ((Object)$sourceAccount).hashCode());
            SequenceNumber $seqNum = this.getSeqNum();
            result = result * 59 + ($seqNum == null ? 43 : ((Object)$seqNum).hashCode());
            Uint32 $opNum = this.getOpNum();
            result = result * 59 + ($opNum == null ? 43 : ((Object)$opNum).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HashIDPreimage.HashIDPreimageOperationID(sourceAccount=" + this.getSourceAccount() + ", seqNum=" + this.getSeqNum() + ", opNum=" + this.getOpNum() + ")";
        }

        @Generated
        public HashIDPreimageOperationID() {
        }

        @Generated
        public HashIDPreimageOperationID(AccountID sourceAccount, SequenceNumber seqNum, Uint32 opNum) {
            this.sourceAccount = sourceAccount;
            this.seqNum = seqNum;
            this.opNum = opNum;
        }

        @Generated
        public static class HashIDPreimageOperationIDBuilder {
            @Generated
            private AccountID sourceAccount;
            @Generated
            private SequenceNumber seqNum;
            @Generated
            private Uint32 opNum;

            @Generated
            HashIDPreimageOperationIDBuilder() {
            }

            @Generated
            public HashIDPreimageOperationIDBuilder sourceAccount(AccountID sourceAccount) {
                this.sourceAccount = sourceAccount;
                return this;
            }

            @Generated
            public HashIDPreimageOperationIDBuilder seqNum(SequenceNumber seqNum) {
                this.seqNum = seqNum;
                return this;
            }

            @Generated
            public HashIDPreimageOperationIDBuilder opNum(Uint32 opNum) {
                this.opNum = opNum;
                return this;
            }

            @Generated
            public HashIDPreimageOperationID build() {
                return new HashIDPreimageOperationID(this.sourceAccount, this.seqNum, this.opNum);
            }

            @Generated
            public String toString() {
                return "HashIDPreimage.HashIDPreimageOperationID.HashIDPreimageOperationIDBuilder(sourceAccount=" + this.sourceAccount + ", seqNum=" + this.seqNum + ", opNum=" + this.opNum + ")";
            }
        }
    }

    public static class HashIDPreimageRevokeID
    implements XdrElement {
        private AccountID sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;
        private PoolID liquidityPoolID;
        private Asset asset;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.sourceAccount.encode(stream);
            this.seqNum.encode(stream);
            this.opNum.encode(stream);
            this.liquidityPoolID.encode(stream);
            this.asset.encode(stream);
        }

        public static HashIDPreimageRevokeID decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageRevokeID decodedHashIDPreimageRevokeID = new HashIDPreimageRevokeID();
            decodedHashIDPreimageRevokeID.sourceAccount = AccountID.decode(stream);
            decodedHashIDPreimageRevokeID.seqNum = SequenceNumber.decode(stream);
            decodedHashIDPreimageRevokeID.opNum = Uint32.decode(stream);
            decodedHashIDPreimageRevokeID.liquidityPoolID = PoolID.decode(stream);
            decodedHashIDPreimageRevokeID.asset = Asset.decode(stream);
            return decodedHashIDPreimageRevokeID;
        }

        public static HashIDPreimageRevokeID fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageRevokeID.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageRevokeID fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageRevokeID.decode(xdrDataInputStream);
        }

        @Generated
        public static HashIDPreimageRevokeIDBuilder builder() {
            return new HashIDPreimageRevokeIDBuilder();
        }

        @Generated
        public HashIDPreimageRevokeIDBuilder toBuilder() {
            return new HashIDPreimageRevokeIDBuilder().sourceAccount(this.sourceAccount).seqNum(this.seqNum).opNum(this.opNum).liquidityPoolID(this.liquidityPoolID).asset(this.asset);
        }

        @Generated
        public AccountID getSourceAccount() {
            return this.sourceAccount;
        }

        @Generated
        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        @Generated
        public Uint32 getOpNum() {
            return this.opNum;
        }

        @Generated
        public PoolID getLiquidityPoolID() {
            return this.liquidityPoolID;
        }

        @Generated
        public Asset getAsset() {
            return this.asset;
        }

        @Generated
        public void setSourceAccount(AccountID sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Generated
        public void setSeqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
        }

        @Generated
        public void setOpNum(Uint32 opNum) {
            this.opNum = opNum;
        }

        @Generated
        public void setLiquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
        }

        @Generated
        public void setAsset(Asset asset) {
            this.asset = asset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashIDPreimageRevokeID)) {
                return false;
            }
            HashIDPreimageRevokeID other = (HashIDPreimageRevokeID)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$sourceAccount = this.getSourceAccount();
            AccountID other$sourceAccount = other.getSourceAccount();
            if (this$sourceAccount == null ? other$sourceAccount != null : !((Object)this$sourceAccount).equals(other$sourceAccount)) {
                return false;
            }
            SequenceNumber this$seqNum = this.getSeqNum();
            SequenceNumber other$seqNum = other.getSeqNum();
            if (this$seqNum == null ? other$seqNum != null : !((Object)this$seqNum).equals(other$seqNum)) {
                return false;
            }
            Uint32 this$opNum = this.getOpNum();
            Uint32 other$opNum = other.getOpNum();
            if (this$opNum == null ? other$opNum != null : !((Object)this$opNum).equals(other$opNum)) {
                return false;
            }
            PoolID this$liquidityPoolID = this.getLiquidityPoolID();
            PoolID other$liquidityPoolID = other.getLiquidityPoolID();
            if (this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID)) {
                return false;
            }
            Asset this$asset = this.getAsset();
            Asset other$asset = other.getAsset();
            return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HashIDPreimageRevokeID;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $sourceAccount = this.getSourceAccount();
            result = result * 59 + ($sourceAccount == null ? 43 : ((Object)$sourceAccount).hashCode());
            SequenceNumber $seqNum = this.getSeqNum();
            result = result * 59 + ($seqNum == null ? 43 : ((Object)$seqNum).hashCode());
            Uint32 $opNum = this.getOpNum();
            result = result * 59 + ($opNum == null ? 43 : ((Object)$opNum).hashCode());
            PoolID $liquidityPoolID = this.getLiquidityPoolID();
            result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
            Asset $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HashIDPreimage.HashIDPreimageRevokeID(sourceAccount=" + this.getSourceAccount() + ", seqNum=" + this.getSeqNum() + ", opNum=" + this.getOpNum() + ", liquidityPoolID=" + this.getLiquidityPoolID() + ", asset=" + this.getAsset() + ")";
        }

        @Generated
        public HashIDPreimageRevokeID() {
        }

        @Generated
        public HashIDPreimageRevokeID(AccountID sourceAccount, SequenceNumber seqNum, Uint32 opNum, PoolID liquidityPoolID, Asset asset) {
            this.sourceAccount = sourceAccount;
            this.seqNum = seqNum;
            this.opNum = opNum;
            this.liquidityPoolID = liquidityPoolID;
            this.asset = asset;
        }

        @Generated
        public static class HashIDPreimageRevokeIDBuilder {
            @Generated
            private AccountID sourceAccount;
            @Generated
            private SequenceNumber seqNum;
            @Generated
            private Uint32 opNum;
            @Generated
            private PoolID liquidityPoolID;
            @Generated
            private Asset asset;

            @Generated
            HashIDPreimageRevokeIDBuilder() {
            }

            @Generated
            public HashIDPreimageRevokeIDBuilder sourceAccount(AccountID sourceAccount) {
                this.sourceAccount = sourceAccount;
                return this;
            }

            @Generated
            public HashIDPreimageRevokeIDBuilder seqNum(SequenceNumber seqNum) {
                this.seqNum = seqNum;
                return this;
            }

            @Generated
            public HashIDPreimageRevokeIDBuilder opNum(Uint32 opNum) {
                this.opNum = opNum;
                return this;
            }

            @Generated
            public HashIDPreimageRevokeIDBuilder liquidityPoolID(PoolID liquidityPoolID) {
                this.liquidityPoolID = liquidityPoolID;
                return this;
            }

            @Generated
            public HashIDPreimageRevokeIDBuilder asset(Asset asset) {
                this.asset = asset;
                return this;
            }

            @Generated
            public HashIDPreimageRevokeID build() {
                return new HashIDPreimageRevokeID(this.sourceAccount, this.seqNum, this.opNum, this.liquidityPoolID, this.asset);
            }

            @Generated
            public String toString() {
                return "HashIDPreimage.HashIDPreimageRevokeID.HashIDPreimageRevokeIDBuilder(sourceAccount=" + this.sourceAccount + ", seqNum=" + this.seqNum + ", opNum=" + this.opNum + ", liquidityPoolID=" + this.liquidityPoolID + ", asset=" + this.asset + ")";
            }
        }
    }

    public static class HashIDPreimageContractID
    implements XdrElement {
        private Hash networkID;
        private ContractIDPreimage contractIDPreimage;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.networkID.encode(stream);
            this.contractIDPreimage.encode(stream);
        }

        public static HashIDPreimageContractID decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageContractID decodedHashIDPreimageContractID = new HashIDPreimageContractID();
            decodedHashIDPreimageContractID.networkID = Hash.decode(stream);
            decodedHashIDPreimageContractID.contractIDPreimage = ContractIDPreimage.decode(stream);
            return decodedHashIDPreimageContractID;
        }

        public static HashIDPreimageContractID fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageContractID.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageContractID fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageContractID.decode(xdrDataInputStream);
        }

        @Generated
        public static HashIDPreimageContractIDBuilder builder() {
            return new HashIDPreimageContractIDBuilder();
        }

        @Generated
        public HashIDPreimageContractIDBuilder toBuilder() {
            return new HashIDPreimageContractIDBuilder().networkID(this.networkID).contractIDPreimage(this.contractIDPreimage);
        }

        @Generated
        public Hash getNetworkID() {
            return this.networkID;
        }

        @Generated
        public ContractIDPreimage getContractIDPreimage() {
            return this.contractIDPreimage;
        }

        @Generated
        public void setNetworkID(Hash networkID) {
            this.networkID = networkID;
        }

        @Generated
        public void setContractIDPreimage(ContractIDPreimage contractIDPreimage) {
            this.contractIDPreimage = contractIDPreimage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashIDPreimageContractID)) {
                return false;
            }
            HashIDPreimageContractID other = (HashIDPreimageContractID)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Hash this$networkID = this.getNetworkID();
            Hash other$networkID = other.getNetworkID();
            if (this$networkID == null ? other$networkID != null : !((Object)this$networkID).equals(other$networkID)) {
                return false;
            }
            ContractIDPreimage this$contractIDPreimage = this.getContractIDPreimage();
            ContractIDPreimage other$contractIDPreimage = other.getContractIDPreimage();
            return !(this$contractIDPreimage == null ? other$contractIDPreimage != null : !((Object)this$contractIDPreimage).equals(other$contractIDPreimage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HashIDPreimageContractID;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Hash $networkID = this.getNetworkID();
            result = result * 59 + ($networkID == null ? 43 : ((Object)$networkID).hashCode());
            ContractIDPreimage $contractIDPreimage = this.getContractIDPreimage();
            result = result * 59 + ($contractIDPreimage == null ? 43 : ((Object)$contractIDPreimage).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HashIDPreimage.HashIDPreimageContractID(networkID=" + this.getNetworkID() + ", contractIDPreimage=" + this.getContractIDPreimage() + ")";
        }

        @Generated
        public HashIDPreimageContractID() {
        }

        @Generated
        public HashIDPreimageContractID(Hash networkID, ContractIDPreimage contractIDPreimage) {
            this.networkID = networkID;
            this.contractIDPreimage = contractIDPreimage;
        }

        @Generated
        public static class HashIDPreimageContractIDBuilder {
            @Generated
            private Hash networkID;
            @Generated
            private ContractIDPreimage contractIDPreimage;

            @Generated
            HashIDPreimageContractIDBuilder() {
            }

            @Generated
            public HashIDPreimageContractIDBuilder networkID(Hash networkID) {
                this.networkID = networkID;
                return this;
            }

            @Generated
            public HashIDPreimageContractIDBuilder contractIDPreimage(ContractIDPreimage contractIDPreimage) {
                this.contractIDPreimage = contractIDPreimage;
                return this;
            }

            @Generated
            public HashIDPreimageContractID build() {
                return new HashIDPreimageContractID(this.networkID, this.contractIDPreimage);
            }

            @Generated
            public String toString() {
                return "HashIDPreimage.HashIDPreimageContractID.HashIDPreimageContractIDBuilder(networkID=" + this.networkID + ", contractIDPreimage=" + this.contractIDPreimage + ")";
            }
        }
    }

    public static class HashIDPreimageSorobanAuthorization
    implements XdrElement {
        private Hash networkID;
        private Int64 nonce;
        private Uint32 signatureExpirationLedger;
        private SorobanAuthorizedInvocation invocation;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.networkID.encode(stream);
            this.nonce.encode(stream);
            this.signatureExpirationLedger.encode(stream);
            this.invocation.encode(stream);
        }

        public static HashIDPreimageSorobanAuthorization decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageSorobanAuthorization decodedHashIDPreimageSorobanAuthorization = new HashIDPreimageSorobanAuthorization();
            decodedHashIDPreimageSorobanAuthorization.networkID = Hash.decode(stream);
            decodedHashIDPreimageSorobanAuthorization.nonce = Int64.decode(stream);
            decodedHashIDPreimageSorobanAuthorization.signatureExpirationLedger = Uint32.decode(stream);
            decodedHashIDPreimageSorobanAuthorization.invocation = SorobanAuthorizedInvocation.decode(stream);
            return decodedHashIDPreimageSorobanAuthorization;
        }

        public static HashIDPreimageSorobanAuthorization fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageSorobanAuthorization.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageSorobanAuthorization fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageSorobanAuthorization.decode(xdrDataInputStream);
        }

        @Generated
        public static HashIDPreimageSorobanAuthorizationBuilder builder() {
            return new HashIDPreimageSorobanAuthorizationBuilder();
        }

        @Generated
        public HashIDPreimageSorobanAuthorizationBuilder toBuilder() {
            return new HashIDPreimageSorobanAuthorizationBuilder().networkID(this.networkID).nonce(this.nonce).signatureExpirationLedger(this.signatureExpirationLedger).invocation(this.invocation);
        }

        @Generated
        public Hash getNetworkID() {
            return this.networkID;
        }

        @Generated
        public Int64 getNonce() {
            return this.nonce;
        }

        @Generated
        public Uint32 getSignatureExpirationLedger() {
            return this.signatureExpirationLedger;
        }

        @Generated
        public SorobanAuthorizedInvocation getInvocation() {
            return this.invocation;
        }

        @Generated
        public void setNetworkID(Hash networkID) {
            this.networkID = networkID;
        }

        @Generated
        public void setNonce(Int64 nonce) {
            this.nonce = nonce;
        }

        @Generated
        public void setSignatureExpirationLedger(Uint32 signatureExpirationLedger) {
            this.signatureExpirationLedger = signatureExpirationLedger;
        }

        @Generated
        public void setInvocation(SorobanAuthorizedInvocation invocation) {
            this.invocation = invocation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashIDPreimageSorobanAuthorization)) {
                return false;
            }
            HashIDPreimageSorobanAuthorization other = (HashIDPreimageSorobanAuthorization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Hash this$networkID = this.getNetworkID();
            Hash other$networkID = other.getNetworkID();
            if (this$networkID == null ? other$networkID != null : !((Object)this$networkID).equals(other$networkID)) {
                return false;
            }
            Int64 this$nonce = this.getNonce();
            Int64 other$nonce = other.getNonce();
            if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
                return false;
            }
            Uint32 this$signatureExpirationLedger = this.getSignatureExpirationLedger();
            Uint32 other$signatureExpirationLedger = other.getSignatureExpirationLedger();
            if (this$signatureExpirationLedger == null ? other$signatureExpirationLedger != null : !((Object)this$signatureExpirationLedger).equals(other$signatureExpirationLedger)) {
                return false;
            }
            SorobanAuthorizedInvocation this$invocation = this.getInvocation();
            SorobanAuthorizedInvocation other$invocation = other.getInvocation();
            return !(this$invocation == null ? other$invocation != null : !((Object)this$invocation).equals(other$invocation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HashIDPreimageSorobanAuthorization;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Hash $networkID = this.getNetworkID();
            result = result * 59 + ($networkID == null ? 43 : ((Object)$networkID).hashCode());
            Int64 $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
            Uint32 $signatureExpirationLedger = this.getSignatureExpirationLedger();
            result = result * 59 + ($signatureExpirationLedger == null ? 43 : ((Object)$signatureExpirationLedger).hashCode());
            SorobanAuthorizedInvocation $invocation = this.getInvocation();
            result = result * 59 + ($invocation == null ? 43 : ((Object)$invocation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HashIDPreimage.HashIDPreimageSorobanAuthorization(networkID=" + this.getNetworkID() + ", nonce=" + this.getNonce() + ", signatureExpirationLedger=" + this.getSignatureExpirationLedger() + ", invocation=" + this.getInvocation() + ")";
        }

        @Generated
        public HashIDPreimageSorobanAuthorization() {
        }

        @Generated
        public HashIDPreimageSorobanAuthorization(Hash networkID, Int64 nonce, Uint32 signatureExpirationLedger, SorobanAuthorizedInvocation invocation) {
            this.networkID = networkID;
            this.nonce = nonce;
            this.signatureExpirationLedger = signatureExpirationLedger;
            this.invocation = invocation;
        }

        @Generated
        public static class HashIDPreimageSorobanAuthorizationBuilder {
            @Generated
            private Hash networkID;
            @Generated
            private Int64 nonce;
            @Generated
            private Uint32 signatureExpirationLedger;
            @Generated
            private SorobanAuthorizedInvocation invocation;

            @Generated
            HashIDPreimageSorobanAuthorizationBuilder() {
            }

            @Generated
            public HashIDPreimageSorobanAuthorizationBuilder networkID(Hash networkID) {
                this.networkID = networkID;
                return this;
            }

            @Generated
            public HashIDPreimageSorobanAuthorizationBuilder nonce(Int64 nonce) {
                this.nonce = nonce;
                return this;
            }

            @Generated
            public HashIDPreimageSorobanAuthorizationBuilder signatureExpirationLedger(Uint32 signatureExpirationLedger) {
                this.signatureExpirationLedger = signatureExpirationLedger;
                return this;
            }

            @Generated
            public HashIDPreimageSorobanAuthorizationBuilder invocation(SorobanAuthorizedInvocation invocation) {
                this.invocation = invocation;
                return this;
            }

            @Generated
            public HashIDPreimageSorobanAuthorization build() {
                return new HashIDPreimageSorobanAuthorization(this.networkID, this.nonce, this.signatureExpirationLedger, this.invocation);
            }

            @Generated
            public String toString() {
                return "HashIDPreimage.HashIDPreimageSorobanAuthorization.HashIDPreimageSorobanAuthorizationBuilder(networkID=" + this.networkID + ", nonce=" + this.nonce + ", signatureExpirationLedger=" + this.signatureExpirationLedger + ", invocation=" + this.invocation + ")";
            }
        }
    }

    @Generated
    public static class HashIDPreimageBuilder {
        @Generated
        private EnvelopeType discriminant;
        @Generated
        private HashIDPreimageOperationID operationID;
        @Generated
        private HashIDPreimageRevokeID revokeID;
        @Generated
        private HashIDPreimageContractID contractID;
        @Generated
        private HashIDPreimageSorobanAuthorization sorobanAuthorization;

        @Generated
        HashIDPreimageBuilder() {
        }

        @Generated
        public HashIDPreimageBuilder discriminant(EnvelopeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public HashIDPreimageBuilder operationID(HashIDPreimageOperationID operationID) {
            this.operationID = operationID;
            return this;
        }

        @Generated
        public HashIDPreimageBuilder revokeID(HashIDPreimageRevokeID revokeID) {
            this.revokeID = revokeID;
            return this;
        }

        @Generated
        public HashIDPreimageBuilder contractID(HashIDPreimageContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        @Generated
        public HashIDPreimageBuilder sorobanAuthorization(HashIDPreimageSorobanAuthorization sorobanAuthorization) {
            this.sorobanAuthorization = sorobanAuthorization;
            return this;
        }

        @Generated
        public HashIDPreimage build() {
            return new HashIDPreimage(this.discriminant, this.operationID, this.revokeID, this.contractID, this.sorobanAuthorization);
        }

        @Generated
        public String toString() {
            return "HashIDPreimage.HashIDPreimageBuilder(discriminant=" + this.discriminant + ", operationID=" + this.operationID + ", revokeID=" + this.revokeID + ", contractID=" + this.contractID + ", sorobanAuthorization=" + this.sorobanAuthorization + ")";
        }
    }
}

