/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerCloseMeta;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseMetaBatch
implements XdrElement {
    private Uint32 startSequence;
    private Uint32 endSequence;
    private LedgerCloseMeta[] ledgerCloseMetas;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.startSequence.encode(stream);
        this.endSequence.encode(stream);
        int ledgerCloseMetasSize = this.getLedgerCloseMetas().length;
        stream.writeInt(ledgerCloseMetasSize);
        for (int i = 0; i < ledgerCloseMetasSize; ++i) {
            this.ledgerCloseMetas[i].encode(stream);
        }
    }

    public static LedgerCloseMetaBatch decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMetaBatch decodedLedgerCloseMetaBatch = new LedgerCloseMetaBatch();
        decodedLedgerCloseMetaBatch.startSequence = Uint32.decode(stream);
        decodedLedgerCloseMetaBatch.endSequence = Uint32.decode(stream);
        int ledgerCloseMetasSize = stream.readInt();
        decodedLedgerCloseMetaBatch.ledgerCloseMetas = new LedgerCloseMeta[ledgerCloseMetasSize];
        for (int i = 0; i < ledgerCloseMetasSize; ++i) {
            decodedLedgerCloseMetaBatch.ledgerCloseMetas[i] = LedgerCloseMeta.decode(stream);
        }
        return decodedLedgerCloseMetaBatch;
    }

    public static LedgerCloseMetaBatch fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseMetaBatch.fromXdrByteArray(bytes);
    }

    public static LedgerCloseMetaBatch fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseMetaBatch.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerCloseMetaBatchBuilder builder() {
        return new LedgerCloseMetaBatchBuilder();
    }

    @Generated
    public LedgerCloseMetaBatchBuilder toBuilder() {
        return new LedgerCloseMetaBatchBuilder().startSequence(this.startSequence).endSequence(this.endSequence).ledgerCloseMetas(this.ledgerCloseMetas);
    }

    @Generated
    public Uint32 getStartSequence() {
        return this.startSequence;
    }

    @Generated
    public Uint32 getEndSequence() {
        return this.endSequence;
    }

    @Generated
    public LedgerCloseMeta[] getLedgerCloseMetas() {
        return this.ledgerCloseMetas;
    }

    @Generated
    public void setStartSequence(Uint32 startSequence) {
        this.startSequence = startSequence;
    }

    @Generated
    public void setEndSequence(Uint32 endSequence) {
        this.endSequence = endSequence;
    }

    @Generated
    public void setLedgerCloseMetas(LedgerCloseMeta[] ledgerCloseMetas) {
        this.ledgerCloseMetas = ledgerCloseMetas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerCloseMetaBatch)) {
            return false;
        }
        LedgerCloseMetaBatch other = (LedgerCloseMetaBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$startSequence = this.getStartSequence();
        Uint32 other$startSequence = other.getStartSequence();
        if (this$startSequence == null ? other$startSequence != null : !((Object)this$startSequence).equals(other$startSequence)) {
            return false;
        }
        Uint32 this$endSequence = this.getEndSequence();
        Uint32 other$endSequence = other.getEndSequence();
        if (this$endSequence == null ? other$endSequence != null : !((Object)this$endSequence).equals(other$endSequence)) {
            return false;
        }
        return Arrays.deepEquals(this.getLedgerCloseMetas(), other.getLedgerCloseMetas());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerCloseMetaBatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $startSequence = this.getStartSequence();
        result = result * 59 + ($startSequence == null ? 43 : ((Object)$startSequence).hashCode());
        Uint32 $endSequence = this.getEndSequence();
        result = result * 59 + ($endSequence == null ? 43 : ((Object)$endSequence).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLedgerCloseMetas());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerCloseMetaBatch(startSequence=" + this.getStartSequence() + ", endSequence=" + this.getEndSequence() + ", ledgerCloseMetas=" + Arrays.deepToString(this.getLedgerCloseMetas()) + ")";
    }

    @Generated
    public LedgerCloseMetaBatch() {
    }

    @Generated
    public LedgerCloseMetaBatch(Uint32 startSequence, Uint32 endSequence, LedgerCloseMeta[] ledgerCloseMetas) {
        this.startSequence = startSequence;
        this.endSequence = endSequence;
        this.ledgerCloseMetas = ledgerCloseMetas;
    }

    @Generated
    public static class LedgerCloseMetaBatchBuilder {
        @Generated
        private Uint32 startSequence;
        @Generated
        private Uint32 endSequence;
        @Generated
        private LedgerCloseMeta[] ledgerCloseMetas;

        @Generated
        LedgerCloseMetaBatchBuilder() {
        }

        @Generated
        public LedgerCloseMetaBatchBuilder startSequence(Uint32 startSequence) {
            this.startSequence = startSequence;
            return this;
        }

        @Generated
        public LedgerCloseMetaBatchBuilder endSequence(Uint32 endSequence) {
            this.endSequence = endSequence;
            return this;
        }

        @Generated
        public LedgerCloseMetaBatchBuilder ledgerCloseMetas(LedgerCloseMeta[] ledgerCloseMetas) {
            this.ledgerCloseMetas = ledgerCloseMetas;
            return this;
        }

        @Generated
        public LedgerCloseMetaBatch build() {
            return new LedgerCloseMetaBatch(this.startSequence, this.endSequence, this.ledgerCloseMetas);
        }

        @Generated
        public String toString() {
            return "LedgerCloseMetaBatch.LedgerCloseMetaBatchBuilder(startSequence=" + this.startSequence + ", endSequence=" + this.endSequence + ", ledgerCloseMetas=" + Arrays.deepToString(this.ledgerCloseMetas) + ")";
        }
    }
}

