/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecType;
import org.stellar.sdk.xdr.SCSpecTypeBytesN;
import org.stellar.sdk.xdr.SCSpecTypeMap;
import org.stellar.sdk.xdr.SCSpecTypeOption;
import org.stellar.sdk.xdr.SCSpecTypeResult;
import org.stellar.sdk.xdr.SCSpecTypeTuple;
import org.stellar.sdk.xdr.SCSpecTypeUDT;
import org.stellar.sdk.xdr.SCSpecTypeVec;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCSpecTypeDef
implements XdrElement {
    private SCSpecType discriminant;
    private SCSpecTypeOption option;
    private SCSpecTypeResult result;
    private SCSpecTypeVec vec;
    private SCSpecTypeMap map;
    private SCSpecTypeTuple tuple;
    private SCSpecTypeBytesN bytesN;
    private SCSpecTypeUDT udt;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SC_SPEC_TYPE_VAL: 
            case SC_SPEC_TYPE_BOOL: 
            case SC_SPEC_TYPE_VOID: 
            case SC_SPEC_TYPE_ERROR: 
            case SC_SPEC_TYPE_U32: 
            case SC_SPEC_TYPE_I32: 
            case SC_SPEC_TYPE_U64: 
            case SC_SPEC_TYPE_I64: 
            case SC_SPEC_TYPE_TIMEPOINT: 
            case SC_SPEC_TYPE_DURATION: 
            case SC_SPEC_TYPE_U128: 
            case SC_SPEC_TYPE_I128: 
            case SC_SPEC_TYPE_U256: 
            case SC_SPEC_TYPE_I256: 
            case SC_SPEC_TYPE_BYTES: 
            case SC_SPEC_TYPE_STRING: 
            case SC_SPEC_TYPE_SYMBOL: 
            case SC_SPEC_TYPE_ADDRESS: 
            case SC_SPEC_TYPE_MUXED_ADDRESS: {
                break;
            }
            case SC_SPEC_TYPE_OPTION: {
                this.option.encode(stream);
                break;
            }
            case SC_SPEC_TYPE_RESULT: {
                this.result.encode(stream);
                break;
            }
            case SC_SPEC_TYPE_VEC: {
                this.vec.encode(stream);
                break;
            }
            case SC_SPEC_TYPE_MAP: {
                this.map.encode(stream);
                break;
            }
            case SC_SPEC_TYPE_TUPLE: {
                this.tuple.encode(stream);
                break;
            }
            case SC_SPEC_TYPE_BYTES_N: {
                this.bytesN.encode(stream);
                break;
            }
            case SC_SPEC_TYPE_UDT: {
                this.udt.encode(stream);
            }
        }
    }

    public static SCSpecTypeDef decode(XdrDataInputStream stream) throws IOException {
        SCSpecTypeDef decodedSCSpecTypeDef = new SCSpecTypeDef();
        SCSpecType discriminant = SCSpecType.decode(stream);
        decodedSCSpecTypeDef.setDiscriminant(discriminant);
        switch (decodedSCSpecTypeDef.getDiscriminant()) {
            case SC_SPEC_TYPE_VAL: 
            case SC_SPEC_TYPE_BOOL: 
            case SC_SPEC_TYPE_VOID: 
            case SC_SPEC_TYPE_ERROR: 
            case SC_SPEC_TYPE_U32: 
            case SC_SPEC_TYPE_I32: 
            case SC_SPEC_TYPE_U64: 
            case SC_SPEC_TYPE_I64: 
            case SC_SPEC_TYPE_TIMEPOINT: 
            case SC_SPEC_TYPE_DURATION: 
            case SC_SPEC_TYPE_U128: 
            case SC_SPEC_TYPE_I128: 
            case SC_SPEC_TYPE_U256: 
            case SC_SPEC_TYPE_I256: 
            case SC_SPEC_TYPE_BYTES: 
            case SC_SPEC_TYPE_STRING: 
            case SC_SPEC_TYPE_SYMBOL: 
            case SC_SPEC_TYPE_ADDRESS: 
            case SC_SPEC_TYPE_MUXED_ADDRESS: {
                break;
            }
            case SC_SPEC_TYPE_OPTION: {
                decodedSCSpecTypeDef.option = SCSpecTypeOption.decode(stream);
                break;
            }
            case SC_SPEC_TYPE_RESULT: {
                decodedSCSpecTypeDef.result = SCSpecTypeResult.decode(stream);
                break;
            }
            case SC_SPEC_TYPE_VEC: {
                decodedSCSpecTypeDef.vec = SCSpecTypeVec.decode(stream);
                break;
            }
            case SC_SPEC_TYPE_MAP: {
                decodedSCSpecTypeDef.map = SCSpecTypeMap.decode(stream);
                break;
            }
            case SC_SPEC_TYPE_TUPLE: {
                decodedSCSpecTypeDef.tuple = SCSpecTypeTuple.decode(stream);
                break;
            }
            case SC_SPEC_TYPE_BYTES_N: {
                decodedSCSpecTypeDef.bytesN = SCSpecTypeBytesN.decode(stream);
                break;
            }
            case SC_SPEC_TYPE_UDT: {
                decodedSCSpecTypeDef.udt = SCSpecTypeUDT.decode(stream);
            }
        }
        return decodedSCSpecTypeDef;
    }

    public static SCSpecTypeDef fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecTypeDef.fromXdrByteArray(bytes);
    }

    public static SCSpecTypeDef fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecTypeDef.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecTypeDefBuilder builder() {
        return new SCSpecTypeDefBuilder();
    }

    @Generated
    public SCSpecTypeDefBuilder toBuilder() {
        return new SCSpecTypeDefBuilder().discriminant(this.discriminant).option(this.option).result(this.result).vec(this.vec).map(this.map).tuple(this.tuple).bytesN(this.bytesN).udt(this.udt);
    }

    @Generated
    public SCSpecType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public SCSpecTypeOption getOption() {
        return this.option;
    }

    @Generated
    public SCSpecTypeResult getResult() {
        return this.result;
    }

    @Generated
    public SCSpecTypeVec getVec() {
        return this.vec;
    }

    @Generated
    public SCSpecTypeMap getMap() {
        return this.map;
    }

    @Generated
    public SCSpecTypeTuple getTuple() {
        return this.tuple;
    }

    @Generated
    public SCSpecTypeBytesN getBytesN() {
        return this.bytesN;
    }

    @Generated
    public SCSpecTypeUDT getUdt() {
        return this.udt;
    }

    @Generated
    public void setDiscriminant(SCSpecType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setOption(SCSpecTypeOption option) {
        this.option = option;
    }

    @Generated
    public void setResult(SCSpecTypeResult result) {
        this.result = result;
    }

    @Generated
    public void setVec(SCSpecTypeVec vec) {
        this.vec = vec;
    }

    @Generated
    public void setMap(SCSpecTypeMap map) {
        this.map = map;
    }

    @Generated
    public void setTuple(SCSpecTypeTuple tuple) {
        this.tuple = tuple;
    }

    @Generated
    public void setBytesN(SCSpecTypeBytesN bytesN) {
        this.bytesN = bytesN;
    }

    @Generated
    public void setUdt(SCSpecTypeUDT udt) {
        this.udt = udt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecTypeDef)) {
            return false;
        }
        SCSpecTypeDef other = (SCSpecTypeDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCSpecType this$discriminant = this.getDiscriminant();
        SCSpecType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        SCSpecTypeOption this$option = this.getOption();
        SCSpecTypeOption other$option = other.getOption();
        if (this$option == null ? other$option != null : !((Object)this$option).equals(other$option)) {
            return false;
        }
        SCSpecTypeResult this$result = this.getResult();
        SCSpecTypeResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        SCSpecTypeVec this$vec = this.getVec();
        SCSpecTypeVec other$vec = other.getVec();
        if (this$vec == null ? other$vec != null : !((Object)this$vec).equals(other$vec)) {
            return false;
        }
        SCSpecTypeMap this$map = this.getMap();
        SCSpecTypeMap other$map = other.getMap();
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        SCSpecTypeTuple this$tuple = this.getTuple();
        SCSpecTypeTuple other$tuple = other.getTuple();
        if (this$tuple == null ? other$tuple != null : !((Object)this$tuple).equals(other$tuple)) {
            return false;
        }
        SCSpecTypeBytesN this$bytesN = this.getBytesN();
        SCSpecTypeBytesN other$bytesN = other.getBytesN();
        if (this$bytesN == null ? other$bytesN != null : !((Object)this$bytesN).equals(other$bytesN)) {
            return false;
        }
        SCSpecTypeUDT this$udt = this.getUdt();
        SCSpecTypeUDT other$udt = other.getUdt();
        return !(this$udt == null ? other$udt != null : !((Object)this$udt).equals(other$udt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecTypeDef;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCSpecType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        SCSpecTypeOption $option = this.getOption();
        result = result * 59 + ($option == null ? 43 : ((Object)$option).hashCode());
        SCSpecTypeResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        SCSpecTypeVec $vec = this.getVec();
        result = result * 59 + ($vec == null ? 43 : ((Object)$vec).hashCode());
        SCSpecTypeMap $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        SCSpecTypeTuple $tuple = this.getTuple();
        result = result * 59 + ($tuple == null ? 43 : ((Object)$tuple).hashCode());
        SCSpecTypeBytesN $bytesN = this.getBytesN();
        result = result * 59 + ($bytesN == null ? 43 : ((Object)$bytesN).hashCode());
        SCSpecTypeUDT $udt = this.getUdt();
        result = result * 59 + ($udt == null ? 43 : ((Object)$udt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecTypeDef(discriminant=" + this.getDiscriminant() + ", option=" + this.getOption() + ", result=" + this.getResult() + ", vec=" + this.getVec() + ", map=" + this.getMap() + ", tuple=" + this.getTuple() + ", bytesN=" + this.getBytesN() + ", udt=" + this.getUdt() + ")";
    }

    @Generated
    public SCSpecTypeDef() {
    }

    @Generated
    public SCSpecTypeDef(SCSpecType discriminant, SCSpecTypeOption option, SCSpecTypeResult result, SCSpecTypeVec vec, SCSpecTypeMap map, SCSpecTypeTuple tuple, SCSpecTypeBytesN bytesN, SCSpecTypeUDT udt) {
        this.discriminant = discriminant;
        this.option = option;
        this.result = result;
        this.vec = vec;
        this.map = map;
        this.tuple = tuple;
        this.bytesN = bytesN;
        this.udt = udt;
    }

    @Generated
    public static class SCSpecTypeDefBuilder {
        @Generated
        private SCSpecType discriminant;
        @Generated
        private SCSpecTypeOption option;
        @Generated
        private SCSpecTypeResult result;
        @Generated
        private SCSpecTypeVec vec;
        @Generated
        private SCSpecTypeMap map;
        @Generated
        private SCSpecTypeTuple tuple;
        @Generated
        private SCSpecTypeBytesN bytesN;
        @Generated
        private SCSpecTypeUDT udt;

        @Generated
        SCSpecTypeDefBuilder() {
        }

        @Generated
        public SCSpecTypeDefBuilder discriminant(SCSpecType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder option(SCSpecTypeOption option) {
            this.option = option;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder result(SCSpecTypeResult result) {
            this.result = result;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder vec(SCSpecTypeVec vec) {
            this.vec = vec;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder map(SCSpecTypeMap map) {
            this.map = map;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder tuple(SCSpecTypeTuple tuple) {
            this.tuple = tuple;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder bytesN(SCSpecTypeBytesN bytesN) {
            this.bytesN = bytesN;
            return this;
        }

        @Generated
        public SCSpecTypeDefBuilder udt(SCSpecTypeUDT udt) {
            this.udt = udt;
            return this;
        }

        @Generated
        public SCSpecTypeDef build() {
            return new SCSpecTypeDef(this.discriminant, this.option, this.result, this.vec, this.map, this.tuple, this.bytesN, this.udt);
        }

        @Generated
        public String toString() {
            return "SCSpecTypeDef.SCSpecTypeDefBuilder(discriminant=" + this.discriminant + ", option=" + this.option + ", result=" + this.result + ", vec=" + this.vec + ", map=" + this.map + ", tuple=" + this.tuple + ", bytesN=" + this.bytesN + ", udt=" + this.udt + ")";
        }
    }
}

