/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.GeneralizedTransactionSet;
import org.stellar.sdk.xdr.TransactionSet;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class StoredTransactionSet
implements XdrElement {
    private Integer discriminant;
    private TransactionSet txSet;
    private GeneralizedTransactionSet generalizedTxSet;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant);
        switch (this.discriminant) {
            case 0: {
                this.txSet.encode(stream);
                break;
            }
            case 1: {
                this.generalizedTxSet.encode(stream);
            }
        }
    }

    public static StoredTransactionSet decode(XdrDataInputStream stream) throws IOException {
        StoredTransactionSet decodedStoredTransactionSet = new StoredTransactionSet();
        Integer discriminant = stream.readInt();
        decodedStoredTransactionSet.setDiscriminant(discriminant);
        switch (decodedStoredTransactionSet.getDiscriminant()) {
            case 0: {
                decodedStoredTransactionSet.txSet = TransactionSet.decode(stream);
                break;
            }
            case 1: {
                decodedStoredTransactionSet.generalizedTxSet = GeneralizedTransactionSet.decode(stream);
            }
        }
        return decodedStoredTransactionSet;
    }

    public static StoredTransactionSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return StoredTransactionSet.fromXdrByteArray(bytes);
    }

    public static StoredTransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return StoredTransactionSet.decode(xdrDataInputStream);
    }

    @Generated
    public static StoredTransactionSetBuilder builder() {
        return new StoredTransactionSetBuilder();
    }

    @Generated
    public StoredTransactionSetBuilder toBuilder() {
        return new StoredTransactionSetBuilder().discriminant(this.discriminant).txSet(this.txSet).generalizedTxSet(this.generalizedTxSet);
    }

    @Generated
    public Integer getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public TransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public GeneralizedTransactionSet getGeneralizedTxSet() {
        return this.generalizedTxSet;
    }

    @Generated
    public void setDiscriminant(Integer discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setTxSet(TransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setGeneralizedTxSet(GeneralizedTransactionSet generalizedTxSet) {
        this.generalizedTxSet = generalizedTxSet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoredTransactionSet)) {
            return false;
        }
        StoredTransactionSet other = (StoredTransactionSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$discriminant = this.getDiscriminant();
        Integer other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
            return false;
        }
        TransactionSet this$txSet = this.getTxSet();
        TransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        GeneralizedTransactionSet this$generalizedTxSet = this.getGeneralizedTxSet();
        GeneralizedTransactionSet other$generalizedTxSet = other.getGeneralizedTxSet();
        return !(this$generalizedTxSet == null ? other$generalizedTxSet != null : !((Object)this$generalizedTxSet).equals(other$generalizedTxSet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StoredTransactionSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
        TransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        GeneralizedTransactionSet $generalizedTxSet = this.getGeneralizedTxSet();
        result = result * 59 + ($generalizedTxSet == null ? 43 : ((Object)$generalizedTxSet).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StoredTransactionSet(discriminant=" + this.getDiscriminant() + ", txSet=" + this.getTxSet() + ", generalizedTxSet=" + this.getGeneralizedTxSet() + ")";
    }

    @Generated
    public StoredTransactionSet() {
    }

    @Generated
    public StoredTransactionSet(Integer discriminant, TransactionSet txSet, GeneralizedTransactionSet generalizedTxSet) {
        this.discriminant = discriminant;
        this.txSet = txSet;
        this.generalizedTxSet = generalizedTxSet;
    }

    @Generated
    public static class StoredTransactionSetBuilder {
        @Generated
        private Integer discriminant;
        @Generated
        private TransactionSet txSet;
        @Generated
        private GeneralizedTransactionSet generalizedTxSet;

        @Generated
        StoredTransactionSetBuilder() {
        }

        @Generated
        public StoredTransactionSetBuilder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public StoredTransactionSetBuilder txSet(TransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public StoredTransactionSetBuilder generalizedTxSet(GeneralizedTransactionSet generalizedTxSet) {
            this.generalizedTxSet = generalizedTxSet;
            return this;
        }

        @Generated
        public StoredTransactionSet build() {
            return new StoredTransactionSet(this.discriminant, this.txSet, this.generalizedTxSet);
        }

        @Generated
        public String toString() {
            return "StoredTransactionSet.StoredTransactionSetBuilder(discriminant=" + this.discriminant + ", txSet=" + this.txSet + ", generalizedTxSet=" + this.generalizedTxSet + ")";
        }
    }
}

