/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Memo;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionV0
implements XdrElement {
    private Uint256 sourceAccountEd25519;
    private Uint32 fee;
    private SequenceNumber seqNum;
    private TimeBounds timeBounds;
    private Memo memo;
    private Operation[] operations;
    private TransactionV0Ext ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.sourceAccountEd25519.encode(stream);
        this.fee.encode(stream);
        this.seqNum.encode(stream);
        if (this.timeBounds != null) {
            stream.writeInt(1);
            this.timeBounds.encode(stream);
        } else {
            stream.writeInt(0);
        }
        this.memo.encode(stream);
        int operationsSize = this.getOperations().length;
        stream.writeInt(operationsSize);
        for (int i = 0; i < operationsSize; ++i) {
            this.operations[i].encode(stream);
        }
        this.ext.encode(stream);
    }

    public static TransactionV0 decode(XdrDataInputStream stream) throws IOException {
        TransactionV0 decodedTransactionV0 = new TransactionV0();
        decodedTransactionV0.sourceAccountEd25519 = Uint256.decode(stream);
        decodedTransactionV0.fee = Uint32.decode(stream);
        decodedTransactionV0.seqNum = SequenceNumber.decode(stream);
        int timeBoundsPresent = stream.readInt();
        if (timeBoundsPresent != 0) {
            decodedTransactionV0.timeBounds = TimeBounds.decode(stream);
        }
        decodedTransactionV0.memo = Memo.decode(stream);
        int operationsSize = stream.readInt();
        decodedTransactionV0.operations = new Operation[operationsSize];
        for (int i = 0; i < operationsSize; ++i) {
            decodedTransactionV0.operations[i] = Operation.decode(stream);
        }
        decodedTransactionV0.ext = TransactionV0Ext.decode(stream);
        return decodedTransactionV0;
    }

    public static TransactionV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionV0.fromXdrByteArray(bytes);
    }

    public static TransactionV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionV0.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionV0Builder builder() {
        return new TransactionV0Builder();
    }

    @Generated
    public TransactionV0Builder toBuilder() {
        return new TransactionV0Builder().sourceAccountEd25519(this.sourceAccountEd25519).fee(this.fee).seqNum(this.seqNum).timeBounds(this.timeBounds).memo(this.memo).operations(this.operations).ext(this.ext);
    }

    @Generated
    public Uint256 getSourceAccountEd25519() {
        return this.sourceAccountEd25519;
    }

    @Generated
    public Uint32 getFee() {
        return this.fee;
    }

    @Generated
    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    @Generated
    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    @Generated
    public Memo getMemo() {
        return this.memo;
    }

    @Generated
    public Operation[] getOperations() {
        return this.operations;
    }

    @Generated
    public TransactionV0Ext getExt() {
        return this.ext;
    }

    @Generated
    public void setSourceAccountEd25519(Uint256 sourceAccountEd25519) {
        this.sourceAccountEd25519 = sourceAccountEd25519;
    }

    @Generated
    public void setFee(Uint32 fee) {
        this.fee = fee;
    }

    @Generated
    public void setSeqNum(SequenceNumber seqNum) {
        this.seqNum = seqNum;
    }

    @Generated
    public void setTimeBounds(TimeBounds timeBounds) {
        this.timeBounds = timeBounds;
    }

    @Generated
    public void setMemo(Memo memo) {
        this.memo = memo;
    }

    @Generated
    public void setOperations(Operation[] operations) {
        this.operations = operations;
    }

    @Generated
    public void setExt(TransactionV0Ext ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionV0)) {
            return false;
        }
        TransactionV0 other = (TransactionV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint256 this$sourceAccountEd25519 = this.getSourceAccountEd25519();
        Uint256 other$sourceAccountEd25519 = other.getSourceAccountEd25519();
        if (this$sourceAccountEd25519 == null ? other$sourceAccountEd25519 != null : !((Object)this$sourceAccountEd25519).equals(other$sourceAccountEd25519)) {
            return false;
        }
        Uint32 this$fee = this.getFee();
        Uint32 other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        SequenceNumber this$seqNum = this.getSeqNum();
        SequenceNumber other$seqNum = other.getSeqNum();
        if (this$seqNum == null ? other$seqNum != null : !((Object)this$seqNum).equals(other$seqNum)) {
            return false;
        }
        TimeBounds this$timeBounds = this.getTimeBounds();
        TimeBounds other$timeBounds = other.getTimeBounds();
        if (this$timeBounds == null ? other$timeBounds != null : !((Object)this$timeBounds).equals(other$timeBounds)) {
            return false;
        }
        Memo this$memo = this.getMemo();
        Memo other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !((Object)this$memo).equals(other$memo)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        TransactionV0Ext this$ext = this.getExt();
        TransactionV0Ext other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint256 $sourceAccountEd25519 = this.getSourceAccountEd25519();
        result = result * 59 + ($sourceAccountEd25519 == null ? 43 : ((Object)$sourceAccountEd25519).hashCode());
        Uint32 $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        SequenceNumber $seqNum = this.getSeqNum();
        result = result * 59 + ($seqNum == null ? 43 : ((Object)$seqNum).hashCode());
        TimeBounds $timeBounds = this.getTimeBounds();
        result = result * 59 + ($timeBounds == null ? 43 : ((Object)$timeBounds).hashCode());
        Memo $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : ((Object)$memo).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        TransactionV0Ext $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionV0(sourceAccountEd25519=" + this.getSourceAccountEd25519() + ", fee=" + this.getFee() + ", seqNum=" + this.getSeqNum() + ", timeBounds=" + this.getTimeBounds() + ", memo=" + this.getMemo() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public TransactionV0() {
    }

    @Generated
    public TransactionV0(Uint256 sourceAccountEd25519, Uint32 fee, SequenceNumber seqNum, TimeBounds timeBounds, Memo memo, Operation[] operations, TransactionV0Ext ext) {
        this.sourceAccountEd25519 = sourceAccountEd25519;
        this.fee = fee;
        this.seqNum = seqNum;
        this.timeBounds = timeBounds;
        this.memo = memo;
        this.operations = operations;
        this.ext = ext;
    }

    public static class TransactionV0Ext
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static TransactionV0Ext decode(XdrDataInputStream stream) throws IOException {
            TransactionV0Ext decodedTransactionV0Ext = new TransactionV0Ext();
            Integer discriminant = stream.readInt();
            decodedTransactionV0Ext.setDiscriminant(discriminant);
            switch (decodedTransactionV0Ext.getDiscriminant()) {
                default: 
            }
            return decodedTransactionV0Ext;
        }

        public static TransactionV0Ext fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionV0Ext.fromXdrByteArray(bytes);
        }

        public static TransactionV0Ext fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionV0Ext.decode(xdrDataInputStream);
        }

        @Generated
        public static TransactionV0ExtBuilder builder() {
            return new TransactionV0ExtBuilder();
        }

        @Generated
        public TransactionV0ExtBuilder toBuilder() {
            return new TransactionV0ExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionV0Ext)) {
                return false;
            }
            TransactionV0Ext other = (TransactionV0Ext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionV0Ext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionV0.TransactionV0Ext(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public TransactionV0Ext() {
        }

        @Generated
        public TransactionV0Ext(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class TransactionV0ExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            TransactionV0ExtBuilder() {
            }

            @Generated
            public TransactionV0ExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TransactionV0Ext build() {
                return new TransactionV0Ext(this.discriminant);
            }

            @Generated
            public String toString() {
                return "TransactionV0.TransactionV0Ext.TransactionV0ExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }

    @Generated
    public static class TransactionV0Builder {
        @Generated
        private Uint256 sourceAccountEd25519;
        @Generated
        private Uint32 fee;
        @Generated
        private SequenceNumber seqNum;
        @Generated
        private TimeBounds timeBounds;
        @Generated
        private Memo memo;
        @Generated
        private Operation[] operations;
        @Generated
        private TransactionV0Ext ext;

        @Generated
        TransactionV0Builder() {
        }

        @Generated
        public TransactionV0Builder sourceAccountEd25519(Uint256 sourceAccountEd25519) {
            this.sourceAccountEd25519 = sourceAccountEd25519;
            return this;
        }

        @Generated
        public TransactionV0Builder fee(Uint32 fee) {
            this.fee = fee;
            return this;
        }

        @Generated
        public TransactionV0Builder seqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
            return this;
        }

        @Generated
        public TransactionV0Builder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        @Generated
        public TransactionV0Builder memo(Memo memo) {
            this.memo = memo;
            return this;
        }

        @Generated
        public TransactionV0Builder operations(Operation[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionV0Builder ext(TransactionV0Ext ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TransactionV0 build() {
            return new TransactionV0(this.sourceAccountEd25519, this.fee, this.seqNum, this.timeBounds, this.memo, this.operations, this.ext);
        }

        @Generated
        public String toString() {
            return "TransactionV0.TransactionV0Builder(sourceAccountEd25519=" + this.sourceAccountEd25519 + ", fee=" + this.fee + ", seqNum=" + this.seqNum + ", timeBounds=" + this.timeBounds + ", memo=" + this.memo + ", operations=" + Arrays.deepToString(this.operations) + ", ext=" + this.ext + ")";
        }
    }
}

