// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AuthCert's original definition in the XDR file is:
 *
 * <pre>
 * struct AuthCert
 * {
 *     Curve25519Public pubkey;
 *     uint64 expiration;
 *     Signature sig;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AuthCert implements XdrElement {
  private Curve25519Public pubkey;
  private Uint64 expiration;
  private Signature sig;

  public void encode(XdrDataOutputStream stream) throws IOException {
    pubkey.encode(stream);
    expiration.encode(stream);
    sig.encode(stream);
  }

  public static AuthCert decode(XdrDataInputStream stream) throws IOException {
    AuthCert decodedAuthCert = new AuthCert();
    decodedAuthCert.pubkey = Curve25519Public.decode(stream);
    decodedAuthCert.expiration = Uint64.decode(stream);
    decodedAuthCert.sig = Signature.decode(stream);
    return decodedAuthCert;
  }

  public static AuthCert fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AuthCert fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
