// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ClaimableBalanceEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct ClaimableBalanceEntry
 * {
 *     // Unique identifier for this ClaimableBalanceEntry
 *     ClaimableBalanceID balanceID;
 *
 *     // List of claimants with associated predicate
 *     Claimant claimants&lt;10&gt;;
 *
 *     // Any asset including native
 *     Asset asset;
 *
 *     // Amount of asset
 *     int64 amount;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 1:
 *         ClaimableBalanceEntryExtensionV1 v1;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ClaimableBalanceEntry implements XdrElement {
  private ClaimableBalanceID balanceID;
  private Claimant[] claimants;
  private Asset asset;
  private Int64 amount;
  private ClaimableBalanceEntryExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    balanceID.encode(stream);
    int claimantsSize = getClaimants().length;
    stream.writeInt(claimantsSize);
    for (int i = 0; i < claimantsSize; i++) {
      claimants[i].encode(stream);
    }
    asset.encode(stream);
    amount.encode(stream);
    ext.encode(stream);
  }

  public static ClaimableBalanceEntry decode(XdrDataInputStream stream) throws IOException {
    ClaimableBalanceEntry decodedClaimableBalanceEntry = new ClaimableBalanceEntry();
    decodedClaimableBalanceEntry.balanceID = ClaimableBalanceID.decode(stream);
    int claimantsSize = stream.readInt();
    decodedClaimableBalanceEntry.claimants = new Claimant[claimantsSize];
    for (int i = 0; i < claimantsSize; i++) {
      decodedClaimableBalanceEntry.claimants[i] = Claimant.decode(stream);
    }
    decodedClaimableBalanceEntry.asset = Asset.decode(stream);
    decodedClaimableBalanceEntry.amount = Int64.decode(stream);
    decodedClaimableBalanceEntry.ext = ClaimableBalanceEntryExt.decode(stream);
    return decodedClaimableBalanceEntry;
  }

  public static ClaimableBalanceEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ClaimableBalanceEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * ClaimableBalanceEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 1:
   *         ClaimableBalanceEntryExtensionV1 v1;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class ClaimableBalanceEntryExt implements XdrElement {
    private Integer discriminant;
    private ClaimableBalanceEntryExtensionV1 v1;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          v1.encode(stream);
          break;
      }
    }

    public static ClaimableBalanceEntryExt decode(XdrDataInputStream stream) throws IOException {
      ClaimableBalanceEntryExt decodedClaimableBalanceEntryExt = new ClaimableBalanceEntryExt();
      Integer discriminant = stream.readInt();
      decodedClaimableBalanceEntryExt.setDiscriminant(discriminant);
      switch (decodedClaimableBalanceEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedClaimableBalanceEntryExt.v1 = ClaimableBalanceEntryExtensionV1.decode(stream);
          break;
      }
      return decodedClaimableBalanceEntryExt;
    }

    public static ClaimableBalanceEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static ClaimableBalanceEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
