// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ConfigSettingContractLedgerCostV0's original definition in the XDR file is:
 *
 * <pre>
 * struct ConfigSettingContractLedgerCostV0
 * {
 *     // Maximum number of disk entry read operations per ledger
 *     uint32 ledgerMaxDiskReadEntries;
 *     // Maximum number of bytes of disk reads that can be performed per ledger
 *     uint32 ledgerMaxDiskReadBytes;
 *     // Maximum number of ledger entry write operations per ledger
 *     uint32 ledgerMaxWriteLedgerEntries;
 *     // Maximum number of bytes that can be written per ledger
 *     uint32 ledgerMaxWriteBytes;
 *
 *     // Maximum number of disk entry read operations per transaction
 *     uint32 txMaxDiskReadEntries;
 *     // Maximum number of bytes of disk reads that can be performed per transaction
 *     uint32 txMaxDiskReadBytes;
 *     // Maximum number of ledger entry write operations per transaction
 *     uint32 txMaxWriteLedgerEntries;
 *     // Maximum number of bytes that can be written per transaction
 *     uint32 txMaxWriteBytes;
 *
 *     int64 feeDiskReadLedgerEntry;  // Fee per disk ledger entry read
 *     int64 feeWriteLedgerEntry;     // Fee per ledger entry write
 *
 *     int64 feeDiskRead1KB;          // Fee for reading 1KB disk
 *
 *     // The following parameters determine the write fee per 1KB.
 *     // Rent fee grows linearly until soroban state reaches this size
 *     int64 sorobanStateTargetSizeBytes;
 *     // Fee per 1KB rent when the soroban state is empty
 *     int64 rentFee1KBSorobanStateSizeLow;
 *     // Fee per 1KB rent when the soroban state has reached `sorobanStateTargetSizeBytes`
 *     int64 rentFee1KBSorobanStateSizeHigh;
 *     // Rent fee multiplier for any additional data past the first `sorobanStateTargetSizeBytes`
 *     uint32 sorobanStateRentFeeGrowthFactor;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ConfigSettingContractLedgerCostV0 implements XdrElement {
  private Uint32 ledgerMaxDiskReadEntries;
  private Uint32 ledgerMaxDiskReadBytes;
  private Uint32 ledgerMaxWriteLedgerEntries;
  private Uint32 ledgerMaxWriteBytes;
  private Uint32 txMaxDiskReadEntries;
  private Uint32 txMaxDiskReadBytes;
  private Uint32 txMaxWriteLedgerEntries;
  private Uint32 txMaxWriteBytes;
  private Int64 feeDiskReadLedgerEntry;
  private Int64 feeWriteLedgerEntry;
  private Int64 feeDiskRead1KB;
  private Int64 sorobanStateTargetSizeBytes;
  private Int64 rentFee1KBSorobanStateSizeLow;
  private Int64 rentFee1KBSorobanStateSizeHigh;
  private Uint32 sorobanStateRentFeeGrowthFactor;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ledgerMaxDiskReadEntries.encode(stream);
    ledgerMaxDiskReadBytes.encode(stream);
    ledgerMaxWriteLedgerEntries.encode(stream);
    ledgerMaxWriteBytes.encode(stream);
    txMaxDiskReadEntries.encode(stream);
    txMaxDiskReadBytes.encode(stream);
    txMaxWriteLedgerEntries.encode(stream);
    txMaxWriteBytes.encode(stream);
    feeDiskReadLedgerEntry.encode(stream);
    feeWriteLedgerEntry.encode(stream);
    feeDiskRead1KB.encode(stream);
    sorobanStateTargetSizeBytes.encode(stream);
    rentFee1KBSorobanStateSizeLow.encode(stream);
    rentFee1KBSorobanStateSizeHigh.encode(stream);
    sorobanStateRentFeeGrowthFactor.encode(stream);
  }

  public static ConfigSettingContractLedgerCostV0 decode(XdrDataInputStream stream)
      throws IOException {
    ConfigSettingContractLedgerCostV0 decodedConfigSettingContractLedgerCostV0 =
        new ConfigSettingContractLedgerCostV0();
    decodedConfigSettingContractLedgerCostV0.ledgerMaxDiskReadEntries = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.ledgerMaxDiskReadBytes = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.ledgerMaxWriteLedgerEntries = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.ledgerMaxWriteBytes = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.txMaxDiskReadEntries = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.txMaxDiskReadBytes = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.txMaxWriteLedgerEntries = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.txMaxWriteBytes = Uint32.decode(stream);
    decodedConfigSettingContractLedgerCostV0.feeDiskReadLedgerEntry = Int64.decode(stream);
    decodedConfigSettingContractLedgerCostV0.feeWriteLedgerEntry = Int64.decode(stream);
    decodedConfigSettingContractLedgerCostV0.feeDiskRead1KB = Int64.decode(stream);
    decodedConfigSettingContractLedgerCostV0.sorobanStateTargetSizeBytes = Int64.decode(stream);
    decodedConfigSettingContractLedgerCostV0.rentFee1KBSorobanStateSizeLow = Int64.decode(stream);
    decodedConfigSettingContractLedgerCostV0.rentFee1KBSorobanStateSizeHigh = Int64.decode(stream);
    decodedConfigSettingContractLedgerCostV0.sorobanStateRentFeeGrowthFactor =
        Uint32.decode(stream);
    return decodedConfigSettingContractLedgerCostV0;
  }

  public static ConfigSettingContractLedgerCostV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ConfigSettingContractLedgerCostV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
