// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Curve25519Secret's original definition in the XDR file is:
 *
 * <pre>
 * struct Curve25519Secret
 * {
 *     opaque key[32];
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Curve25519Secret implements XdrElement {
  private byte[] key;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int keySize = key.length;
    stream.write(getKey(), 0, keySize);
  }

  public static Curve25519Secret decode(XdrDataInputStream stream) throws IOException {
    Curve25519Secret decodedCurve25519Secret = new Curve25519Secret();
    int keySize = 32;
    decodedCurve25519Secret.key = new byte[keySize];
    stream.read(decodedCurve25519Secret.key, 0, keySize);
    return decodedCurve25519Secret;
  }

  public static Curve25519Secret fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Curve25519Secret fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
