// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Hello's original definition in the XDR file is:
 *
 * <pre>
 * struct Hello
 * {
 *     uint32 ledgerVersion;
 *     uint32 overlayVersion;
 *     uint32 overlayMinVersion;
 *     Hash networkID;
 *     string versionStr&lt;100&gt;;
 *     int listeningPort;
 *     NodeID peerID;
 *     AuthCert cert;
 *     uint256 nonce;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Hello implements XdrElement {
  private Uint32 ledgerVersion;
  private Uint32 overlayVersion;
  private Uint32 overlayMinVersion;
  private Hash networkID;
  private XdrString versionStr;
  private Integer listeningPort;
  private NodeID peerID;
  private AuthCert cert;
  private Uint256 nonce;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ledgerVersion.encode(stream);
    overlayVersion.encode(stream);
    overlayMinVersion.encode(stream);
    networkID.encode(stream);
    versionStr.encode(stream);
    stream.writeInt(listeningPort);
    peerID.encode(stream);
    cert.encode(stream);
    nonce.encode(stream);
  }

  public static Hello decode(XdrDataInputStream stream) throws IOException {
    Hello decodedHello = new Hello();
    decodedHello.ledgerVersion = Uint32.decode(stream);
    decodedHello.overlayVersion = Uint32.decode(stream);
    decodedHello.overlayMinVersion = Uint32.decode(stream);
    decodedHello.networkID = Hash.decode(stream);
    decodedHello.versionStr = XdrString.decode(stream, 100);
    decodedHello.listeningPort = stream.readInt();
    decodedHello.peerID = NodeID.decode(stream);
    decodedHello.cert = AuthCert.decode(stream);
    decodedHello.nonce = Uint256.decode(stream);
    return decodedHello;
  }

  public static Hello fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Hello fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
