// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerHeaderExtensionV1's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerHeaderExtensionV1
 * {
 *     uint32 flags; // LedgerHeaderFlags
 *
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerHeaderExtensionV1 implements XdrElement {
  private Uint32 flags;
  private LedgerHeaderExtensionV1Ext ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    flags.encode(stream);
    ext.encode(stream);
  }

  public static LedgerHeaderExtensionV1 decode(XdrDataInputStream stream) throws IOException {
    LedgerHeaderExtensionV1 decodedLedgerHeaderExtensionV1 = new LedgerHeaderExtensionV1();
    decodedLedgerHeaderExtensionV1.flags = Uint32.decode(stream);
    decodedLedgerHeaderExtensionV1.ext = LedgerHeaderExtensionV1Ext.decode(stream);
    return decodedLedgerHeaderExtensionV1;
  }

  public static LedgerHeaderExtensionV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerHeaderExtensionV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * LedgerHeaderExtensionV1Ext's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerHeaderExtensionV1Ext implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static LedgerHeaderExtensionV1Ext decode(XdrDataInputStream stream) throws IOException {
      LedgerHeaderExtensionV1Ext decodedLedgerHeaderExtensionV1Ext =
          new LedgerHeaderExtensionV1Ext();
      Integer discriminant = stream.readInt();
      decodedLedgerHeaderExtensionV1Ext.setDiscriminant(discriminant);
      switch (decodedLedgerHeaderExtensionV1Ext.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedLedgerHeaderExtensionV1Ext;
    }

    public static LedgerHeaderExtensionV1Ext fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerHeaderExtensionV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
