// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * LiquidityPoolWithdrawResultCode's original definition in the XDR file is:
 *
 * <pre>
 * enum LiquidityPoolWithdrawResultCode
 * {
 *     // codes considered as "success" for the operation
 *     LIQUIDITY_POOL_WITHDRAW_SUCCESS = 0,
 *
 *     // codes considered as "failure" for the operation
 *     LIQUIDITY_POOL_WITHDRAW_MALFORMED = -1,    // bad input
 *     LIQUIDITY_POOL_WITHDRAW_NO_TRUST = -2,     // no trust line for one of the
 *                                                // assets
 *     LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED = -3,  // not enough balance of the
 *                                                // pool share
 *     LIQUIDITY_POOL_WITHDRAW_LINE_FULL = -4,    // would go above limit for one
 *                                                // of the assets
 *     LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM = -5 // didn't withdraw enough
 * };
 * </pre>
 */
public enum LiquidityPoolWithdrawResultCode implements XdrElement {
  LIQUIDITY_POOL_WITHDRAW_SUCCESS(0),
  LIQUIDITY_POOL_WITHDRAW_MALFORMED(-1),
  LIQUIDITY_POOL_WITHDRAW_NO_TRUST(-2),
  LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED(-3),
  LIQUIDITY_POOL_WITHDRAW_LINE_FULL(-4),
  LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM(-5);

  private final int value;

  LiquidityPoolWithdrawResultCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static LiquidityPoolWithdrawResultCode decode(XdrDataInputStream stream)
      throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return LIQUIDITY_POOL_WITHDRAW_SUCCESS;
      case -1:
        return LIQUIDITY_POOL_WITHDRAW_MALFORMED;
      case -2:
        return LIQUIDITY_POOL_WITHDRAW_NO_TRUST;
      case -3:
        return LIQUIDITY_POOL_WITHDRAW_UNDERFUNDED;
      case -4:
        return LIQUIDITY_POOL_WITHDRAW_LINE_FULL;
      case -5:
        return LIQUIDITY_POOL_WITHDRAW_UNDER_MINIMUM;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static LiquidityPoolWithdrawResultCode fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LiquidityPoolWithdrawResultCode fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
