// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ManageDataOp's original definition in the XDR file is:
 *
 * <pre>
 * struct ManageDataOp
 * {
 *     string64 dataName;
 *     DataValue&#42; dataValue; // set to null to clear
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ManageDataOp implements XdrElement {
  private String64 dataName;
  private DataValue dataValue;

  public void encode(XdrDataOutputStream stream) throws IOException {
    dataName.encode(stream);
    if (dataValue != null) {
      stream.writeInt(1);
      dataValue.encode(stream);
    } else {
      stream.writeInt(0);
    }
  }

  public static ManageDataOp decode(XdrDataInputStream stream) throws IOException {
    ManageDataOp decodedManageDataOp = new ManageDataOp();
    decodedManageDataOp.dataName = String64.decode(stream);
    int dataValuePresent = stream.readInt();
    if (dataValuePresent != 0) {
      decodedManageDataOp.dataValue = DataValue.decode(stream);
    }
    return decodedManageDataOp;
  }

  public static ManageDataOp fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ManageDataOp fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
