// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PeerStats's original definition in the XDR file is:
 *
 * <pre>
 * struct PeerStats
 * {
 *     NodeID id;
 *     string versionStr&lt;100&gt;;
 *     uint64 messagesRead;
 *     uint64 messagesWritten;
 *     uint64 bytesRead;
 *     uint64 bytesWritten;
 *     uint64 secondsConnected;
 *
 *     uint64 uniqueFloodBytesRecv;
 *     uint64 duplicateFloodBytesRecv;
 *     uint64 uniqueFetchBytesRecv;
 *     uint64 duplicateFetchBytesRecv;
 *
 *     uint64 uniqueFloodMessageRecv;
 *     uint64 duplicateFloodMessageRecv;
 *     uint64 uniqueFetchMessageRecv;
 *     uint64 duplicateFetchMessageRecv;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PeerStats implements XdrElement {
  private NodeID id;
  private XdrString versionStr;
  private Uint64 messagesRead;
  private Uint64 messagesWritten;
  private Uint64 bytesRead;
  private Uint64 bytesWritten;
  private Uint64 secondsConnected;
  private Uint64 uniqueFloodBytesRecv;
  private Uint64 duplicateFloodBytesRecv;
  private Uint64 uniqueFetchBytesRecv;
  private Uint64 duplicateFetchBytesRecv;
  private Uint64 uniqueFloodMessageRecv;
  private Uint64 duplicateFloodMessageRecv;
  private Uint64 uniqueFetchMessageRecv;
  private Uint64 duplicateFetchMessageRecv;

  public void encode(XdrDataOutputStream stream) throws IOException {
    id.encode(stream);
    versionStr.encode(stream);
    messagesRead.encode(stream);
    messagesWritten.encode(stream);
    bytesRead.encode(stream);
    bytesWritten.encode(stream);
    secondsConnected.encode(stream);
    uniqueFloodBytesRecv.encode(stream);
    duplicateFloodBytesRecv.encode(stream);
    uniqueFetchBytesRecv.encode(stream);
    duplicateFetchBytesRecv.encode(stream);
    uniqueFloodMessageRecv.encode(stream);
    duplicateFloodMessageRecv.encode(stream);
    uniqueFetchMessageRecv.encode(stream);
    duplicateFetchMessageRecv.encode(stream);
  }

  public static PeerStats decode(XdrDataInputStream stream) throws IOException {
    PeerStats decodedPeerStats = new PeerStats();
    decodedPeerStats.id = NodeID.decode(stream);
    decodedPeerStats.versionStr = XdrString.decode(stream, 100);
    decodedPeerStats.messagesRead = Uint64.decode(stream);
    decodedPeerStats.messagesWritten = Uint64.decode(stream);
    decodedPeerStats.bytesRead = Uint64.decode(stream);
    decodedPeerStats.bytesWritten = Uint64.decode(stream);
    decodedPeerStats.secondsConnected = Uint64.decode(stream);
    decodedPeerStats.uniqueFloodBytesRecv = Uint64.decode(stream);
    decodedPeerStats.duplicateFloodBytesRecv = Uint64.decode(stream);
    decodedPeerStats.uniqueFetchBytesRecv = Uint64.decode(stream);
    decodedPeerStats.duplicateFetchBytesRecv = Uint64.decode(stream);
    decodedPeerStats.uniqueFloodMessageRecv = Uint64.decode(stream);
    decodedPeerStats.duplicateFloodMessageRecv = Uint64.decode(stream);
    decodedPeerStats.uniqueFetchMessageRecv = Uint64.decode(stream);
    decodedPeerStats.duplicateFetchMessageRecv = Uint64.decode(stream);
    return decodedPeerStats;
  }

  public static PeerStats fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PeerStats fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
