// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCSpecEventV0's original definition in the XDR file is:
 *
 * <pre>
 * struct SCSpecEventV0
 * {
 *     string doc&lt;SC_SPEC_DOC_LIMIT&gt;;
 *     string lib&lt;80&gt;;
 *     SCSymbol name;
 *     SCSymbol prefixTopics&lt;2&gt;;
 *     SCSpecEventParamV0 params&lt;50&gt;;
 *     SCSpecEventDataFormat dataFormat;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCSpecEventV0 implements XdrElement {
  private XdrString doc;
  private XdrString lib;
  private SCSymbol name;
  private SCSymbol[] prefixTopics;
  private SCSpecEventParamV0[] params;
  private SCSpecEventDataFormat dataFormat;

  public void encode(XdrDataOutputStream stream) throws IOException {
    doc.encode(stream);
    lib.encode(stream);
    name.encode(stream);
    int prefixTopicsSize = getPrefixTopics().length;
    stream.writeInt(prefixTopicsSize);
    for (int i = 0; i < prefixTopicsSize; i++) {
      prefixTopics[i].encode(stream);
    }
    int paramsSize = getParams().length;
    stream.writeInt(paramsSize);
    for (int i = 0; i < paramsSize; i++) {
      params[i].encode(stream);
    }
    dataFormat.encode(stream);
  }

  public static SCSpecEventV0 decode(XdrDataInputStream stream) throws IOException {
    SCSpecEventV0 decodedSCSpecEventV0 = new SCSpecEventV0();
    decodedSCSpecEventV0.doc = XdrString.decode(stream, Constants.SC_SPEC_DOC_LIMIT);
    decodedSCSpecEventV0.lib = XdrString.decode(stream, 80);
    decodedSCSpecEventV0.name = SCSymbol.decode(stream);
    int prefixTopicsSize = stream.readInt();
    decodedSCSpecEventV0.prefixTopics = new SCSymbol[prefixTopicsSize];
    for (int i = 0; i < prefixTopicsSize; i++) {
      decodedSCSpecEventV0.prefixTopics[i] = SCSymbol.decode(stream);
    }
    int paramsSize = stream.readInt();
    decodedSCSpecEventV0.params = new SCSpecEventParamV0[paramsSize];
    for (int i = 0; i < paramsSize; i++) {
      decodedSCSpecEventV0.params[i] = SCSpecEventParamV0.decode(stream);
    }
    decodedSCSpecEventV0.dataFormat = SCSpecEventDataFormat.decode(stream);
    return decodedSCSpecEventV0;
  }

  public static SCSpecEventV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCSpecEventV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
