// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SurveyResponseMessage's original definition in the XDR file is:
 *
 * <pre>
 * struct SurveyResponseMessage
 * {
 *     NodeID surveyorPeerID;
 *     NodeID surveyedPeerID;
 *     uint32 ledgerNum;
 *     SurveyMessageCommandType commandType;
 *     EncryptedBody encryptedBody;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SurveyResponseMessage implements XdrElement {
  private NodeID surveyorPeerID;
  private NodeID surveyedPeerID;
  private Uint32 ledgerNum;
  private SurveyMessageCommandType commandType;
  private EncryptedBody encryptedBody;

  public void encode(XdrDataOutputStream stream) throws IOException {
    surveyorPeerID.encode(stream);
    surveyedPeerID.encode(stream);
    ledgerNum.encode(stream);
    commandType.encode(stream);
    encryptedBody.encode(stream);
  }

  public static SurveyResponseMessage decode(XdrDataInputStream stream) throws IOException {
    SurveyResponseMessage decodedSurveyResponseMessage = new SurveyResponseMessage();
    decodedSurveyResponseMessage.surveyorPeerID = NodeID.decode(stream);
    decodedSurveyResponseMessage.surveyedPeerID = NodeID.decode(stream);
    decodedSurveyResponseMessage.ledgerNum = Uint32.decode(stream);
    decodedSurveyResponseMessage.commandType = SurveyMessageCommandType.decode(stream);
    decodedSurveyResponseMessage.encryptedBody = EncryptedBody.decode(stream);
    return decodedSurveyResponseMessage;
  }

  public static SurveyResponseMessage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SurveyResponseMessage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
